<!DOCTYPE style-sheet PUBLIC "-//James Clark//DTD DSSSL Style Sheet//EN">

<style-sheet>
<style-specification>
<style-specification-body>
(declare-flow-object-class element
  "UNREGISTERED::James Clark//Flow Object Class::element")

(define debug
  (external-procedure "UNREGISTERED::James Clark//Procedure::debug"))

(define (break-node-list nodes breakatgi)
  (let loop ((nl nodes) (result '()) (curlist (empty-node-list)))
    (if (node-list-empty? nl)
	(if (node-list-empty? curlist)
	    result
	    (append result (list curlist)))
	(if (equal? (gi (node-list-first nl)) breakatgi)
	    (loop (node-list-rest nl)
		  (if (node-list-empty? curlist)
		      result
		      (append result (list curlist)))
		  (node-list-first nl))
	    (loop (node-list-rest nl)
		  result
		  (node-list curlist (node-list-first nl)))))))

(define (process-primary primnode secnl)
  (let ((see?     (equal? (gi (node-list-first secnl)) "SEEIE"))
	(seealso? (equal? (gi (node-list-first secnl)) "SEEALSOIE")))
    (make sequence
      (make element gi: "P"
	    (if (or see? seealso?)
		(process-terminal primnode secnl)
		(let ((second (break-node-list secnl "SECONDARYIE")))
		  (let sloop ((secs second))
		    (if (null? secs)
			(empty-sosofo)
			(make sequence
			  (let* ((nodes (car secs))
				 (sec   (node-list-first nodes))
				 (terts (node-list-rest nodes)))
			    (process-secondary sec terts))
			  (sloop (cdr secs)))))))))))

(define (process-secondary secnode tertnl)
  (let ((see?     (equal? (gi (node-list-first tertnl)) "SEEIE"))
	(seealso? (equal? (gi (node-list-first tertnl)) "SEEALSOIE")))
    (make sequence
      (make element gi: "S"
	    (if (or see? seealso?)
		(process-terminal secnode tertnl)
		(let ((tert (break-node-list tertnl "TERTIARYIE")))
		  (let tloop ((terts tert))
		    (if (null? terts)
			(empty-sosofo)
			(make sequence
			  (let* ((nodes (car terts))
				 (tert  (node-list-first nodes))
				 (sees  (node-list-rest nodes)))
			    (process-tertiary tert sees))
			  (tloop (cdr terts)))))))))))

(define (process-tertiary tertnode seenl)
  (make element gi: "T"
	(process-terminal tertnode seenl)))

(define (process-terminal node seenl)
  (make element gi: "X"
	(if (node-list-empty? seenl)
	    (empty-sosofo)
	    (make element gi: "SEE"
		  (empty-sosofo)))))

(element indexentry
  (let ((primary (break-node-list (children (current-node)) "PRIMARYIE")))
    (let ploop ((prims primary))
      (if (null? prims)
	  (empty-sosofo)
	  (make sequence
	    (let* ((nodes (car prims))
		   (prim  (node-list-first nodes))
		   (secs  (node-list-rest nodes)))
	      (process-primary prim secs))
	    (ploop (cdr prims)))))))

</style-specification-body>
</style-specification>
</style-sheet>
