## -*- perl -*-
## ----------------------------------------------------------------------
## DebianDoc_SGML/Map/HTML: Data map for HTML output format
## ----------------------------------------------------------------------
## Copyright (C) 1999,2000 Ardo van Rangelrooij
##
## This is free software; see the GNU General Public Licence
## version 2 or later for copying conditions.  There is NO warranty.
## ----------------------------------------------------------------------

## ----------------------------------------------------------------------
## package interface definition
#package DebianDoc_SGML::Map::HTML;
#use strict;
#use vars qw( @ISA @EXPORT );
#use Exporter;
#@ISA = ( 'Exporter' );
#@EXPORT = qw ();

## ----------------------------------------------------------------------
%sdata_mapping = (
		  "[acute]" => "",
		  "[breve]" => "",
		  "[caron]" => "",
		  "[cedil]" => "",
		  "[circ]" => "^",
		  "[dblac]" => "",
		  "[die]" => "",
		  "[dot]" => "\&dot;",
		  "[grave]" => "\\",
		  "[macr]" => "",
		  "[ogon]" => "",
		  "[ring]" => "",
		  "[tilde]" => "~",
		  "[uml]" => "",
		  "[aacute]" => "\&aacute;",
		  "[Aacute]" => "\&Aacute;",
		  "[acirc]" => "\&acirc;",
		  "[Acirc]" => "\&Acirc;",
		  "[agrave]" => "\&agrave;",
		  "[Agrave]" => "\&Agrave;",
		  "[aring]" => "\&aring;",
		  "[Aring]" => "\&Aring;",
		  "[atilde]" => "\&atilde;",
		  "[Atilde]" => "\&Atilde;",
		  "[auml]" => "\&auml;",
		  "[Auml]" => "\&Auml;",
		  "[aelig]" => "\&aelig;",
		  "[AElig]" => "\&AElig;",
		  "[ccedil]" => "\&ccedil;",
		  "[Ccedil]" => "\&Ccedil;",
		  "[eth]" => "\&eth;",
		  "[ETH]" => "\&ETH;",
		  "[eacute]" => "\&eacute;",
		  "[Eacute]" => "\&Eacute;",
		  "[ecirc]" => "\&ecirc;",
		  "[Ecirc]" => "\&Ecirc;",
		  "[egrave]" => "\&egrave;",
		  "[Egrave]" => "\&Egrave;",
		  "[euml]" => "\&euml;",
		  "[Euml]" => "\&Euml;",
		  "[iacute]" => "\&iacute;",
		  "[Iacute]" => "\&Iacute;",
		  "[icirc]" => "\&icirc;",
		  "[Icirc]" => "\&Icirc;",
		  "[igrave]" => "\&igrave;",
		  "[Igrave]" => "\&Igrave;",
		  "[iuml]" => "\&iuml;",
		  "[Iuml]" => "\&Iuml;",
		  "[ntilde]" => "\&ntilde;",
		  "[Ntilde]" => "\&Ntilde;",
		  "[oacute]" => "\&oacute;",
		  "[Oacute]" => "\&Oacute;",
		  "[ocirc]" => "\&ocirc;",
		  "[Ocirc]" => "\&Ocirc;",
		  "[ograve]" => "\&ograve;",
		  "[Ograve]" => "\&Ograve;",
		  "[oslash]" => "\&oslash;",
		  "[Oslash]" => "\&Oslash;",
		  "[otilde]" => "\&otilde;",
		  "[Otilde]" => "\&Otilde;",
		  "[ouml]" => "\&ouml;",
		  "[Ouml]" => "\&Ouml;",
		  "[szlig]" => "\&szlig;",
		  "[thorn]" => "\&thorn;",
		  "[THORN]" => "\&THORN;",
		  "[uacute]" => "\&uacute;",
		  "[Uacute]" => "\&Uacute;",
		  "[ucirc]" => "\&ucirc;",
		  "[Ucirc]" => "\&Ucirc;",
		  "[ugrave]" => "\&ugrave;",
		  "[Ugrave]" => "\&Ugrave;",
		  "[uuml]" => "\&uuml;",
		  "[Uuml]" => "\&Uuml;",
		  "[yacute]" => "\&yacute;",
		  "[Yacute]" => "\&Yacute;",
		  "[yuml]" => "\&yuml;",
		  "[half]" => "1/2",
		  "[frac12]" => "1/2",
		  "[frac14]" => "1/4",
		  "[frac34]" => "3/4",
		  "[frac18]" => "1/8",
		  "[frac38]" => "3/8",
		  "[frac58]" => "5/8",
		  "[frac78]" => "7/8",
		  "[sup1]" => "^1",
		  "[sup2]" => "^2",
		  "[sup3]" => "^3",
		  "[plus]" => "\&plus;",
		  "[plusmn]" => "\&plusmn;",
		  "[lt]" => "\&lt;",
		  "[equals]" => "\&equals;",
		  "[gt]" => "\&gt;",
		  "[divide]" => "\&divide;",
		  "[times]" => "\&times;",
		  "[curren]" => "\&curren;",
		  "[pound]" => "",
		  "[dollar]" => "\$",
		  "[cent]" => "\&cent;",
		  "[yen]" => "\&yen;",
		  "[num]" => "#",
		  "[percnt]" => "%",
		  "[amp]" => "\&amp;",
		  "[ast]" => "\&ast;",
		  "[commat]" => "\&commat;",
		  "[lsqb]" => "[",
		  "[bsol]" => "\\",
		  "[rsqb]" => "]",
		  "[lcub]" => "{",
		  "[horbar]" => "\&horbar;",
		  "[verbar]" => "|",
		  "[rcub]" => "}",
		  "[micro]" => "\&micro;",
		  "[ohm]" => "\&ohm;",
		  "[deg]" => "\&deg;",
		  "[ordm]" => "\&ordm;",
		  "[ordf]" => "\&ordf;",
		  "[sect]" => "\&sect;",
		  "[para]" => "\&para;",
		  "[middot]" => "\&middot;",
		  "[larr]" => "\&larr;",
		  "[rarr]" => "-\&gt;",
		  "[uarr]" => "\&uarr;",
		  "[darr]" => "\&darr;",
		  "[copy]" => "\&copy;",
		  "[reg]" => "\&reg;",
		  "[trade]" => "\&trade;",
		  "[brvbar]" => "\&brvbar;",
		  "[not]" => "\&not;",
		  "[sung]" => "\&sung;",
		  "[excl]" => "\&excl;",
		  "[iexcl]" => "\&iexcl;",
		  "[quot]" => "\&quot;",
		  "[apos]" => "\&apos;",
		  "[lpar]" => "\&lpar;",
		  "[rpar]" => "\&rpar;",
		  "[comma]" => "\&comma;",
		  "[lowbar]" => "_",
		  "[hyphen]" => "\&hyphen;",
		  "[period]" => "\&period;",
		  "[sol]" => "\&sol;",
		  "[colon]" => "\&colon;",
		  "[semi]" => "\&semi;",
		  "[quest]" => "\&quest;",
		  "[iquest]" => "\&iquest;",
		  "[laquo]" => "\&laquo;",
		  "[raquo]" => "\&raquo;",
		  "[lsquo]" => "\&lsquo;",
		  "[rsquo]" => "\&rsquo;",
		  "[ldquo]" => "\&ldquo;",
		  "[rdquo]" => "\&rdquo;",
		  "[nbsp]" => "\&nbsp;",
		  "[shy]" => "\&shy;",
		  "[emsp]" => "\&emsp;",
		  "[ensp]" => "\&ensp;",
		  "[emsp3]" => "\&emsp3;",
		  "[emsp4]" => "\&emsp4;",
		  "[numsp]" => "\&numsp;",
		  "[puncsp]" => "\&puncs;",
		  "[thinsp]" => "\&thinsp;",
		  "[hairsp]" => "\&hairsp;",
		  "[mdash]" => "\&mdash;",
		  "[ndash]" => "\&ndash;",
		  "[dash]" => "\&dash;",
		  "[blank]" => "\&blank;",
		  "[hellip]" => "&hellip;",
		  "[nldr]" => "\&nldr;",
		  "[frac13]" => "\&frac13;",
		  "[frac23]" => "\&frac23;",
		  "[frac15]" => "\&frac15;",
		  "[frac25]" => "\&frac25;",
		  "[frac35]" => "\&frac35;",
		  "[frac45]" => "\&frac45;",
		  "[frac16]" => "\&frac16;",
		  "[frac56]" => "\&frac56;",
		  "[incare]" => "\&incare;",
		  "[block]" => "\&block;",
		  "[uhblk]" => "\&uhblk;",
		  "[lhblk]" => "\&lhblk;",
		  "[blk14]" => "\&blk14;",
		  "[blk12]" => "\&blk12;",
		  "[blk34]" => "\&blk34;",
		  "[marker]" => "\&marker;",
		  "[cir]" => "\&cir;",
		  "[squ]" => "\&squ;",
		  "[rect]" => "\&rect;",
		  "[utri]" => "\&utri;",
		  "[dtri]" => "\&dtri;",
		  "[star]" => "\&star;",
		  "[bull]" => "\&bull;",
		  "[squf]" => "\&squf;",
		  "[utrif]" => "\&utrif;",
		  "[dtrif]" => "\&dtrif;",
		  "[ltrif]" => "\&ltrif;",
		  "[rtrif]" => "\&rtrif;",
		  "[clubs]" => "\&clubs;",
		  "[diams]" => "\&diams;",
		  "[hearts]" => "\&hearts;",
		  "[spades]" => "\&spades;",
		  "[malt]" => "\&malt;",
		  "[dagger]" => "\&dagger;",
		  "[Dagger]" => "\&Dagger;",
		  "[check]" => "\&check;",
		  "[ballot]" => "\&ballot;",
		  "[sharp]" => "\&sharp;",
		  "[flat]" => "\&flat;",
		  "[male]" => "\&male;",
		  "[female]" => "\&female;",
		  "[phone]" => "\&phone;",
		  "[telrec]" => "\&telrec;",
		  "[copysr]" => "\&copysr;",
		  "[caret]" => "\&caret;",
		  "[lsquor]" => "\&lsquor;",
		  "[ldquor]" => "\&ldquor;",
		  "[fflig]" => "\&fflig;",
		  "[filig]" => "\&filig;",
		  "[fjlig]" => "\&fjlig;",
		  "[ffilig]" => "\&ffilig;",
		  "[ffllig]" => "\&ffllig;",
		  "[fllig]" => "\&fllig;",
		  "[mldr]" => "\&mldr;",
		  "[rdquor]" => "\&rdquor;",
		  "[rsquor]" => "\&rsquor;",
		  "[vellip]" => "\&vellip;",
		  "[hybull]" => "\&hybull;",
		  "[loz]" => "\&loz;",
		  "[lozf]" => "\&lozf;",
		  "[ltri]" => "\&ltri;",
		  "[rtri]" => "\&rtri;",
		  "[starf]" => "\&starf;",
		  "[natur]" => "\&natur;",
		  "[rx]" => "\&rx;",
		  "[sext]" => "\&sext;",
		  "[target]" => "\&target;",
		  "[dlcrop]" => "\&dlcrop;",
		  "[drcrop]" => "\&drcrop;",
		  "[ulcrop]" => "\&ulcrop;",
		  "[urcrop]" => "\&urcrop;",
		  "[tex]" => "TeX",
		  "[latex]" => "LaTeX",
		  "[latexe]" => "LaTeX2e",
		  "[aleph]" => "\&aleph;",
		  "[and]" => "\&and;",
		  "[ang90]" => "\&ang90;",
		  "[angsph]" => "\&angsph;",
		  "[ap]" => "\&ap;",
		  "[becaus]" => "\&becaus;",
		  "[bottom]" => "\&bottom;",
		  "[cap]" => "\&cap;",
		  "[cong]" => "\&cong;",
		  "[conint]" => "\&conint;",
		  "[cup]" => "\&cup;",
		  "[equiv]" => "\&equiv;",
		  "[exist]" => "\&exist;",
		  "[forall]" => "\&forall;",
		  "[fnof]" => "\&fnof;",
		  "[ge]" => "\&ge;",
		  "[iff]" => "\&iff;",
		  "[infin]" => "\&infin;",
		  "[int]" => "\&int;",
		  "[isin]" => "\&isin;",
		  "[lang]" => "\&lang;",
		  "[lArr]" => "\&lArr;",
		  "[le]" => "\&le;",
		  "[minus]" => "\&minus;",
		  "[mnplus]" => "\&mnplus;",
		  "[nabla]" => "\&nabla;",
		  "[ne]" => "\&ne;",
		  "[ni]" => "\&ni;",
		  "[or]" => "\&or;",
		  "[par]" => "\&par;",
		  "[part]" => "\&part;",
		  "[permil]" => "\&permil;",
		  "[perp]" => "\&perp;",
		  "[prime]" => "\&prime;",
		  "[Prime]" => "\&Prime;",
		  "[prop]" => "\&prop;",
		  "[radic]" => "\&radic;",
		  "[rang]" => "\&rang;",
		  "[rArr]" => "\&rArr;",
		  "[sim]" => "\&sim;",
		  "[sime]" => "\&sime;",
		  "[square]" => "\&square;",
		  "[sub]" => "\&sub;",
		  "[sube]" => "\&sube;",
		  "[sup]" => "\&sup;",
		  "[supe]" => "\&supe;",
		  "[there4]" => "\&there4;",
		  "[Verbar]" => "\&Verbar;",
		  "[angst]" => "\&angst;",
		  "[bernou]" => "\&bernou;",
		  "[compfn]" => "\&compfn;",
		  "[Dot]" => "\&Dot;",
		  "[DotDot]" => "\&DotDot;",
		  "[hamilt]" => "\&hamilt;",
		  "[lagran]" => "\&lagran;",
		  "[lowast]" => "\&lowast;",
		  "[notin]" => "\&notin;",
		  "[order]" => "\&order;",
		  "[phmmat]" => "\&phmmat;",
		  "[tdot]" => "\&tdot;",
		  "[tprime]" => "\&tprime;",
		  "[wedgeq]" => "\&wedgeq;",
		  );

## ----------------------------------------------------------------------
## don't forget this
1;

## ----------------------------------------------------------------------
