## -*- perl -*-
## ----------------------------------------------------------------------
## DebianDoc_SGML/Map/Texinfo: Data map for Texinfo output format
## ----------------------------------------------------------------------
## Copyright (C) 1999,2000 Ardo van Rangelrooij
##
## This is free software; see the GNU General Public Licence
## version 2 or later for copying conditions.  There is NO warranty.
## ----------------------------------------------------------------------

## ----------------------------------------------------------------------
## package interface definition
#package DebianDoc_SGML::Map::Texinfo;
#use strict;
#use vars qw( @ISA @EXPORT );
#use Exporter;
#@ISA = ( 'Exporter' );
#@EXPORT = qw ();

## ----------------------------------------------------------------------
%sdata_mapping = (
		  "[acute]" => "",
		  "[breve]" => "",
		  "[caron]" => "",
		  "[cedil]" => "",
		  "[circ]" => "",
		  "[dblac]" => "",
		  "[die]" => "",
		  "[dot]" => "",
		  "[grave]" => "",
		  "[macr]" => "",
		  "[ogon]" => "",
		  "[ring]" => "",
		  "[tilde]" => "",
		  "[uml]" => "",
		  "[aacute]" => "a",
		  "[Aacute]" => "A",
		  "[acirc]" => "a",
		  "[Acirc]" => "A",
		  "[agrave]" => "a",
		  "[Agrave]" => "A",
		  "[aring]" => "aa",
		  "[Aring]" => "AA",
		  "[atilde]" => "a",
		  "[Atilde]" => "A",
		  "[auml]" => "ae",
		  "[Auml]" => "Ae",
		  "[aelig]" => "ae",
		  "[AElig]" => "AE",
		  "[ccedil]" => "c",
		  "[Ccedil]" => "C",
		  "[eth]" => "d",
		  "[ETH]" => "D",
		  "[eacute]" => "e",
		  "[Eacute]" => "E",
		  "[ecirc]" => "e",
		  "[Ecirc]" => "E",
		  "[egrave]" => "e",
		  "[Egrave]" => "E",
		  "[euml]" => "e",
		  "[Euml]" => "E",
		  "[iacute]" => "i",
		  "[Iacute]" => "I",
		  "[icirc]" => "i",
		  "[Icirc]" => "I",
		  "[igrave]" => "i",
		  "[Igrave]" => "I",
		  "[iuml]" => "i",
		  "[Iuml]" => "I",
		  "[ntilde]" => "n",
		  "[Ntilde]" => "N",
		  "[oacute]" => "o",
		  "[Oacute]" => "O",
		  "[ocirc]" => "o",
		  "[Ocirc]" => "O",
		  "[ograve]" => "o",
		  "[Ograve]" => "O",
		  "[oslash]" => "oe",
		  "[Oslash]" => "OE",
		  "[otilde]" => "o",
		  "[Otilde]" => "O",
		  "[ouml]" => "oe",
		  "[Ouml]" => "Oe",
		  "[szlig]" => "ss",
		  "[thorn]" => "th",
		  "[THORN]" => "Th",
		  "[uacute]" => "u",
		  "[Uacute]" => "U",
		  "[ucirc]" => "u",
		  "[Ucirc]" => "U",
		  "[ugrave]" => "u",
		  "[Ugrave]" => "U",
		  "[uuml]" => "ue",
		  "[Uuml]" => "Ue",
		  "[yacute]" => "y",
		  "[Yacute]" => "Y",
		  "[yuml]" => "y",
		  "[abreve]" => "a",
		  "[Abreve]" => "A",
		  "[amacr]" => "a",
		  "[Amacr]" => "A",
		  "[aogon]" => "a",
		  "[Aogon]" => "A",
		  "[cacute]" => "c",
		  "[Cacute]" => "C",
		  "[ccaron]" => "c",
		  "[Ccaron]" => "C",
		  "[ccirc]" => "c",
		  "[Ccirc]" => "C",
		  "[cdot]" => "c",
		  "[Cdot]" => "C",
		  "[dcaron]" => "d",
		  "[Dcaron]" => "D",
		  "[dstrok]" => "d",
		  "[Dstrok]" => "D",
		  "[ecaron]" => "e",
		  "[Ecaron]" => "E",
		  "[edot]" => "e",
		  "[Edot]" => "E",
		  "[emacr]" => "e",
		  "[Emacr]" => "E",
		  "[eogon]" => "e",
		  "[Eogon]" => "E",
		  "[gacute]" => "g",
		  "[gbreve]" => "g",
		  "[Gbreve]" => "G",
		  "[Gcedil]" => "G",
		  "[gcirc]" => "g",
		  "[Gcirc]" => "G",
		  "[gdot]" => "g",
		  "[Gdot]" => "G",
		  "[hcirc]" => "h",
		  "[Hcirc]" => "H",
		  "[hstrok]" => "h",
		  "[Hstrok]" => "H",
		  "[Idot]" => "I",
		  "[Imacr]" => "I",
		  "[imacr]" => "i",
		  "[ijlig]" => "ij",
		  "[IJlig]" => "IJ",
		  "[inodot]" => "i",
		  "[iogon]" => "i",
		  "[Iogon]" => "I",
		  "[itilde]" => "i",
		  "[Itilde]" => "I",
		  "[jcirc]" => "j",
		  "[Jcirc]" => "J",
		  "[kcedil]" => "k",
		  "[Kcedil]" => "K",
		  "[kgreen]" => "k",
		  "[lacute]" => "l",
		  "[Lacute]" => "L",
		  "[lcaron]" => "l",
		  "[Lcaron]" => "L",
		  "[lcedil]" => "l",
		  "[Lcedil]" => "L",
		  "[lmidot]" => "l",
		  "[Lmidot]" => "L",
		  "[lstrok]" => "l",
		  "[Lstrok]" => "L",
		  "[nacute]" => "n",
		  "[Nacute]" => "N",
		  "[eng]" => "\@{eng\@}",
		  "[ENG]" => "\@{ENG\@}",
		  "[napos]" => "n",
		  "[ncaron]" => "n",
		  "[Ncaron]" => "N",
		  "[ncedil]" => "n",
		  "[Ncedil]" => "N",
		  "[odblac]" => "o",
		  "[Odblac]" => "O",
		  "[Omacr]" => "O",
		  "[omacr]" => "o",
		  "[oelig]" => "oe",
		  "[OElig]" => "OE",
		  "[racute]" => "r",
		  "[Racute]" => "R",
		  "[rcaron]" => "r",
		  "[Rcaron]" => "R",
		  "[rcedil]" => "r",
		  "[Rcedil]" => "R",
		  "[sacute]" => "s",
		  "[Sacute]" => "S",
		  "[scaron]" => "s",
		  "[Scaron]" => "S",
		  "[scedil]" => "s",
		  "[Scedil]" => "S",
		  "[scirc]" => "s",
		  "[Scirc]" => "S",
		  "[tcaron]" => "t",
		  "[Tcaron]" => "T",
		  "[tcedil]" => "t",
		  "[Tcedil]" => "T",
		  "[tstrok]" => "t",
		  "[Tstrok]" => "T",
		  "[ubreve]" => "u",
		  "[Ubreve]" => "U",
		  "[udblac]" => "u",
		  "[Udblac]" => "U",
		  "[umacr]" => "u",
		  "[Umacr]" => "U",
		  "[uogon]" => "u",
		  "[Uogon]" => "U",
		  "[uring]" => "u",
		  "[Uring]" => "U",
		  "[utilde]" => "u",
		  "[Utilde]" => "U",
		  "[wcirc]" => "w",
		  "[Wcirc]" => "W",
		  "[ycirc]" => "y",
		  "[Ycirc]" => "Y",
		  "[Yuml]" => "Y",
		  "[zacute]" => "z",
		  "[Zacute]" => "Z",
		  "[zcaron]" => "z",
		  "[Zcaron]" => "Z",
		  "[zdot]" => "z",
		  "[Zdot]" => "Z",
		  "[half]" => "1/2",
		  "[frac12]" => "1/2",
		  "[frac14]" => "1/4",
		  "[frac34]" => "3/4",
		  "[frac18]" => "1/8",
		  "[frac38]" => "3/8",
		  "[frac58]" => "5/8",
		  "[frac78]" => "7/8",
		  "[sup1]" => "^1",
		  "[sup2]" => "^2",
		  "[sup3]" => "^3",
		  "[plus]" => "+",
		  "[plusmn]" => "+/-",
		  "[lt]" => "<",
		  "[equals]" => "=",
		  "[gt]" => ">",
		  "[divide]" => "/",
		  "[times]" => "x",
		  "[curren]" => "\@{curren\@}",
		  "[pound]" => "L",
		  "[dollar]" => "\$",
		  "[cent]" => "c",
		  "[yen]" => "Y",
		  "[num]" => "#",
		  "[percnt]" => "%",
		  "[amp]" => "\&",
		  "[ast]" => "*",
		  "[commat]" => "\@\@",
		  "[lsqb]" => "[",
		  "[bsol]" => "\\",
		  "[rsqb]" => "]",
		  "[lcub]" => "\@{",
		  "[horbar]" => "-",
		  "[verbar]" => "|",
		  "[rcub]" => "\@}",
		  "[micro]" => "u",
		  "[ohm]" => "\@{ohm\@}",
		  "[deg]" => "\@{deg\@}",
		  "[ordm]" => "\@{ordm\@}",
		  "[ordf]" => "\@{ordf\@}",
		  "[sect]" => "S",
		  "[para]" => "P",
		  "[middot]" => ".",
		  "[larr]" => "<-",
		  "[rarr]" => "->",
		  "[uarr]" => "\@{uarr\@}",
		  "[darr]" => "\@{darr\@}",
		  "[copy]" => "\@copyright{}",
		  "[reg]" => "(R)",
		  "[trade]" => "(TM)",
		  "[brvbar]" => "|",
		  "[not]" => "\@{not\@}",
		  "[sung]" => "\@{sung\@}",
		  "[excl]" => "!",
		  "[iexcl]" => "!",
		  "[quot]" => "\"",
		  "[apos]" => "'",
		  "[lpar]" => "(",
		  "[rpar]" => ")",
		  "[comma]" => ",",
		  "[lowbar]" => "_",
		  "[hyphen]" => "-",
		  "[period]" => ".",
		  "[sol]" => "/",
		  "[colon]" => ":",
		  "[semi]" => ";",
		  "[quest]" => "?",
		  "[iquest]" => "?",
		  "[laquo]" => "<<",
		  "[raquo]" => ">>",
		  "[lsquo]" => "`",
		  "[rsquo]" => "'",
		  "[ldquo]" => "``",
		  "[rdquo]" => "''",
		  "[nbsp]" => "\@w{ }",
		  "[shy]" => "",
		  "[emsp]" => "",
		  "[ensp]" => "",
		  "[emsp3]" => "",
		  "[emsp4]" => "",
		  "[numsp]" => "",
		  "[puncsp]" => "",
		  "[thinsp]" => "",
		  "[hairsp]" => "",
		  "[mdash]" => "---",
		  "[ndash]" => "--",
		  "[dash]" => "-",
		  "[blank]" => "_",
		  "[hellip]" => "...",
		  "[nldr]" => "\@{nldr\@}",
		  "[frac13]" => "1/3",
		  "[frac23]" => "2/3",
		  "[frac15]" => "1/5",
		  "[frac25]" => "2/5",
		  "[frac35]" => "3/5",
		  "[frac45]" => "4/5",
		  "[frac16]" => "1/6",
		  "[frac56]" => "5/6",
		  "[incare]" => "\@{incare\@}",
		  "[block]" => "\@{block\@}",
		  "[uhblk]" => "\@{uhblk\@}",
		  "[lhblk]" => "\@{lhblk\@}",
		  "[blk14]" => "\@{blk14\@}",
		  "[blk12]" => "\@{blk12\@}",
		  "[blk34]" => "\@{blk34\@}",
		  "[marker]" => "\@{marker\@}",
		  "[cir]" => "o",
		  "[squ]" => "\@{squ\@}",
		  "[rect]" => "\@{rect\@}",
		  "[utri]" => "\@{utri\@}",
		  "[dtri]" => "\@{dtri\@}",
		  "[star]" => "\@{star\@}",
		  "[bull]" => "o",
		  "[squf]" => "\@{squf\@}",
		  "[utrif]" => "\@{utrif\@}",
		  "[dtrif]" => "\@{dtrif\@}",
		  "[ltrif]" => "\@{ltrif\@}",
		  "[rtrif]" => "\@{rtrif\@}",
		  "[clubs]" => "\@{clubs\@}",
		  "[diams]" => "\@{diams\@}",
		  "[hearts]" => "\@{hearts\@}",
		  "[spades]" => "\@{spades\@}",
		  "[malt]" => "\@{malt\@}",
		  "[dagger]" => "\@{dagger\@}",
		  "[Dagger]" => "\@{Dagger\@}",
		  "[check]" => "\@{check\@}",
		  "[ballot]" => "x",
		  "[sharp]" => "#",
		  "[flat]" => "\@{flat\@}",
		  "[male]" => "\@{male\@}",
		  "[female]" => "\@{female\@}",
		  "[phone]" => "\@{phone\@}",
		  "[telrec]" => "\@{telrec\@}",
		  "[copysr]" => "\@{copysr\@}",
		  "[caret]" => "^",
		  "[lsquor]" => "'",
		  "[ldquor]" => "\"",
		  "[fflig]" => "ff",
		  "[filig]" => "fi",
		  "[fjlig]" => "fj",
		  "[ffilig]" => "ff",
		  "[ffllig]" => "ffl",
		  "[fllig]" => "fl",
		  "[mldr]" => "\@{mldr\@}",
		  "[rdquor]" => "\"",
		  "[rsquor]" => "'",
		  "[vellip]" => ":",
		  "[hybull]" => "-",
		  "[loz]" => "\@{loz\@}",
		  "[lozf]" => "\@{lozf\@}",
		  "[ltri]" => "\@{ltri\@}",
		  "[rtri]" => "\@{rtri\@}",
		  "[starf]" => "\@{starf\@}",
		  "[natur]" => "\@{natur\@}",
		  "[rx]" => "\@{rx\@}",
		  "[sext]" => "\@{sext\@}",
		  "[target]" => "\@{target\@}",
		  "[dlcrop]" => "\@{dlcrop\@}",
		  "[drcrop]" => "\@{drcrop\@}",
		  "[ulcrop]" => "\@{ulcrop\@}",
		  "[urcrop]" => "\@{urcrop\@}",
		  "[tex]" => "TeX",
		  "[latex]" => "LaTeX",
		  "[latexe]" => "LaTeX2e",
		  "[aleph]" => "N",
		  "[and]" => "^",
		  "[ang90]" => "\@{ang90\@}",
		  "[angsph]" => "\@{angsph\@}",
		  "[ap]" => "\@{ap\@}",
		  "[becaus]" => "\@{becaus\@}",
		  "[bottom]" => "\@{bottom\@}",
		  "[cap]" => "\@{cap\@}",
		  "[cong]" => "\@{cong\@}",
		  "[conint]" => "\@{conint\@}",
		  "[cup]" => "U",
		  "[equiv]" => "\@{equiv\@}",
		  "[exist]" => "\@{exist\@}",
		  "[forall]" => "\@{forall\@}",
		  "[fnof]" => "\@{fnof\@}",
		  "[ge]" => ">=",
		  "[iff]" => "iff.",
		  "[infin]" => "\@{infin\@}",
		  "[int]" => "\@{int\@}",
		  "[isin]" => "\@{isin\@}",
		  "[lang]" => "<",
		  "[lArr]" => "<=",
		  "[le]" => "<=",
		  "[minus]" => "-",
		  "[mnplus]" => "-/+",
		  "[nabla]" => "\@{nabla\@}",
		  "[ne]" => "!=",
		  "[ni]" => "\@{ni\@}",
		  "[or]" => "V",
		  "[par]" => "||",
		  "[part]" => "\@{part\@}",
		  "[permil]" => "\@{permil\@}",
		  "[perp]" => "\@{perp\@}",
		  "[prime]" => "'",
		  "[Prime]" => "\"",
		  "[prop]" => "\@{prop\@}",
		  "[radic]" => "\@{radic\@}",
		  "[rang]" => ">",
		  "[rArr]" => "=>",
		  "[sim]" => "C",
		  "[sime]" => "C=",
		  "[square]" => "\@{square\@}",
		  "[sub]" => "\@{sub\@}",
		  "[sube]" => "\@{sube\@}",
		  "[sup]" => "\@{sup\@}",
		  "[supe]" => "\@{supe\@}",
		  "[there4]" => "\@{there4\@}",
		  "[Verbar]" => "||",
		  "[angst]" => "A",
		  "[bernou]" => "B",
		  "[compfn]" => "o",
		  "[Dot]" => "\@{Dot\@}",
		  "[DotDot]" => "\@{DotDot\@}",
		  "[hamilt]" => "H",
		  "[lagran]" => "L",
		  "[lowast]" => "*",
		  "[notin]" => "\@{notin\@}",
		  "[order]" => "\@{order\@}",
		  "[phmmat]" => "M",
		  "[tdot]" => "\@{tdot\@}",
		  "[tprime]" => "\@{tprime\@}",
		  "[wedgeq]" => "\@{wedgeq\@}",
		  );

## ----------------------------------------------------------------------
## don't forget this
1;

## ----------------------------------------------------------------------
