/* dread.c	-- Copyright Henry S. Thompson 1996
 * Beta version 1.0
 *
 * Produced at HCRC, Edinburgh with support from the UK Economic and Social
 *  Research Council and SunSoft
 *
 * Define d!read, read for dsssl, sharing with read.c wherever possible
 *
 */

#ifndef lint
static const char *rcsid =
"$Header: /home/ht/dsssl/src/RCS/dread.c,v 1.9 1996/11/28 16:37:32 ht Exp $";
#endif



#include <ctype.h>

#include "scheme.h"

#ifndef VALBITS
#define ELK3
#endif

#ifdef ELK3
#define Elk_Init(key) elk_init_ ## key
#define MAX_READ_STRING 1024
#define MAX_READ_SYMBOL 1024
#define Make_INT Make_Integer
#else
#define Elk_Init(key) init_ ## key
#define Make_INT Make_Fixnum
#endif

extern char *index();
extern double atof();
#ifdef GCDD
extern void SetDRF();
#endif

#define Octal(c) ((c) >= '0' && (c) <= '7')
#define d_List(one, two) (l_tail=Cons(two,Null),Cons(one,l_tail))
#define log_line(n,x) (l_tail=Cons(x,Make_INT(n)),\
		       Var_Set(d_flt,Cons(l_tail,Var_Get(d_flt))))

static READFUN d_Readers[256];
static int lineNo=0;

extern void Reader_Warning(),Reader_Error(),
  String_Ungetc(Object,char),Flush_Output(Object);
extern int Skip_Comment(Object),String_Getc(Object);

extern Object Make_Bignum(), General_Make_String();

Object d_Read_Atom(), d_Read_String(), d_Read_Special(), d_Read_Char(),
  d_Read_Sharp(), Read_True(), Read_False(), Read_Void(), d_Parse_NumOrQ(),
  Read_Kludge(), Read_Vector(), Read_Radix(), d_Read_Sequence();

Object d_g,d_c,d_d,d_k,d_q,d_key,d_rest,d_optional;
Object d_line_no, d_flt;
Object Sym_Quote,
       Sym_Quasiquote,
       Sym_Unquote,
       Sym_Unquote_Splicing;

Object ReadGlyphId(port, chr, konst) Object port; int chr, konst; {
    int c=0, str;
    FILE *f;
    char buf[100+3], *p = buf;
    Object num,l_tail;
    GC_Node;

    f = PORT(port)->file;
    str = PORT(port)->flags & P_STRING;
    while (1) {
	Reader_Getc;
	if (c == EOF)
	    Reader_Sharp_Eof;
	if (p == buf+100+2)
	    Reader_Error (port, "number too long for reader");
	if (Whitespace (c) || Delimiter (c))
	    break;
	*p++ = c;
    }
    Reader_Ungetc;
    *p = '\0';
    GC_Link(port);
    num = d_Parse_NumOrQ (port, buf, 10);
    GC_Unlink;
    if (Nullp (num) || TYPE(num)!=T_Fixnum)
	Reader_Error (port, "#A not followed by a valid integer");
    return d_List(d_g,num);
}

Object ReadDeclConst(port, chr, konst) Object port; int chr, konst; {
  int c=0, str;
  FILE *f;
  Object l_tail;
  char buf[10+3], *p = buf, ebuf[50];

  f = PORT(port)->file;
  str = PORT(port)->flags & P_STRING;
  while (1) {
    Reader_Getc;
    if (c == EOF)
      Reader_Sharp_Eof;
    if (p == buf+10+2)
      Reader_Error (port, "invalid #! syntax");
    if (!isalpha (c))
      break;
    *p++ = c;
  }
  Reader_Ungetc;
  *p = '\0';
  if (!strcmp(buf,"optional")) {
    return d_List(d_d,d_optional);
  }
  else if (!strcmp(buf,"rest")) {
    return d_List(d_d,d_rest);
  }
  else if (!strcmp(buf,"key")) {
    return d_List(d_d,d_key);
  }
  else {
    sprintf(ebuf, "invalid named constant %s", buf);
    Reader_Error (port, ebuf);
  };
  /*NOTREACHED*/
  return False;
};

Object d_Parse_NumOrQ (port, buf, radix) Object port; char *buf; int radix; {
  char *p;
  int c, i;
  int mdigit = 0, edigit = 0, expo = 0, neg = 0, point = 0;
  int gotradix = 0, qq = 0;
  Object ret,uname,l_tail;
  char savec=0,*qs;
  GC_Node2;

  for ( ; *buf == '#'; buf++) {
    switch (*++buf) {
    case 'b':
      if (gotradix++) return Null;
      radix = 2;
      break;
    case 'o':
      if (gotradix++) return Null;
      radix = 8;
      break;
    case 'd':
      if (gotradix++) return Null;
      radix = 10;
      break;
    case 'x':
      if (gotradix++) return Null;
      radix = 16;
      break;
    default:
      return Null;
    }
  }
  p = buf;
  if (*p == '+' || (neg = *p == '-'))
    p++;
  for ( ; (c = *p); p++) {
    if (c == '.' && radix == 10) {
      if (expo || point++)
	return Null;
    } else if (c == 'e' && radix == 10) {
      if (p[1] && isalpha(p[1])) {
	qq=1;
	break;
      };
      if (expo++)
	return Null;
      if (p[1] == '+' || p[1] == '-')
	p++;
    } else if (radix == 16 && !index ("0123456789abcdef", c)) {
      return Null;
    } else if (c < '0' || c > ('0' + radix-1)) {
      if (radix == 10) {
	qq=1;
	break;
      }
      else {
	return Null;
      };
    }
    else {
      if (expo) {
	edigit++;
      }
      else {
	mdigit++;
      };
    };
  };
  if (!mdigit || (expo && !edigit))
    return Null;
  if (qq) {
    savec=*p;
    *p='\000';
  };
  
  if (point || expo) {
    ret=Make_Flonum (atof (buf));
  }
  else {
    for (i = 0, p = buf; (c = *p); p++) {
      if (c == '-' || c == '+') {
	buf++;
	continue;
      };
      if (radix == 16 && c >= 'a') {
	c = '9' + c - 'a' + 1;
      };
      i = radix * i + c - '0';
      if (!FIXNUM_FITS(neg ? -i : i)) {
	ret = Make_Bignum (buf, neg, radix);
      }
      else {
	ret = Make_INT(neg?-i:i);
      };
    };
  };
  if (qq) {
    qs=p;
    *p++=savec;
    while (isalpha(*p)) {
      p++;
    };
    savec=*p;
    *p='\000';
    uname=Null;
    GC_Link2(ret,uname);
    uname=Intern(qs);
    if (savec) {
      *p=savec;
      if (*p == '+' || (neg = *p == '-'))
	p++;
      qs=p;
      i=0;
      while (isdigit(*p)) {
	i=(i*10)+((*p++)-'0');
      };
      if (qs==p || *p) {
	GC_Unlink;
	return Null;
      }
      else {
	l_tail=Cons(Make_INT(neg?-i:i),Null);
	l_tail=Cons(uname,l_tail);
	l_tail=Cons(ret,l_tail);
	GC_Unlink;
	return Cons(d_q,l_tail);
      };
    }
    else {
      l_tail=Cons(uname,Null);
      l_tail=Cons(ret,l_tail);
      GC_Unlink;
      return Cons(d_q,l_tail);
    };
  }
  else {
    return ret;
  };
}

Object d_Read_Radix (port, chr, konst) Object port; int chr, konst; {
    int c=0, str;
    FILE *f;
    char buf[MAX_READ_SYMBOL+3], *p = buf;
    Object ret;

    f = PORT(port)->file;
    str = PORT(port)->flags & P_STRING;
    *p++ = '#'; *p++ = chr;
    while (1) {
	Reader_Getc;
	if (c == EOF)
	    Reader_Sharp_Eof;
	if (p == buf+MAX_READ_SYMBOL+2)
	    Reader_Error (port, "number too long for reader");
	if (Whitespace (c) || Delimiter (c))
	    break;
	*p++ = c;
    }
    Reader_Ungetc;
    *p = '\0';
    ret = d_Parse_NumOrQ (port, buf, 10);
    if (Nullp (ret)) {
	Reader_Error (port, "radix not followed by a valid number");
    };
    return ret;
}

Object d_Read_Sharp (port, konst) Object port; int konst; {
    int c=0, str;
    FILE *f;
    char buf[32];

    f = PORT(port)->file;
    str = PORT(port)->flags & P_STRING;
    Reader_Getc;
    if (c == EOF)
	Reader_Sharp_Eof;
    if (!d_Readers[c]) {
	sprintf (buf, "no reader for syntax #%c", c);
	Reader_Error (port, buf);
    }
    return d_Readers[c](port, c, konst);
}

Object d_Read_Char (port, chr, konst) Object port; int chr, konst; {
  int c=0, str;
  FILE *f;
  Object l_tail;
  char buf[100], *p = buf;

  f = PORT(port)->file;
  str = PORT(port)->flags & P_STRING;
  Reader_Getc;
  if (c == EOF)
    Reader_Sharp_Eof;
  *p++ = c;
  if (isalpha(c)) {
    while (1) {
      Reader_Getc;
      if (c == EOF)
	Reader_Sharp_Eof;
      if (!(isalpha (c) || isdigit (c) || c == '.' || c == '-'))
	break;
      if (p == buf+99) {
	Reader_Error
	  (port, "Character names longer than 99 chars not supported yet");
      };
      *p++ = c;
    }
    Reader_Ungetc;
  };
  *p='\000';
  return d_List(d_c,Make_String(buf,p-buf));
}

Object d_Read_Atom (port, konst) Object port; int konst; {
    Object ret;
#ifdef LogBug
    Object l_tail;
    GC_Node;
#endif

    ret = d_Read_Special (port, konst);
    if (TYPE(ret) == T_Special)
	Reader_Error (port, "syntax error 1");
#ifdef LogBug
    GC_Link(ret);
    log_line(lineNo,ret);
    GC_Unlink;
#endif
    return ret;
}

Object d_Read_Special (port, konst) Object port; int konst; {
    Object ret,l_tail;
    register c, str;
    register FILE *f;
    char buf[MAX_READ_SYMBOL+1];
    char ebuf[MAX_READ_SYMBOL+20];
    register char *p = buf;

#define READ_QUOTE(sym) \
    ( ret = d_Read_Atom (port, konst),\
      konst ? (ret = Const_Cons (ret, Null), Const_Cons (sym, ret))\
	   : (ret = Cons (ret, Null), Cons (sym, ret)))

    f = PORT(port)->file;
    str = PORT(port)->flags & P_STRING;
again:
    Reader_Getc;
    lineNo=PORT(port)->lno;
    switch (c) {
    case EOF:
eof:
	Reader_Tweak_Stream;
	Reader_Error (port, "premature end of file");
    case ';':
	if (Skip_Comment (port) == EOF)
	    goto eof;
	goto again;
    case ')':
	SET(ret, T_Special, c);
	return ret;
    case '(':
	return d_Read_Sequence (port, 0, konst);
    case '\'':
	return READ_QUOTE(Sym_Quote);
    case '`':
	return READ_QUOTE(Sym_Quasiquote);
    case ',':
	Reader_Getc;
	if (c == EOF)
	    goto eof;
	if (c == '@') {
	    return READ_QUOTE(Sym_Unquote_Splicing);
	} else {
	    Reader_Ungetc;
	    return READ_QUOTE(Sym_Unquote);
	}
    case '"':
	return d_Read_String (port, konst);
    case '#':
	ret = d_Read_Sharp (port, konst);
	if (TYPE(ret) == T_Special)
	    goto again;
	return ret;
    default:
	if (Whitespace (c))
	    goto again;
	if (c == '.') {
	    Reader_Getc;
	    if (c == EOF)
		goto eof;
	    if (Whitespace (c)) {
		Reader_Ungetc;
		SET(ret, T_Special, '.');
		return ret;
	    }
	    *p++ = '.';
	}
	while (!Whitespace (c) && !Delimiter (c) && c != EOF) {
	    if (p == buf+MAX_READ_SYMBOL)
		Reader_Error (port, "symbol too long for reader");
	    if (c == '\\') {
		Reader_Getc;
		if (c == EOF)
		    break;
	    }
	    *p++ = c;
	    Reader_Getc;
	}
	*p = '\0';
	if (c != EOF)
	    Reader_Ungetc;
	ret = d_Parse_NumOrQ (port, buf, 10);
	if (Nullp (ret)) {
	  if (isdigit(*buf)) {
	    sprintf(ebuf,"Invalid symbol: %s",buf);
	    Reader_Error(port, ebuf);
	  };
	  if (*(p-1)==':') {
	    *(p-1)='\000';
	    ret = d_List(d_k,Intern(buf));
	  }
	  else {
	    ret = Intern (buf);
	  };
	};
	return ret;
    }
    /*NOTREACHED*/
}

Object d_Read_Sequence (port, vec, konst) Object port; int vec,konst; {
    Object ret, e, tail, t, l_tail;
    int l=0;
    GC_Node4;

    ret = tail = e = Null;
    GC_Link4 (ret, tail, port, e);
    while (1) {
	e = d_Read_Special (port, konst);
	if (!l) {
	  l=lineNo;
	};
	if (TYPE(e) == T_Special) {
	    if (CHAR(e) == ')') {
		log_line(l,ret);
		GC_Unlink;
		return ret;
	    }
	    if (vec)
		Reader_Error (port, "wrong syntax in vector");
	    if (CHAR(e) == '.') {
		if (Nullp (tail)) {
		    ret = d_Read_Atom (port, konst);
		} else {
		    e = d_Read_Atom (port, konst);
		    /*
		     * Possibly modifying pure cons.  Must be fixed!
		     */
		    Cdr (tail) = e;
		}
		e = d_Read_Special (port, konst);
		if (TYPE(e) == T_Special && CHAR(e) == ')') {
		    log_line(l,ret);
		    GC_Unlink;
		    return ret;
		}
		Reader_Error (port, "dot in wrong context");
	    }
	    Reader_Error (port, "syntax error 2");
	}
	if (konst) t = Const_Cons (e, Null); else t = Cons (e, Null);
	if (!Nullp (tail))
	    /*
	     * Possibly modifying pure cons.  Must be fixed!
	     */
	    Cdr (tail) = t;
	else
	    ret = t;
	tail = t;
    }
    /*NOTREACHED*/
}

Object d_Read_String (port, konst) Object port; int konst; {
    char buf[MAX_READ_STRING];
    register char *p = buf, *cn;
    register FILE *f;
    register c, str;

    f = PORT(port)->file;
    str = PORT(port)->flags & P_STRING;
    while (1) {
	Reader_Getc;
	if (c == EOF) {
eof:
	    Reader_Tweak_Stream;
	    Reader_Error (port, "end of file in string");
	};
	if (c == '\\') {
	  Reader_Getc;
	  switch (c) {
	  case EOF: goto eof;
	  case '"': case '\\': break;
	  default: if (isalpha(c)) {
	    cn=p;
	    do {
	      if (p == buf+MAX_READ_STRING)
		Reader_Error (port, "string too long for reader");
	      *p++=c;
	      Reader_Getc;
	    } while (isalpha(c) || isdigit(c) || c=='.' || c=='-');
	    if (p==cn) {
	      goto cerr;
	    };
	    /* Note we don't check for syntax errors such as "\sigma+\tau" */
	    /* character name is now Make_String(cn,p+1-cn) */
	    if (c!=';') {
	      Reader_Ungetc;
	    };
	    c='\254'; /* no proper chars yet */
	    p=cn;
	  }
	  else {
cerr:
	    Reader_Tweak_Stream;
	    Reader_Error (port, "invalid char-name in string");
	  };
	  };
	} else if (c == '"')
	    break;
	if (p == buf+MAX_READ_STRING)
	    Reader_Error (port, "string too long for reader");
	*p++ = c;
    }
    return General_Make_String (buf, p-buf, konst);
}

Object d_General_Read (port, konst) Object port; int konst; {
    register FILE *f;
    register c, str;
    Object ret;
    GC_Node2;

    ret=Null;
    GC_Link2(ret,port);
    Check_Input_Port (port);
    Flush_Output (Curr_Output_Port);
    f = PORT(port)->file;
#ifdef GCDD
    SetDRF(f);
#endif
    str = PORT(port)->flags & P_STRING;
    while (1) {
	Reader_Getc;
	if (c == EOF) {
	    ret = Eof;
	    break;
	}
	if (Whitespace (c))
	    continue;
	if (c == ';') {
comment:
	    if (Skip_Comment (port) == EOF) {
		ret = Eof;
		break;
	    }
	    continue;
	}
	if (c == '(') {
	    ret = d_Read_Sequence (port, 0, konst);
	} else if (c == '#') {
	    ret = d_Read_Sharp (port, konst);
	    if (TYPE(ret) == T_Special)      /* it was a #! */
		goto comment;
	} else {
	    Reader_Ungetc;
	    ret = d_Read_Atom (port, konst);
	}
	break;
    }
    Reader_Tweak_Stream;
    Var_Set(d_line_no,Make_INT(lineNo=(EQ(ret,Eof)?-1:PORT(port)->lno)));
    GC_Unlink;
    return ret;
}

Object P_d_Read (argc, argv) Object *argv; int argc; {
  Var_Set(d_flt,Null);
    return d_General_Read (argc == 1 ? argv[0] : Curr_Input_Port, 0);
}

void Reader_Warning (port, msg) Object port; char *msg; {
  fprintf (stderr, "Reader warning, %s line %u: %s\n",
	   (PORT(port)->flags & P_STRING)?"[string-port]":
	        STRING(PORT(port)->name)->data,
		 PORT(port)->lno, msg);
}

void Elk_Init(dread)() {
  d_Readers['t'] =d_Readers['T'] = Read_True;
  d_Readers['f'] =d_Readers['F'] = Read_False;
  d_Readers['v'] =d_Readers['V'] = Read_Void;
  /* Don't know what this is!!!
     d_Readers['!'] = Read_Kludge;  */ /*for interpreter files */
  d_Readers['('] = Read_Vector;
  d_Readers['b'] =d_Readers['B'] =
    d_Readers['o'] =
    d_Readers['x'] =
    d_Readers['d'] = d_Read_Radix;
  d_Readers['\\'] = d_Read_Char;
  d_Readers['A']=ReadGlyphId;
  d_Readers['!']=ReadDeclConst;
  Define_Symbol(&d_g, "d!g");
  Define_Symbol(&d_c, "d!c");
  Define_Symbol(&d_d, "d!d");
  Define_Symbol(&d_k, "d!k");
  Define_Symbol(&d_q, "d!m");
  Define_Symbol(&d_key, "key");
  Define_Symbol(&d_rest, "rest");
  Define_Symbol(&d_optional, "optional");
  Define_Variable(&d_line_no, "line-no", Make_INT(0));
  Define_Variable(&d_flt, "form-line-tbl",Null);
  Define_Symbol (&Sym_Quote, "quote");
  Define_Symbol (&Sym_Quasiquote, "quasiquote");
  Define_Symbol (&Sym_Unquote, "unquote");
  Define_Symbol (&Sym_Unquote_Splicing, "unquote-splicing");
  Define_Primitive(P_d_Read,"d!read",0,1,VARARGS);
}
