<!-- ...................................................................... -->
<!-- XHTML 1.1 Forms Module  .............................................. -->
<!-- file: xhtml11-form-1.mod

     This is XHTML 1.1, a modular variant of XHTML 1.0.
     Copyright 1998-1999 W3C (MIT, INRIA, Keio), All Rights Reserved.
     Revision: @(#)xhtml11-form-1.mod 1.6 99/08/26 SMI

     This DTD module is identified by the PUBLIC and SYSTEM identifiers:

     PUBLIC "-//W3C//ELEMENTS XHTML 1.1 Forms 1.0//EN"
     SYSTEM "xhtml11-form-1.mod"

     Revisions:
     (none)
     ....................................................................... -->

<!-- Forms

        form, label, input, select, optgroup, option,
        textarea, fieldset, legend, button

     This module declares markup to provide support for online
     forms, based on the features found in HTML 4.0 forms.
-->

<!-- %Block-noform.mix; includes all non-form block elements,
     plus %Misc.class;
-->
<!ENTITY % Block-noform.mix
     "%Heading.class;
      | %List.class;
      | %Blkstruct.class;
      %Blkphras.class;
      %Blkpres.class;
      | table 
      %Misc.class;"
>

<!-- form: Form Element ................................ -->

<!ENTITY % Form.element  "INCLUDE" >
<![%Form.element;[
<!ENTITY % Form.content
     "( %Block-noform.mix;
      | fieldset )+"
>
<!ELEMENT form  %Form.content; >
<!-- end of Form.element -->]]>

<!ENTITY % Form.attlist  "INCLUDE" >
<![%Form.attlist;[
<!ATTLIST form
      %Common.attrib;
      action       %URI.datatype;           #REQUIRED
      method       (get|post)               'get'
      enctype      %ContentType.datatype;   'application/x-www-form-urlencoded'
      accept-charset %Charsets.datatype;    #IMPLIED
      accept       %ContentTypes.datatype;  #IMPLIED
>
<!-- end of Form.attlist -->]]>

<!-- label: Form Field Label Text ...................... -->

<!-- Each label must not contain more than ONE field
-->

<!ENTITY % Label.element  "INCLUDE" >
<![%Label.element;[
<!ENTITY % Label.content
     "( #PCDATA 
      | input | select | textarea | button
      | %Inlstruct.class;
      %Inlphras.class;
      %I18n.class;
      %Inlpres.class;
      %Anchor.class;
      | img
      %Misc.class; )*"
>
<!ELEMENT label  %Label.content; >
<!-- end of Label.element -->]]>

<!ENTITY % Label.attlist  "INCLUDE" >
<![%Label.attlist;[
<!ATTLIST label
      %Common.attrib;
      for          IDREF                    #IMPLIED
      accesskey    %Character.datatype;     #IMPLIED
>
<!-- end of Label.attlist -->]]>

<!-- input: Form Control ............................... -->

<!ENTITY % Input.element  "INCLUDE" >
<![%Input.element;[
<!ENTITY % Input.content  "EMPTY" >
<!ELEMENT input  %Input.content; >
<!-- end of Input.element -->]]>

<!ENTITY % Input.attlist  "INCLUDE" >
<![%Input.attlist;[
<!ENTITY % InputType.class
     "( text | password | checkbox | radio | submit
      | reset | file | hidden | image | button )"
>
<!-- attribute 'name' required for all but submit & reset
-->
<!ATTLIST input
      %Common.attrib;
      type         %InputType.class;        'text'
      name         CDATA                    #IMPLIED
      value        CDATA                    #IMPLIED
      checked      (checked)                #IMPLIED
      disabled     (disabled)               #IMPLIED
      readonly     (readonly)               #IMPLIED
      size         CDATA                    #IMPLIED
      maxlength    %Number.datatype;        #IMPLIED
      src          %URI.datatype;           #IMPLIED
      alt          CDATA                    #IMPLIED
      usemap       IDREF                    #IMPLIED
      tabindex     %Number.datatype;        #IMPLIED
      accesskey    %Character.datatype;     #IMPLIED
      accept       %ContentTypes.datatype;  #IMPLIED
>
<!-- end of Input.attlist -->]]>

<!-- select: Option Selector ........................... -->

<!ENTITY % Select.element  "INCLUDE" >
<![%Select.element;[
<!ENTITY % Select.content
     "( optgroup | option )+"
>
<!ELEMENT select  %Select.content; >
<!-- end of Select.element -->]]>

<!ENTITY % Select.attlist  "INCLUDE" >
<![%Select.attlist;[
<!ATTLIST select
      %Common.attrib;
      name         CDATA                    #IMPLIED
      size         %Number.datatype;        #IMPLIED
      multiple     (multiple)               #IMPLIED
      disabled     (disabled)               #IMPLIED
      tabindex     %Number.datatype;        #IMPLIED
>
<!-- end of Select.attlist -->]]>

<!-- optgroup: Option Group ............................ -->

<!ENTITY % Optgroup.element  "INCLUDE" >
<![%Optgroup.element;[
<!ENTITY % Optgroup.content  "( option )+" >
<!ELEMENT optgroup  %Optgroup.content; >
<!-- end of Optgroup.element -->]]>

<!ENTITY % Optgroup.attlist  "INCLUDE" >
<![%Optgroup.attlist;[
<!ATTLIST optgroup
      %Common.attrib;
      disabled     (disabled)               #IMPLIED
      label        %Text.datatype;          #REQUIRED
>
<!-- end of Optgroup.attlist -->]]>

<!-- option: Selectable Choice ......................... -->

<!ENTITY % Option.element  "INCLUDE" >
<![%Option.element;[
<!ENTITY % Option.content  "( #PCDATA )" >
<!ELEMENT option  %Option.content; >
<!-- end of Option.element -->]]>

<!ENTITY % Option.attlist  "INCLUDE" >
<![%Option.attlist;[
<!ATTLIST option
      %Common.attrib;
      selected     (selected)               #IMPLIED
      disabled     (disabled)               #IMPLIED
      label        %Text.datatype;          #IMPLIED
      value        CDATA                    #IMPLIED
>
<!-- end of Option.attlist -->]]>

<!-- textarea: Multi-Line Text Field ................... -->

<!ENTITY % Textarea.element  "INCLUDE" >
<![%Textarea.element;[
<!ENTITY % Textarea.content  "( #PCDATA )" >
<!ELEMENT textarea  %Textarea.content; >
<!-- end of Textarea.element -->]]>

<!ENTITY % Textarea.attlist  "INCLUDE" >
<![%Textarea.attlist;[
<!ATTLIST textarea
      %Common.attrib;
      name         CDATA                    #IMPLIED
      rows         %Number.datatype;        #REQUIRED
      cols         %Number.datatype;        #REQUIRED
      disabled     (disabled)               #IMPLIED
      readonly     (readonly)               #IMPLIED
      tabindex     %Number.datatype;        #IMPLIED
      accesskey    %Character.datatype;     #IMPLIED
>
<!-- end of Textarea.attlist -->]]>

<!-- fieldset: Form Control Group ...................... -->

<!-- #PCDATA is to solve the mixed content problem,
     per specification only whitespace is allowed
-->

<!ENTITY % Fieldset.element  "INCLUDE" >
<![%Fieldset.element;[
<!ENTITY % Fieldset.content
     "( #PCDATA | legend | %Flow.mix; )*"
>
<!ELEMENT fieldset  %Fieldset.content; >
<!-- end of Fieldset.element -->]]>

<!ENTITY % Fieldset.attlist  "INCLUDE" >
<![%Fieldset.attlist;[
<!ATTLIST fieldset
      %Common.attrib;
>
<!-- end of Fieldset.attlist -->]]>

<!-- legend: Fieldset Legend ........................... -->

<!ENTITY % Legend.element  "INCLUDE" >
<![%Legend.element;[
<!ENTITY % Legend.content
     "( #PCDATA | %Inline.mix; )*"
>
<!ELEMENT legend  %Legend.content; >
<!-- end of Legend.element -->]]>

<!ENTITY % Legend.attlist  "INCLUDE" >
<![%Legend.attlist;[
<!ATTLIST legend
      %Common.attrib;
      accesskey    %Character.datatype;     #IMPLIED
>
<!-- end of Legend.attlist -->]]>

<!-- button: Push Button ............................... -->

<!ENTITY % Button.element  "INCLUDE" >
<![%Button.element;[
<!ENTITY % Button.content
     "( #PCDATA
      | %Block-noform.mix;
      | %Inlstruct.class;
      %Inlphras.class;
      %Inlpres.class;
      %I18n.class;
      | img | map | applet )*"
>
<!ELEMENT button  %Button.content; >
<!-- end of Button.element -->]]>

<!ENTITY % Button.attlist  "INCLUDE" >
<![%Button.attlist;[
<!ATTLIST button
      %Common.attrib;
      name         CDATA                    #IMPLIED
      value        CDATA                    #IMPLIED
      type         (button|submit|reset)    'submit'
      disabled     (disabled)               #IMPLIED
      tabindex     %Number.datatype;        #IMPLIED
      accesskey    %Character.datatype;     #IMPLIED
>
<!-- end of Button.attlist -->]]>

<!-- end of xhtml11-form-1.mod -->
