#!/usr/bin/python
#
#  genspec.py - generate a spec file from a template.
#
#  $Id: genspec.py,v 1.2 1998/10/17 20:21:20 cg Exp $
#
#  SGMLtools - an SGML toolkit.
#  Copyright (C) 1998 Cees A. de Groot
#  Copyright (C) 1998 Evelyn Mitchell (python version)
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#

"""
NAME

    genspec - Generate an RPM .spec file from a template.

SYNOPSIS

    genspec ($package, $version, $release);

DESCRIPTION

    The subroutine genspec generates a version specific .spec file from
    a version-less .template file. The subroutine expects all relevant
    stuff to be in the current directory.

REPLACEMENTS

    The subroutine does a simple substitution on the input file of the
    version given. There are three forms for the version:

    VERSION - The version string as given in the argument.

    SHORTVERS - A compressed version string: the argument with the
    dots removed.

    UNDVERS - A version string where the dots have been replaced by
    underscores.

    RELEASE - The release.

    SGML_BIN_DIR - The directory for binary files, default
    /usr/local/bin.

    SGML_SHARE_DIR - The directory for architecture-independent
    files, default /usr/local/share/sgml.

    SGML_DOC_DIR - The directory for documentation files, default
    /usr/local/doc.

    SGML_MAN_DIR - The directory for manual pages, default
    /usr/local/man.

    SGML_ETC_DIR - The well-known directory for catalogs, etcetera. 
    Default /etc/sgml.

    TEXMF_DIR - The directory where TeX components must be installed,
    default whatever findTeX.pl comes up with.

"""

import sys, os, string
import findTeX


from findTeX import findTeX

def genspec(package, version, release=""):
    
    prefix = "/usr/local";
    bindir = "/usr/local/bin";
    sharedir = "/usr/local/share/sgml";
    docdir = "/usr/local/doc";
    mandir = "/usr/local/man";
    texdir = findTeX();

    if os.environ.has_key('SGML_PREFIX'):
	prefix = os.environ["SGML_PREFIX"]
    if os.environ.has_key('SGML_BIN_DIR'):
	bindir = os.environ["SGML_BIN_DIR"]
    if os.environ.has_key('SGML_SHARE_DIR'):
	sharedir = os.environ["SGML_SHARE_DIR"]
    if os.environ.has_key('SGML_DOC_DIR'):
	docdir = os.environ["SGML_DOC_DIR"]
    if os.environ.has_key('SGML_MAN_DIR'):
	mandir = os.environ["SGML_MAN_DIR"]
    if os.environ.has_key('SGML_ETC_DIR'):
	etcdir = os.environ["SGML_ETC_DIR"]
    if os.environ.has_key('TEXMF_DIR'):
	texdir = os.environ["TEXMF_DIR"]

    shortvers = version
    shortvers = string.replace(shortvers, '.', '') 
    undvers = version
    undvers = string.replace(undvers, '.', '_') 

    try:
	INFILE = open(("%s.template" % (package)) , "r")
    except IOError, e:
	'Couldnt open ("%s.template" % (package)) (e[1])'
    try:
	OUTFILE = open(("%s-%s.spec" % (package, version)) , "w")
    except IOError, e:
	'Couldnt open ("%s-%s.spec" % (package, version)) (e[1])'

    for line in INFILE.readlines():
	    
	line = string.replace(line, '@VERSION@', version) 
	line = string.replace(line, '@SHORTVERS@', shortvers) 
	line = string.replace(line, '@UNDVERS@', undvers) 
	line = string.replace(line, '@RELEASE@', release) 
	line = string.replace(line, '@SGML_PREFIX@', prefix) 
	line = string.replace(line, '@SGML_BIN_DIR@', bindir) 
	line = string.replace(line, '@SGML_SHARE_DIR@', sharedir) 
	line = string.replace(line, '@SGML_DOC_DIR@', docdir) 
	line = string.replace(line, '@SGML_MAN_DIR@', mandir) 
	line = string.replace(line, '@SGML_ETC_DIR@', etcdir) 
	line = string.replace(line, '@TEXMF_DIR@', texdir) 
	OUTFILE.write(line)	     

    OUTFILE.close()
    INFILE.close()


if __name__ == '__main__':
    genspec ("docbook-stylesheets", "1.07", "2")

