#include "forkit.h"
#include <unistd.h>
#include <stdio.h>


Fork::Fork(FUNCTION func, PVOID param, int num)
{
  int control[2];
  int feedback[2];
  m_poll.events = POLLIN | POLLERR | POLLHUP | POLLNVAL;
  if (pipe(feedback) || pipe(control))
  {
    fprintf(stderr, "Can't open pipes.\n");
    exit(1);
  }
  for(int i = 0; i < num; i++)
  {
    int p = fork();
    if(p == -1)
    {
      fprintf(stderr, "Can't fork.\n");
      exit(1);
    }
    if(p == 0) // child
    {
      m_poll.fd = control[0];
      m_read = control[0];
      m_write = feedback[1];
      close(control[1]);
      close(feedback[0]);
      func(this, param);
      exit(0);
    }
  }
  m_poll.fd = feedback[0];
  m_write = control[1];
  m_read = feedback[0];
  close(control[0]);
  close(feedback[1]);
}

int Fork::Read(PVOID buf, int size, int timeout = 60)
{
  if(timeout)
  {
    int rc = poll(&m_poll, 1, timeout * 1000);
    if(rc < 0)
    {
      fprintf(stderr, "Can't poll.\n");
      return -1;
    }
    if(!rc)
      return 0;
  }
  if(size != read(m_read, buf, size) )
  {
    fprintf(stderr, "Can't read data from results port.\n");
    return -1;
  }
  return size;
}

int Fork::Write(PVOID buf, int size)
{
  if(size != write(m_write, buf, size))
  {
    fprintf(stderr, "Can't write results to pipe.\n");
    return -1;
  }
  return size;
}

