#ifndef _NAPSTER_H_
#define _NAPSTER_H_

#include <sys/types.h>
#include <sys/socket.h>
#include <glib.h>

#define SERVER_ADDR  "208.178.163.58"
#define SERVER_PORT  8875
#define VERSION_STRING  "v2.0 BETA 3"

typedef struct {
 gchar *filename;
 gchar *id;
 gchar *user;
 guint number;
 guint size;
 guint bitrate;
 guint frequency;
 guint speed;
 gulong ip;
 gboolean selected;
} search_result;

typedef struct {
 gchar *user;
 gchar *filename;
 FILE *filehandle;
 gint socket;
 gint tag;
 gint update_tag;
 gulong size;
 gulong totalsize;
 gulong oldsize;
} transfer;


void nap_end_search_result(void);
gint nap_connect(gchar *username,gchar *password,gint port,gint connection,gboolean new_user);
struct sockaddr_in *nap_get_best_host(gchar *string);
void nap_handle_input(gpointer data,gint socketfd,GdkInputCondition condition); 
void nap_handle_header(gpointer data,gint socketfd,GdkInputCondition condition); 
void nap_handle_download(gpointer data,gint socketfd,GdkInputCondition condition); 
void nap_send_search(gchar* search,int socket);
void nap_get_search_result(gchar* line);
void nap_send_download_request(gint socket,gchar *user,gchar *filename,gchar *id);
void nap_get_download_reply(gint socket,gchar *buffer);

#endif
