/******************************************************************************\
 gnofin/history.h   $Revision: 1.1 $
 Copyright (C) 1999 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#ifndef FIN_HISTORY_H
#define FIN_HISTORY_H

#include <gtk/gtkobject.h>

/* a general history interface */

#define FIN_TYPE_HISTORY		(fin_history_get_type())
#define FIN_HISTORY(history)		(GTK_CHECK_CAST((history), FIN_TYPE_HISTORY, FinHistory))
#define FIN_HISTORY_CLASS(klass)	(GTK_CHECK_CLASS_CAST((klass), FIN_TYPE_HISTORY, FinHistoryClass))
#define FIN_IS_HISTORY(history)		(GTK_CHECK_TYPE((history), FIN_TYPE_HISTORY))
#define FIN_IS_HISTORY_CLASS(klass)	(GTK_CHECK_CLASS_TYPE((history), FIN_TYPE_HISTORY))

#define FIN_HISTORY_CAN_UNDO(history)	(FIN_HISTORY(history)->can_undo)
#define FIN_HISTORY_CAN_REDO(history)	(FIN_HISTORY(history)->can_redo)

typedef struct _FinHistory FinHistory;
typedef struct _FinHistoryClass FinHistoryClass;

/* design notes:
 *
 * this class implements a simple history with infinite undo/redo.
 *
 * the user can connect to the following signals:
 *
 *   undo_item  - try to undo a specific history item
 *   redo_item  - try to redo a specific history item
 *   free_item  - free memory associated with history item
 *
 * thus, the user is left to define what it means to "undo" a
 * history item, where a history item is just an abstract name
 * for some "remembered" operation that changes the state of 
 * the program.
 *
 * adding items to the history is done by calling fin_history_remember.
 */

struct _FinHistory
{
  GtkObject object;

  GList * items;	/* list of history items, user defined */
  GList * current;	/* points to next UNDO item */

  gint can_undo : 1;
  gint can_redo : 1;
};

struct _FinHistoryClass
{
  GtkObjectClass parent_class;

  void (* free_item) (FinHistory * history,
  		      gpointer     item);

  void (* undo_item) (FinHistory * history,
		      gpointer     item);

  void (* redo_item) (FinHistory * history,
		      gpointer     item);
};

GtkType fin_history_get_type (void);

FinHistory * fin_history_new (void);

void fin_history_undo (FinHistory * history);
void fin_history_redo (FinHistory * history);

void fin_history_remember (FinHistory * history,
			   gpointer     item);

void fin_history_clear (FinHistory * history);

void fin_history_dump (FinHistory * history);

#endif
