/******************************************************************************\
 gnofin/money.h   $Revision: 1.1 $
 Copyright (C) 1999 Darin Fisher
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#ifndef FIN_MONEY_H
#define FIN_MONEY_H

#include <stdlib.h>
#include <glib.h>

typedef long money_t;

#define fin_money_sign(amount)	  ((amount) < 0 ? -1 : 1)
#define fin_money_major(amount)   (labs(amount) / 100)
#define fin_money_minor(amount)   (labs(amount) % 100)

gchar *  fin_money_stringize (gchar * buf, int maxlen, money_t amount);
gboolean fin_money_parse     (const gchar * buf, money_t * amount);

#endif
