/* init.c - MemTest-86  Version 2.2
 *
 * Copyright 1999,  Chris Brady
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without fee
 * is granted provided that the above copyright notice appears in all copies.
 * It is provided "as is" without express or implied warranty.
 */

/* To enable BIOS memory sizing un-comment the following line */
/* #define BIOS_MEMSZ 1 */

#undef DEBUG
#include "test.h"
#include "defs.h"
#include "io.h"

extern unsigned long p1, p2;
extern volatile long *p;
extern struct vars *v;

unsigned long m_lim = 0;
volatile char *pp;
struct cpu_ident cpu_id;
long mem_info[3];
long st_low, st_high;
long end_low, end_high;

/*
 * Initialize test, setup screen and find out how much memory there is.
 */
void init()
{
	int i, n;

	outb(0x8, 0x3f2);  /* Kill Floppy Motor */
	serial_echo_init();
        serial_echo_print("[LINE_SCROLL;24r");    /* Set scrolling region row 7-23 */
        serial_echo_print("[H[2J");   /* Clear Screen */

	/* Set background to blue */
	for(i=0, pp=(char *)(SCREEN_ADR+1); i<80*24; i++, pp+=2) {
		*pp = 0x17;
	}

	/* Make the name background red */
	for(i=0, pp=(char *)(SCREEN_ADR+1); i<TITLE_WIDTH; i++, pp+=2) {
		*pp = 0x47;
	}

	/* Do reverse video for the bottom display line */
	for(i=0, pp=(char *)(SCREEN_ADR+1+(24 * 160)); i<80; i++, pp+=2) {
		*pp = 0x71;
	}

        serial_echo_print("[37m[44m");
        serial_echo_print("[0m");

        serial_echo_print("[37m[44m");
	cprint(0, 0, " Memtest-86 v2.2 ");
	cpu_type();
        serial_echo_print("[0m");
	cprint(0, 56, "Memory: ");

#ifdef BIOS_MEMSZ
	m_lim =  (mem_info[0] << 6) + mem_info[1];
	if (m_lim < mem_info[2]) {
		m_lim = mem_info[2];
	}
	m_lim += 0x400;
	m_lim *= 0x400;
#else
	/* Since all address bits are not decoded, the search for memory
	 * must be limited.  The max address is found by checking for
	 * memory wrap from 1mb to 4gb.  */
	v->map[0].start = (long *)0x1234569;
	p1 = (long)&v->map[0].start;
	m_lim = 0xffffffff; 
	for (p2 = 0x100000; p2; p2 <<= 1) {  
		p = (long *)(p1 + p2);
		if (*p == 0x1234569) {
			m_lim = --p2;
			break;
		}
	}
#endif

	/* Find all segments of RAM */

	p = (long *)(START_ADR + 0x400);
	i = 0;
	v->map[i].start = p;
	aprint(0, 64, (long)0);
	cprint(0, 69, " - ");

	/* Limit search for memory to m_lim and make sure we don't 
	 * overflow the 32 bit size of p.  */
	while ((long)p < m_lim && (long)p > START_ADR) {
		/*
		 * Skip over reserved memory
		 */
		if ((long)p < SKIP_END && (long)p >= SKIP_START) {
			v->map[i].end = (long *)SKIP_START;
			v->map[i].v = 1;
			aprint(i, 72, (long)p);
			p = (long *)SKIP_END;
			i++;
			v->map[i].start = 0;
			goto fstart;
		}

		if (check_ram() == 0) {
			/* ROM or nothing at this address, record end addrs */
			v->map[i].end = p;
			v->map[i].v = 1;
			aprint(i, 72, (long)p);
			i++;
			v->map[i].start = 0;
fstart:

			/* We get here when there is a gap in memory.
			 * Loop until we find more ram, the gap is more
			 * than 16384k or we hit m_lim */
			n = 16384*4;
			while ((long)p < m_lim && (long)p > START_ADR) {

				/* Skip over video memory */
				if ((long)p < SKIP_END &&
					(long)p >= SKIP_START) {
					p = (long *)SKIP_END;
				}
				if (check_ram() == 1) {
					/* More RAM, record start addrs */
					v->map[i].start = p;
					aprint(i, 64, (long)p);
					cprint(i, 69, " - ");
					break;
				}

				/* If the gap is 16384k or more then there
				 * is probably no more memory so bail out */
				if (--n <= 0) {
					p = (long *)m_lim;
					break;
				}
				p += 0x100;
			}
		}
		p += 0x100;
	}

	/* If there is ram right up to the memory limit this will record
	 * the last address.  */
	if (v->map[i].start) {
		v->map[i].end = (long *)m_lim;
		v->map[i].v = 1;
		aprint(i, 72, (long)m_lim);
		i++;
		v->map[i].start = 0;
	}
	v->testsel = -1;
	v->msegs = i;
	v->msg_line = LINE_SCROLL-1;
	v->scroll_start = v->msg_line * 160;

	/* Make a copy of the memory map */
	for (i=0; i< v->msegs; i++) {
		v->rmap[i].start = v->map[i].start;
		v->rmap[i].end = v->map[i].end;
	}
	v->lim_lower = 0;
	v->lim_upper = (long)v->rmap[v->msegs-1].end;
	cprint(LINE_TST, 0, "Test No:");
	cprint(LINE_RANGE, 0, "Testing: ");
	cprint(LINE_PAT, 0, "Pattern:");
	cprint(LINE_CACHE, 0, "  Cache:");
	cprint(LINE_REF, 0, "Refresh:");
	cprint(LINE_ERR, 64, "Errors:");
	dprint(LINE_ERR, 72, 0, 6, 1);
	cprint(LINE_PASS, 66, "Pass:");
	dprint(LINE_PASS, 72, v->pass, 6, 1);
	if (v->rdtsc) {
		cprint(0, TIMEX+5, ":  :");
	}
/*
	cprint(LINE_SEQ, 0, "TestSeq:");
	switch(v->xtst_flag) {
	case 0:
		cprint(LINE_SEQ, 9, "Default ");
		break;
	case 1:
		cprint(LINE_SEQ, 9, "Extended");
		break;
	case 2:
		cprint(LINE_SEQ, 9, "All     ");
		break;
	}
*/
	footer();
}

/* check_ram - Determine if this address points to memory by checking
 * for a wrap pattern and then reading and then writing the complement.
 * We then check that at least one bit changed in each byte before
 * believing that it really is memory.  */

int check_ram() {
	int s;

	p1 = *p;

	/* write the complement */
	*p = ~p1;
	p2 = *p;
	s = 0;

	/* Now make sure a bit changed in each byte */
	if ((0xff & p1) != (0xff & p2)) {
		s++;
	}
	if ((0xff00 & p1) != (0xff00 & p2)) {
		s++;
	}
	if ((0xff0000 & p1) != (0xff0000 & p2)) {
		s++;
	}
	if ((0xff000000 & p1) != (0xff000000 & p2)) {
		s++;
	}
	if (s == 4) {
		/* RAM at this address */
		return 1;
	}

	return 0;
}

/*
 * Find CPU type and cache sizes
 */
void cpu_type()
{
	int i, off=0;
	int dcache=0, icache=0, l2_cache=0;
	long speed;

	v->rdtsc = 0;
	cprint(LINE_CPU, COL_CPU-10, "CPU Type:");

#ifdef DEBUG
	dprint(8,0,cpu_id.type,3,1);
	dprint(9,0,cpu_id.model,3,1);
	dprint(10,0,cpu_id.cpuid,3,1);
#endif

	/* If the CPUID instruction is not supported then this is */
	/* a 386, 486 or one of the early Cyrix CPU's */
	if (cpu_id.cpuid < 1) {
		switch (cpu_id.type) {
		case 2:
			/* This is a Cyrix CPU without CPUID */
			i = getCx86(0xfe);
			i &= 0xf0;
			i >>= 4;
			switch(i) {
			case 0:
			case 1:
				cprint(LINE_CPU, COL_CPU, "Cyrix Cx486");
				break;
			case 2:
				cprint(LINE_CPU, COL_CPU,"Cyrix 5x86");
				break;
			case 3:
				cprint(LINE_CPU, COL_CPU,"Cyrix 6x86");
				break;
			case 4:
				cprint(LINE_CPU, COL_CPU,"Cyrix MediaGX");
				break;
			case 5:
				cprint(LINE_CPU, COL_CPU,"Cyrix 6x86MX");
				break;
			case 6:
				cprint(LINE_CPU, COL_CPU,"Cyrix MII");
				break;
			default:
				cprint(LINE_CPU, COL_CPU,"Cyrix ???");
				break;
			}
			break;
		case 3:
			cprint(LINE_CPU, COL_CPU, "386");
			break;

		case 4:
			cprint(LINE_CPU, COL_CPU, "486");
			break;
		}
		return;
	}

	switch(cpu_id.vend_id[0]) {
	/* AMD Processors */
	case 'A':
		switch(cpu_id.type) {
		case 4:
			cprint(LINE_CPU, COL_CPU, "AMD 486/586");
			/* Since we can't get CPU speed or cache info return */
			return;
		case 5:
			switch(cpu_id.model) {
			case 0:
			case 1:
			case 2:
			case 3:
				cprint(LINE_CPU, COL_CPU, "AMD K5");
				off = 6;
				break;
			case 6:
			case 7:
				cprint(LINE_CPU, COL_CPU, "AMD K6");
				off = 6;
				dcache = cpu_id.cache_info[3];
				icache = cpu_id.cache_info[7];
				break;
			case 8:
				cprint(LINE_CPU, COL_CPU, "AMD K6-2");
				off = 8;
				dcache = cpu_id.cache_info[3];
				icache = cpu_id.cache_info[7];
				break;
			case 9:
				cprint(LINE_CPU, COL_CPU, "AMD K6-III");
				off = 10;
				dcache = cpu_id.cache_info[3];
				icache = cpu_id.cache_info[7];
				l2_cache = (cpu_id.cache_info[11] << 8);
				l2_cache += cpu_id.cache_info[10];
				break;
			}
			break;
		case 6:
			cprint(LINE_CPU, COL_CPU, "AMD Athlon");
			off = 10;
			dcache = cpu_id.cache_info[3];
			icache = cpu_id.cache_info[7];
			l2_cache = (cpu_id.cache_info[11] << 8);
			l2_cache += cpu_id.cache_info[10];
		}
		break;

	/* Intel Processors */
	case 'G':
		if (cpu_id.type == 4) {
			switch(cpu_id.model) {
			case 0:
			case 1:
				cprint(LINE_CPU, COL_CPU, "Intel 486DX");
				off = 11;
				break;
			case 2:
				cprint(LINE_CPU, COL_CPU, "Intel 486SX");
				off = 11;
				break;
			case 3:
				cprint(LINE_CPU, COL_CPU, "Intel 486DX2");
				off = 12;
				break;
			case 4:
				cprint(LINE_CPU, COL_CPU, "Intel 486SL");
				off = 11;
				break;
			case 5:
				cprint(LINE_CPU, COL_CPU, "Intel 486SX2");
				off = 12;
				break;
			case 8:
				cprint(LINE_CPU, COL_CPU, "Intel 486DX4");
				off = 12;
				break;
			}
			/* Since we can't get CPU speed or cache info return */
			return;
		}

		/* Get the cache info */
		for (i=0; i<16; i++) {
#ifdef DEBUG
			dprint(11,i*3,cpu_id.cache_info[i],2,1);
#endif
			switch(cpu_id.cache_info[i]) {
			case 0x6:
				icache = 8;
				break;
			case 0x8:
				icache = 16;
				break;
			case 0xa:
				dcache = 8;
				break;
			case 0xc:
				dcache = 16;
				break;
			case 0x40:
				l2_cache = 0;
				break;
			case 0x41:
				l2_cache = 128;
				break;
			case 0x42:
				l2_cache = 256;
				break;
			case 0x43:
				l2_cache = 512;
				break;
			case 0x44:
				l2_cache = 1024;
				break;
			case 0x45:
				l2_cache = 2048;
				break;
			}
		}

		switch(cpu_id.type) {
		case 5:
			if (cpu_id.model == 4) {
				cprint(LINE_CPU, COL_CPU, "Pentium-MMX");
				off = 11;
			} else {
				cprint(LINE_CPU, COL_CPU, "Pentium");
				off = 7;
			}
			break;
		case 6:
			switch(cpu_id.model) {
			case 1:
				cprint(LINE_CPU, COL_CPU, "Pentium Pro");
				off = 11;
				break;
			case 3:
				cprint(LINE_CPU, COL_CPU, "Pentium II");
				off = 10;
				break;
			case 5:
				if (l2_cache) {
					cprint(LINE_CPU, COL_CPU, "Pentium II");
					off = 10;
				} else {
					cprint(LINE_CPU, COL_CPU, "Celeron");
					off = 7;
				}
				break;
			case 6:
				cprint(LINE_CPU, COL_CPU, "Celeron");
				off = 7;
				break;
			case 7:
				cprint(LINE_CPU, COL_CPU, "Pentium III");
				off = 11;
				break;
			}
		}
		break;

	/* Cyrix Processors with CPUID */
	case 'C':
		switch(cpu_id.model) {
		case 0:
			cprint(LINE_CPU, COL_CPU, "Cyrix 6x86MX/MII");
			off = 16;
			break;
		case 4:
			cprint(LINE_CPU, COL_CPU, "Cyrix GXm");
			off = 9;
			break;
		}
		return;
		break;

	/* Unknown processor */
	default:
		off = 3;
		/* Make a guess at the family */
		switch(cpu_id.type) {
		case 5:
			cprint(LINE_CPU, COL_CPU, "586");
			return;
		case 6:
			cprint(LINE_CPU, COL_CPU, "686");
			return;
		}
	}

	/* We are here only if the CPU type supports the rdtsc instruction */
	/* Print CPU speed */
	if ((speed = cpuspeed()) > 0) {
		speed += 50; /* for rounding */
		cprint(LINE_CPU, COL_CPU+off, " (   . mhz)");
		dprint(LINE_CPU, COL_CPU+off+2, speed/1000, 3, 1);
		dprint(LINE_CPU, COL_CPU+off+6, (speed/100)%10, 1, 0);
	}

	/* Print out cache info */
	if (icache+dcache) {
		cprint(LINE_CPU+1, COL_CPU-10, "L1 Cache:     k");
		dprint(LINE_CPU+1, COL_CPU, icache + dcache, 4, 0);
	}
	if (l2_cache) {
		cprint(LINE_CPU+2, COL_CPU-10, "L2 Cache:     k");
		dprint(LINE_CPU+2, COL_CPU, l2_cache, 4, 0);
	}

        asm __volatile__ ("rdtsc":"=a" (v->startl),"=d" (v->starth));
        v->snapl = v->startl;
        v->snaph = v->starth;
	v->rdtsc = 1;
}

/* #define TICKS 5 * 11832 (count = 6376)*/
/* #define TICKS (65536 - 12752) */
#define TICKS (65536 - 8271)
int cpuspeed()
{
	int loops;

	/* Setup timer */
	outb((inb(0x61) & ~0x02) | 0x01, 0x61);
	outb(0xb0, 0x43); 
	outb(TICKS & 0xff, 0x42);
	outb(TICKS >> 8, 0x42);

	asm __volatile__ ("rdtsc":"=a" (st_low),"=d" (st_high));

	loops = 0;
	do {
		loops++;
	} while ((inb(0x61) & 0x20) == 0);

	asm __volatile__ (
		"rdtsc\n\t" \
		"subl st_low,%%eax\n\t" \
		"subl st_high,%%edx\n\t" \
		:"=a" (end_low), "=d" (end_high)
		:: "esi", "edi", "ecx"
	);

	/* Make sure we have a credible result */
	if (loops < 4 || end_low < 50000) {
		return(-1);
	}
	v->clks_msec = end_low/48;
	return(v->clks_msec);
}
