
/*----------------------------------------------------------------------------*

	LinuxInfo_sparc.c
		by Alex Buell
			September 1998

 ----------------------------------------------------------------------------- 

	Handles the Sparc architecture	

 ----------------------------------------------------------------------------- 

	HISTORY

	1.01 - Initial development

 -----------------------------------------------------------------------------*/

#include "linuxinfo.h"

#ifdef system_sparc

void GetHardwareInfo(struct hw_stat *hw)
{
        int processors = 0;
        float bogomips = 0.0;
        float tempbogo;
        LONGLONG memory = 0;

        char temp_string[BUFSIZ], temp_string2[BUFSIZ];
        char chip[BUFSIZ], vendor[BUFSIZ], model[BUFSIZ];

        FILE *procfile;
        struct stat st_buf;
 
	if ((procfile = fopen(CPUINFO_FILE, "r")) != NULL)
	{
		while ((fscanf(procfile, "%s", (char *)&temp_string2) != EOF))
		{
			if (!(strcmp(temp_string2, "ncpus")) && (processors == 0))
			{
				fscanf(procfile, "%s%s", (char *)&temp_string, (char *)&temp_string);
				fscanf(procfile, "%d", &processors);
				rewind(procfile);
			}

			if (!(strcmp(temp_string2, "cpu"))) 
			{
				fscanf(procfile, "%s", (char *)&temp_string);
				GetStringFromFile(procfile, (char *)&model);
				sprintf(temp_string, "%s", model);
			}

			/* Convert into a human-readable form */
			if (strstr(temp_string, "Texas") != NULL)
				sprintf(vendor, "%s", "TI");

			if (strstr(temp_string, "Cypress") != NULL)
				sprintf(vendor, "%s", "Sparc");

			if (strstr(temp_string, "SuperSparc") != NULL)
				sprintf(model, "%s", "SuperSparc");

			if (strstr(temp_string2, "Bogo") != NULL)
			{
				if (strstr(temp_string2, "Cpu") != NULL)
				{
					fscanf(procfile, "%s%f", (char *)&hw->hw_bogomips, &tempbogo);
					bogomips += tempbogo;
				}

				if (strstr(temp_string2, "Mips") != NULL)
				{
					fscanf(procfile, "%s%f", (char *)&hw->hw_bogomips, &tempbogo);
					bogomips += tempbogo;
				}
			}
		}
        }
	fclose(procfile);

        stat(MEMORY_FILE, &st_buf);
        memory = st_buf.st_size;
        memory /= 1024; memory /= 1024;
        sprintf(hw->hw_memory, "%ld", (long int)memory);

        hw->hw_processors = processors;

        sprintf(hw->hw_cpuinfo, "%s %s", vendor, model);
        sprintf(hw->hw_bogomips, "%.2f", bogomips);
}

#endif /* system_sparc */
