/*
 * Hardware tuning for the VIA 82C586_0 PCI-to-ISA bridge
 */

#include "82C586_0.h"

void tune_VIA_586_0(struct pci_dev *current_dev)
{
	int throw_away;
	word revision_id;

	const char unknown82c586txt[]="Unknown VIA 82C586 detected, please report this as a bug. Revision ID= %d";

	/* Subsystem id is programmable on VIA MVP3 so could be anything
	   so it looks as if we have to use the revision id */
	revision_id = pci_read_word (current_dev, PCI_REVISION_ID);

	switch (revision_id)  {

		case 0x00 ... 0x3e:
			throw_away = tune_device (VIA_82C586_0_Tweaks, current_dev);
			break;

		case 0x3f:
			throw_away = tune_device (VIA_82C586_0_Tweaks, current_dev); 
			break;

		case 0x40 ... 0x4f:
			throw_away = tune_device (VIA_82C586_0_Tweaks, current_dev);
			break;

		// FIXME:This curently detects but does nothing extra to 82C586B (3041 and 3040 silicon)
		default:
			/* if we end up here then we don't know what the chipset is */
			if (open_log_file(&logfile)==TRUE) {
				fprintf(logfile, unknown82c586txt, revision_id);
				close_log_file(&logfile);
			}
			printf (unknown82c586txt, revision_id);
			break;
	}
}
