/*
 * Hardware tuning for the VIA 82C597_0 Host bridge rev 4 and above,
 * which is really an 82C598 pretending to be an 82C597
 *
 * Modified from 82C597_0.h by Richard Pruen (axxe@drk1.demon.co.uk)
 */

#define PCI_DEVICE_ID_597_0 0x0597

// Note, The tweaks commented out are done so until they have
// been double checked - DJ.
static Tweaks_t VIA_82C597_0_MVP3_Tweaks[] = {
	/* Tagname			Reg	Mask 		Bit	Description	*/
	{ "LEVEL_2_CACHE",			0x50,	1<<6|1<<7,	1<<7,	"Level 2 Cache"},
	{ "LINEAR_BURST",			0x50,	1<<5,		1<<5,	"Linear burst"},
//	{ "BACKOFF_CPU",			0x51,	1<<5,		0<<5,	"Backoff CPU"},
	{ "LEVEL2_WRITETHROUGH",	0x52,	1<<0,		1<<0,	"Level 2 Cache Write through"},
	{ "LEVEL2_FILL_ON_SINGLE_RD",0x52,	1<<2,		1<<2,	"Level 2 Cache fill on single read"},
	{ "READ_AROUND_WRITE",		0x53,	1<<7,		1<<7,	"Read around write"},
	{ "CACHE_READ_PIPELINE",	0x53,	1<<6,		1<<6,	"Cache read pipeline"},
	{ "CACHE_WRITE_PIPELINE",	0x53,	1<<5,		1<<5,	"Cache write pipeline"},
	{ "DRAM_READ_PIPELINE",		0x53,	1<<4,		1<<4,	"DRAM read pipeline"},
	{ "BURST_REFRESH",			0x68,	1<<2,		1<<2,	"Burst refresh"},
//	{ "DRAM_ARBIT_POLICY",	0x6b,	1<<6|1<<7,	1<<6,	"DRAM arbitration policy"},
//	{ "MULTI_PAGE_OPEN",	0x6b,	1<<0		1<<0,	"Multi page open"},	
	{ "1T_DDR_WR_RD_TURNAROUND",0x6c,	1<<4,		0<<4,	"1T DDR write to read turnaround"},
	{ "SINGLE_RW_BURST_STOP",	0x6c,	1<<3,		1<<3,	"Single RW burst stop command"},
	{ "DELAY_DRAM_READ_LATCH",	0x6d,	1<<6|1<<5,	1<<5,	"DRAM read latch delay"},
	{ "CPU_TO_PCI_POSTWRITE",	0x70,	1<<7,		1<<7,	"CPU->PCI posted write"},
	{ "PCI_TO_RAM_POSTWRITE",	0x70,	1<<6,		1<<6,	"PCI->RAM posted write"},
	{ "PCI_TO_RAM_PREFETCH",	0x70,	1<<5,		1<<5,	"PCI->RAM prefetch"},
	{ "DELAYED_TRANSACTION",	0x70,	1<<0,		1<<0,	"Delayed transactions"},
	{ "DYNAMIC_PCI_BURST",		0x71,	1<<7,		1<<7,	"Dynamic PCI burst"},
	{ "BYTE_MERGING",			0x71,	1<<6,		1<<6,	"Byte merging"},
	{ "PCI_IO_POSTWRITE",		0x71,	1<<4,		1<<4,	"PCI I/O cycle post write"},
	{ "PCI_FAST_B2B_WRITE",		0x71,	1<<2,		1<<2,	"PCI fast back to back write"},
	{ "QUICKFRAME_GENERATE",	0x71,	1<<1,		1<<1,	"Quick frame generation"},
	{ "FAST_PCI_CYCLES",		0x71,	1<<0,		1<<0,	"Fast PCI cycles"},
//	{ "CPU_TO_PCI_RETRY_CNT",	0x72,	1<<4|1<<5,	1<<4,	"CPU->PCI retry count and retry backoff"},
	{ "CPU_BACKOFF_RD_FAIL",	0x72,	1<<2,		1<<2,	"CPU backoff on PCI read retry failure"},
	{ "REDUCE_1T_FRAME_GEN",	0x72,	1<<1,		1<<0,	"Reduce 1T for FRAME# generation"},
	{ "PCI_0WS_WRITE",			0x73,	1<<6,		0<<6,	"PCI Master 0 wait state write"},
	{ "PCI_0WS_READ",			0x73,	1<<5,		0<<5,	"PCI Master 0 wait state read"},
	{ "PCI_RD_PREFETCH",		0x74,	1<<7,		1<<7,	"PCI read prefetch by enhance"},
	{ "PCI_WR_MERGE",			0x74,	1<<6,		1<<6,	"PCI master write merge"},

/*  The tweaks below should not be used together, the latter seems to work better
    for me, particularly with high system load, but who knows? Try the other if you like.
    PCI_ARBIT=1 should only be used if the others are =0, and vice versa.
*/
	{ "PCI_ARBIT",				0x75,	1<<7,		1<<7,	"Fair PCI - CPU Arbitration"},
	{ "PCI_ARBIT_2",			0x76,	1<<5|1<<4,	1<<5|1<<4, "CPU gets PCI bus every 3rd master grant"},
	{ "PCI_ARBIT_2_NO_TIME",	0x76,	1<<6,		1<<6,	"CPU has no time slot on PCI"},

/* MVP3 AGP (X2 particulary) can cause problems, use caution! */

	{ "MVP3_AGP_X2_SUPPORT",	0xac,	1<<3,		1<<3,	"MVP3 AGP X2 Support"},

	{ 0, 0, 0, 0, 0 }
};
