#include "config.h"
#include "stat_dir.h"
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>

/* ****************************************************************** */
void stat_dir(char *dirname) {
  struct stat filestat;

  if(stat(dirname,&filestat) != 0) {
    fprintf(stderr, "Could not stat directory %s.\n",dirname);
    exit(1);
  }
  if( !S_ISDIR(filestat.st_mode) ) {
    fprintf(stderr, "%s is not a directory.\n",dirname);
    exit(1);
  }
  if((filestat.st_mode & S_IWUSR) != S_IWUSR) {
    fprintf(stderr, "%s is not writable.\n",dirname);
    exit(1);
  }
  filestat.st_mode = 0;
}
/* ****************************************************************** */
