#include "config.h"
#include "hostname.h"
#include <unistd.h>
#include <sys/time.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* ****************************************************************** */
char *mk_tempfile(void) {
  unsigned long int bytes=12; /* usec, pid, 2 dots. */
  struct timeval  curtime;
  struct timezone curzone;
  unsigned long int a, temp;
  unsigned long int pid = (unsigned long)getpid();
  char hostnamebuf[1024];
  char *retval;

  /* Get a microsecond timestamp with which to build a filename. */
  if(gettimeofday(&curtime, &curzone) != 0) exit(1);

  /* Decide how long a string to write for the timestamp. */
  get_hostname(hostnamebuf,1023);
  for(temp = curtime.tv_sec; temp>0; bytes++)  temp /= 10;

  /* Allocate space for the timestamp. */
  retval = (char *)malloc(bytes + strlen(hostnamebuf) + 1);
  if(retval == NULL) {
    fprintf(stderr, "Could not allocate memory.\n");
    exit(1);
  }

  /* Record the microsecond timestamp on the string. */
  retval[bytes--] = '\0';
  retval[bytes--] = '.';
  for(a = 0; a++<5; pid /= 10) {
    retval[bytes--] = (char) ((pid % 10) + 48);
  }
  for(temp = curtime.tv_usec, a=0; a++<5; temp /= 10) {
    retval[bytes--] = (char) ((temp % 10) + 48);
  }
  retval[bytes--] = '.';
  for(temp = curtime.tv_sec; temp>0; temp /= 10) {
    retval[bytes--] = (char) ((temp % 10) + 48);
  }

  /* Append the hostname now. */
  strcat(retval,hostnamebuf);

  /* Return the timestamp now. */
  return(retval);
}
/* ****************************************************************** */


