/* # skkinput (Simple Kana-Kanji Input)
 * SkkInput.h --- Public Header file for SkkInputWidget.
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef _SkkInput_h
#define _SkkInput_h

/* ¿ʬɬפʥѥ᡼ CoreWidget äƤΡ

 ̾                饹                           ̵
 ----                ------             --              ------------
 background	     Background		pixel		White
 border		     BorderColor	pixel		Black
 borderWidth	     BorderWidth	int		1
 foreground	     Foreground		Pixel		Black
 height		     Height		int		120
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 reverseVideo	     ReverseVideo	Boolean		False
 width		     Width		int		120
 x		     Position		int		0
 y		     Position		int		0
*/

#define XtNkanjiFont		"kanjiFont"
#define XtNfixNotify		"fixNotify"
#define XtNendNotify		"endNotify"
#define XtNkeybackNotify	"keybackNotify"
#define XtNjhenkanNotify	"jhenkanNotify"
#define XtNjhenkanendNotify	"jhenkanendNotify"
#define XtNjsavejisyoNotify	"jsavejisyoNotify"
#define XtNjtangotourokuNotify	"jtangotourokuNotify"
#define XtNjtangosakujoNotify	"jtangosakujoNotify"
#define XtNjcompletionNotify	"jcompletionNotify"
#define XtNjcompletioncloseNotify	"jcompletionCloseNotify"
#define XtNnotmodifiedNotify	"notmodifiedNotify"

#define XtNcompatibleCloseSkkinputKey	"compatibleCloseSkkinputKey"
#define XtCCompatibleCloseSkkinputKey	"CompatibleCloseSkkinputKey"
#define XtNeggLikeNewline	"eggLikeNewline"
#define XtCEggLikeNewline	"EggLikeNewline"
#define XtNchatAdapter		"chatAdapter"
#define XtCChatAdapter		"ChatAdapter"
#define XtNinitPosition		"initPosition"
#define XtCInitPosition		"InitPosition"
#define XtNwillBeDestroyed	"willBeDestroyed"
#define XtCWillBeDestroyed	"WillBeDestroyed"
#define XtNdateAd		"dateAd"
#define XtCDateAd		"DateAd"
#define XtNnumberStyle		"numberStyle"
#define XtCNumberStyle		"NumberStyle"
#define XtNdeleteImpliesKakutei	"deleteImpliesKakutei"
#define XtCDeleteImpliesKakutei	"DeleteImpliesKakutei"
#define XtNuseNumericConversion	"useNumericConversion"
#define XtCUseNumericConversion	"UseNumericConversion"
#define XtNjisyoDirty		"jisyoDirty"
#define XtCJisyoDirty		"JisyoDirty"

#define XtNinputVector		"inputVector"
#define XtCInputVector		"InputVector"
#define XtNzenkakuVector	"zenkakuVector"
#define XtCZenkakuVector	"ZenkakuVector"
#define XtNromKanaRuleList	"romKanaRuleList"
#define XtCRomKanaRuleList	"RomKanaRuleList"
#define XtNkeySkkMap		"keySkkMap"
#define XtCKeySkkMap		"KeySkkMap"
#define XtNkeyAbbrevMap		"keyAbbrevMap"
#define XtCKeyAbbrevMap		"KeyAbbrevMap"
#define XtNkeyTwoMap		"keyTwoMap"
#define XtCKeyTwoMap		"KeyTwoMap"
#define XtNtabWidth		"tabWidth"
#define XtCTabWidth		"TabWidth"

typedef struct _SkkInputRec		*SkkInputWidget ;
typedef struct _SkkInputClassRec	*SkkInputWidgetClass ;

extern WidgetClass skkinputWidgetClass ;

#endif
