/*
 *
 * (c) Vladi Belperchinov-Shabanski "Cade" <cade@biscom.net> 1996-1999
 *
 * SEE `README',`LICENSE' OR `COPYING' FILE FOR LICENSE AND OTHER DETAILS!
 *
 */

#ifndef _VFUSYS_H_
#define _VFUSYS_H_

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

  #define ATTR_OFF      "----------"
#ifdef _TARGET_GO32_
  #define ATTR_STRING   "DV----RHSA"
  #define ATTR_MASK     "------????"
  #define ATTR_WRITE_ON "??????---?" // use this to allow WRITE
  #define ATTR_RO    1
  #define ATTR_HID   2
  #define ATTR_SYS   4
  #define ATTR_VOL   8
  #define ATTR_DIR  16
  #define ATTR_ARC  32
#endif

#ifdef _TARGET_UNIX_
  #define ATTR_STRING   "drwxrwxrwx"
  #define ATTR_MASK     "-?????????"
  #define ATTR_WRITE_ON "??w???????" // use this to allow WRITE
#endif

typedef char attrs_t[12];
// these functions set/get file's attributes/mode from/to string
// with this format:
// for Linux/UNIX:  drwxrwxrwx
// for DOS:         DV----RHSA
// is is supposed that all attribs count is 10
void fgetattr_s( const mode_t tm, char *stmode );
int fgetattr_s( const char *filename, char *target );
int  fsetattr_s( const char *filename, const char *attrs );
void rollattr( const int n, char *attrs, int allow_masking = 1 );
int EditAttr( char *attrs, int allow_masking = 1 );

#define DirExist( d ) (access( d, F_OK ) == 0)
// !!! trqbva da proverqva dali e DIR!
#define FileExist( d ) (access( d, F_OK ) == 0)

#ifdef _TARGET_GO32_
int get_sfn( const char *in, char *out );
int get_lfn( const char *in, char *out );
#endif

#endif //_VFUSYS_H_

 // eof vfusys.h
