/*
 *
 * (c) Vladi Belperchinov-Shabanski "Cade" <cade@biscom.net> 1996-1999
 *
 * SEE `README',`LICENSE' OR `COPYING' FILE FOR LICENSE AND OTHER DETAILS!
 *
 */

#ifndef _VFUUTI_H_
#define _VFUUTI_H_

#include "vfu.h"

// ShellOptions
int UpdateShellStr( const char * pS, char * pD, char *Options );

///////////////////////////////////////////////////////////////////////////
// FILENAMES functions
/*
char* FixPath( char* s, int slashtype = '/' ); // adds trailing '/' if not exist
char* FileExt( const char *pS, char *Ext ); // returns extension
char* FileName( const char *pS, char *Name ); // returns file name only (w/o ext)
char* FileNameExt( const char *pS, char *Name ); // returns file (w. ext)
char* FilePath( const char *pS, char *Path ); // returns file name path (w. trailing '/')
*/

int PathCmp( const char* s1, const char* s2 ); // uses strcmp under linux and strcasecmp uder dos
int PathNCmp( const char* s1, const char* s2, int len ); // uses strncmp under linux and strncasecmp uder dos
///////////////////////////////////////////////////////////////////////////
//
//
//
/*
typedef char THistLine[512];
typedef THistLine THist10[10];
void AddHist10( const char* ps, THist10 hist, int nocase = 0 );
int MenuHist10( int x, int y, const char* title, THist10 hist, int firsthotkey = 0 );
*/

///////////////////////////////////////////////////////////////////////////
//
//
//

int PathSplit( const char *target, const char *delimiters, pathstr_t result[], int maxresults = -1 );

///////////////////////////////////////////////////////////////////////////
//
//
//
int EditStr( int x, int y, const char *prompt, int maxlen, int fieldlen, String *str );

int BreakOp();

int Ask( const char *prompt, const char *allowed, int line = 1 );

fsize_t CalcSelSize( int one ); // used before copy/move to calc estimated size

char* ExpandMask( char* mask );

char* TimeStr( const time_t tim, char* buf );

int IsFileRO( const char* fname ); // read only?

// removes ".."s
// if path is NULL, it's supposed dest is correct path for simplifying
char* SimplifyPath( const char* path, char* dest );

void Beep();

char* UpString( char *s );
char* LowString( char *s );

void SetMenuColors();
extern int MenuBoxExitCh;
extern int MenuBoxExitKey;
extern PSZCluster mb;
extern int PSZViewCN;
extern int PSZViewCH;
extern int PSZViewTI;
extern int PSZViewWrap;
extern int PSZViewPos;
extern int PSZViewClearBackground;
extern char PSZViewConfirm[64];
extern char PSZViewCancel[64];
extern char PSZViewIgnore[64];
int PSZView( int x, int y, int w, int h, const char *title, PSZCluster *sc, int hotkeys );

#define FTWALK_F   1 // file (regular)
#define FTWALK_D   2 // dir
#define FTWALK_L   4 // link!
#define FTWALK_LF  5 // link to file
#define FTWALK_LD  6 // link to dir
#define FTWALK_NS  11
#define FTWALK_ENTER 100 // call on entering directory
#define FTWALK_QUIT  200 // call on leaving directory
// file tree walk (ftw) down to `level' levels
// taken here just to avoid miscompability...
// level will be decreased in every dir.sublevel until reached 0 -- then ftwalk will cancel
// set level to -1 to recurse any dir.sublevels
int ftwalk(const char *dir, int (*func)(const char *, struct stat *, int), int level = -1 );

#ifdef _TARGET_GO32_
#include <dirent.h>
#include <dir.h>
int dosstat( DIR *dir, struct stat *stbuf );
#endif

void HistAdd( int hist_id, const char* str );
const char* HistGet( int hist_id, int index = 0 );
char* HistGet( int hist_id, int index, char* str );
int HistIndex( int hist_id, const char* value );
int HistCount( int hist_id );
void HistRemove( int hist_id, int index );

int HistMenu( int x, int y, const char* title, int hist_id );

#endif//_VFUUTI_H_
