/*
 *
 * (c) Vladi Belperchinov-Shabanski "Cade" <cade@biscom.net> 1998-1999
 *
 * SEE `README',`LICENSE' OR `COPYING' FILE FOR LICENSE AND OTHER DETAILS!
 *
 *  NOTE: this string library is based on `cxstring' lib (c) Ivo Baylov 1998
 * 
 */
#ifndef _VSTRING_H_
#define _VSTRING_H_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <assert.h>
#ifndef ASSERT
#define ASSERT assert
#endif

////////////////////////////////////////////////////////////////////////////
//
// STRING object
//

  #define BLOCKSIZE    256

  class String
  {
    int   sl; // string length 
    char* s;
    int   blocks;

    #define RESET { s = NULL; blocks = 0; sl = 0; nocase = 0; }

  public:

    String() { RESET; resize(sl); };
    ~String() { if (s) delete s; RESET; };

    String( const String& str )  { RESET; set(str); };
    String( const char* ps )  { RESET; set(ps); };
    String( const int n ) { RESET; seti(n); };
    String( const long n ) { RESET; setl(n); };
    String( const double n ) { RESET; setf(n); };

    const String& operator = ( const String& str ) { set( str.s ); return *this; };
    const String& operator = ( const char*   ps  ) { set( ps ); return *this; };
    const String& operator = ( const int     n   ) { seti(n); return *this; };
    const String& operator = ( const long    n   ) { setl(n); return *this; };
    const String& operator = ( const double  n   ) { setf(n); return *this; };

    const String& operator += ( const String& str ) { cat( str.s ); return *this; };
    const String& operator += ( const char* ps    ) { cat( ps ); return *this; };

//    #define SADD(s1,s2) String str = s1; str += s2; return str;
    friend String operator + ( const String& str1, const String& str2 );
    friend String operator + ( const String& str1, const char* ps );
    friend String operator + ( const char* ps, const String& str2 );

    int nocase;
    int cmp( const char* pcA ) { return nocase?strcasecmp( s, pcA ):strcmp( s, pcA ); };
    //int casecmp( const char* pcA ) { strcasecmp( m_pszText, pcA ); };

    int operator == ( const char* pcA ) { return cmp( pcA ) == 0; };
    int operator != ( const char* pcA ) { return cmp( pcA ) != 0; };
    /*
    int operator >  ( const char* pcA ) { return cmp( pcA ) >  0; };
    int operator >= ( const char* pcA ) { return cmp( pcA ) >= 0; };
    int operator <  ( const char* pcA ) { return cmp( pcA ) <  0; };
    int operator <= ( const char* pcA ) { return cmp( pcA ) <= 0; };
    */

    operator const char* ( ) const { return (const char*)s; }
//    operator char* ( ) { return (char*)s; }
    char operator [] ( int n ) { if( n >= 0 && n < sl ) return s[n]; else return 0; }

    char* getbuf() { return (char*)s; };

    const char* asis() { return s; }

    int len() { return sl; };

    void fixlen() { sl = strlen(s); };
    void fix() { sl = strlen(s); resize(sl); };

    void resize( size_t newsize );

    void   seti( const int n );
    void   setl( const long n );
    void   setf( const double d );
    void   setfi( const double d ); // sets double as int (w/o frac)
    int    geti() { return atoi( s ); };
    long   getl() { return atol( s ); };
    double getf() { return atof( s ); };

    void   set ( const char* ps );
    void   cat ( const char* ps );
    void   setn( const char* ps, int len );
    void   catn( const char* ps, int len );

    int check() { int len = strlen(s); return ((len == sl) && (len < blocks*BLOCKSIZE)); };
  };

////////////////////////////////////////////////////////////////////////////
//
// STRING functions
//
  inline int StrLen( const char* ps ) { return strlen( ps ); };
  inline char* StrSet( char* target, const char* ps ) { target[0] = 0; if (ps) strcpy( target, ps ); strcpy( target, ps ); return target; };

  char* StrMul( char* target, int n ); // multiplies the string n times, i.e. `1'*5 = `11111'

  int StrFind ( const char* target, const char  c, int startpos = 0 ); // returns first zero-based position of char, or -1 if not found
  int StrRFind( const char* target, const char  c ); // returns last zero-based position of char, or -1 if not found
  int StrFind ( const char* target, const char* s, int startpos = 0 ); // returns first zero-based position of string, or -1 if not found
  int StrRFind( const char* target, const char* s ); // returns last zero-based position of string, or -1 if not found

  char* StrDelete  ( char* target, int pos, int len ); // deletes `len' chars starting from `pos'
  char* StrInsert  ( char* target, int pos, const char* s ); // inserts `s' in position `pos'
  char* StrInsertCh( char* target, int pos, char ch ); // inserts `ch' in position `pos'
  char* StrReplace ( char* target, const char* out, const char* in ); // replace `out' w. `in'

  char* StrCopy  ( char* target, const char* source, int pos, int len ); // returns `len' chars from `pos'
  char* StrLeft  ( char* target, const char* source, int len ); // returns `len' chars from the left
  char* StrRight ( char* target, const char* source, int len ); // returns `len' chars from the right
  char* StrSLeft ( char* target, int len ); // SelfLeft -- just as 'Left' but works on `this'
  char* StrSRight( char* target, int len ); // SelfRight -- just as 'Right' but works on `this'

  char* StrTrimL ( char* target, int len ); // trims `len' chars from the beginning (left)
  char* StrTrimR ( char* target, int len ); // trim `len' chars from the end (right)

  void StrSetCh( char* target, const int pos, const char ch ); // sets `ch' char at position `pos'
  char StrGetCh( char* target, const int pos ); // return char at position `pos', -1 for the last char etc...
  void StrAddCh( char* target, const char ch ); // adds `ch' at the end

  // return first `word', i.e. from pos 0 to first found delimiter char
  // after that deletes this `word' from the string
  char* StrGetFirstWord( char* target, const char* delimiters, char* result );
  // ...same but `last' word
  char* StrGetLastWord( char* target, const char* delimiters, char* result );

  char* StrCutL  ( char* target, const char* charlist ); // remove all chars `charlist' from the beginning (i.e. from the left)
  char* StrCutR  ( char* target, const char* charlist ); // remove all chars `charlist' from the end (i.e. from the right)
  char* StrCut   ( char* target, const char* charlist ); // does `CutR(charlist);CutL(charlist);'
  char* StrCutSpc( char* target ); // does `Cut(" ");'

  // expand align in a field, filled w. `ch', if len > 0 then right, else left
  char* StrPad( char* target, int len, char ch = ' ' );

  // insert `commas' for 1000's delimiter or use another delimiter
  // string supposed to be a integer or real w/o `e' format
  char* StrComma( char* target, char delim = ',' );

  // translate chars from `from' to `to'
  // length of `from' MUST be equal to length of `to'
  char* StrTR( char* target, const char *from, const char *to );

  char* StrUpCase     ( char* target );
  char* StrLowCase    ( char* target );
  char* StrReverseCase( char* target ); // CUTE nali? :) // vladi

  char* StrReverse( char* target ); // reverse the string: `abcde' becomes `edcba' :)

  int StrCount( const char* target, const char* charlist, int startpos = 0 ); // returns match count of all chars from `charlist'

  int StrIsInt   ( const char* target ); // check if string is correct int value
  int StrIsDouble( const char* target ); // check if string is correct double (w/o `e' format :( )



////////////////////////////////////////////////////////////////////////////
//
// STRING change functions over's
// the only difference from the functions above is that string is resized
//

  inline int StrLen( String &target ) { return target.len(); };
  inline String &StrSet( String &target, const char* ps ) { target.set( ps ); return target; };

  String &StrMul( String &target, int n ); // multiplies the string n times, i.e. `1'*5 = `11111'

  String &StrDelete  ( String &target, int pos, int len ); // deletes `len' chars starting from `pos'
  String &StrInsert  ( String &target, int pos, const char* s ); // inserts `s' in position `pos'
  String &StrInsertCh( String &target, int pos, char ch ); // inserts `ch' in position `pos'
  String &StrReplace ( String &target, const char* out, const char* in ); // replace `out' w. `in'

  String &StrCopy  ( String &target, const char* source, int pos, int len ); // returns `len' chars from `pos'
  String &StrLeft  ( String &target, const char* source, int len ); // returns `len' chars from the left
  String &StrRight ( String &target, const char* source, int len ); // returns `len' chars from the right
  String &StrSLeft ( String &target, int len ); // SelfLeft -- just as 'Left' but works on `this'
  String &StrSRight( String &target, int len ); // SelfRight -- just as 'Right' but works on `this'

  String &StrTrimL ( String &target, int len ); // trims `len' chars from the beginning (left)
  String &StrTrimR ( String &target, int len ); // trim `len' chars from the end (right)

  String &StrCutL  ( String &target, const char* charlist ); // remove all chars `charlist' from the beginning (i.e. from the left)
  String &StrCutR  ( String &target, const char* charlist ); // remove all chars `charlist' from the end (i.e. from the right)
  String &StrCut   ( String &target, const char* charlist ); // does `CutR(charlist);CutL(charlist);'
  String &StrCutSpc( String &target ); // does `Cut(" ");'

  String &StrPad  ( String &target, int len, char ch = ' ' );
  String &StrComma( String &target, char delim = ',' );

  void StrSetCh( String &target, const int pos, const char ch ); // sets `ch' char at position `pos'
  char StrGetCh( String &target, const int pos ); // return char at position `pos', -1 for the last char etc...
  void StrAddCh( String &target, const char ch ); // adds `ch' at the end

  char*  StrGetFirstWord( String &target, const char* delimiters, char* result );
  char*  StrGetLastWord( String &target, const char* delimiters, char* result );

  // this `sprintf' like function works as follows:
  // 1. set `this.string' length to `init_size'
  // 2. call `sprintf' with `format' and `...'
  // NOTE: You have to supply enough `init_size'. sorry!
  int sprintf( int init_size, String &target, const char *format, ... );
  // this is equal to `printf( 1024, format, ... )', i.e. `init_size=1024'
  int sprintf( String &target, const char *format, ... );

  inline String &StrTR( String &target, const char *from, const char *to ) { StrTR( target.getbuf(), from, to ); return target; };
  inline String &StrUpCase     ( String &target ) { StrUpCase     ( target.getbuf() ); return target; };
  inline String &StrLowCase    ( String &target ) { StrLowCase    ( target.getbuf() ); return target; };
  inline String &StrReverseCase( String &target ) { StrReverseCase( target.getbuf() ); return target; };
  inline String &StrReverse    ( String &target ) { StrReverse    ( target.getbuf() ); return target; };

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////


#endif
