/*
 *
 * (c) Vladi Belperchinov-Shabanski "Cade" <cade@biscom.net> 1998-1999
 *
 * SEE `README',`LICENSE' OR `COPYING' FILE FOR LICENSE AND OTHER DETAILS!
 *
 */

#ifndef _VUTILS_H_
#define _VUTILS_H_

#include <target.h>

#include <sys/stat.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>

#ifdef _TARGET_UNIX_
#include <pwd.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/param.h>
#endif

#include "vstring.h"

#include <assert.h>
#ifndef ASSERT
#define ASSERT assert
#endif



///////////////////////////////////////////////////////////////////////////
// MISC defines

#define MAIN    int main( int argc, char* argv[] )

#ifndef MAX_PATH
#define MAX_PATH	512
#endif

///////////////////////////////////////////////////////////////////////////
// CRC functions

typedef unsigned long int crc_t;

#define CRCNULL (0xffffffff)

// should start with `0xffffffff' for `crc' and at the end the must be crc = ~crc;
crc_t UpdateCRC32( const unsigned char octet, const crc_t crc );
crc_t MemCRC32( const void* buff, int size );
crc_t StrCRC32( const char *s );
crc_t FileCRC32( FILE *f, long buffsize = 256*1024  );
crc_t FileCRC32( const char *fname, long buffsize = 256*1024  );

///////////////////////////////////////////////////////////////////////////
// FILE functions

long fsize( const char *fname );
long fsize( FILE *f );

int fload( FILE *f, void *buff, int size = -1 );
int fsave( FILE *f, void *buff, int size = -1 );
int fload( const char* fname, void *buff, int size = -1 );
int fsave( const char* fname, void *buff, int size = -1 );

int fload_crc32( const char* fname, void *buff, int size );
int fsave_crc32( const char* fname, void *buff, int size );

///////////////////////////////////////////////////////////////////////////
// FILENAMES functions

char* FixPath( char* s, int slashtype = '/' ); // adds trailing '/' if not exist
const char* FixPath( String &s, int slashtype = '/' ); // adds trailing '/' if not exist
char* FileExt( const char *pS, char *Ext ); // returns extension
char* FileName( const char *pS, char *Name ); // returns file name only (w/o ext)
char* FileNameExt( const char *pS, char *Name ); // returns file (w. ext)
char* FilePath( const char *pS, char *Path ); // returns file name path (w. trailing '/')

char* TildExpand( char* path ); // expands ~/path and ~name/path

///////////////////////////////////////////////////////////////////////////
// STRING functions

long htol( const char* s ); // hex to long

char*  time2str( const time_t tim );
time_t str2time( const char* timstr );

///////////////////////////////////////////////////////////////////////////

int MakePath( const char *s, long mode = S_IRUSR|S_IWUSR|S_IXUSR|S_IRGRP|S_IXGRP|S_IROTH|S_IXOTH );
void ExpandPath( const char *src, char *dest );

///////////////////////////////////////////////////////////////////////////
// CONFIG functions

// this returns `$HOME/$RC_PREFIX/$dir_prefix/'
// where $HOME and $RC_PREFIX are env.vars and `$dir_prefix' is arg. here
// this also makes sure that directory exists (i.e. create it)
// if $HOME is not available `/tmp/' is returned
const char* GetRcDir( const char* dir_prefix );

#endif //_VUTILS_H_

 // eof vutils.h
