/***************************************************************************
 *
 * $Header: /home/werner/ytree/RCS/init.c,v 1.12 1997/08/13 12:24:58 werner Rel $
 *
 * Initialisierungen
 *
 ***************************************************************************/


#include "ytree.h"





int Init(void)
{
  char buffer[PATH_LENGTH + 1];
  char *home;

  user_umask = umask(0);
  initscr();
  StartColors(); /* even on b/w terminals... */

  cbreak();  
  noecho();  
  nonl();  
  raw(); 
  keypad( stdscr, TRUE );  
  clearok(stdscr, TRUE);  
  leaveok(stdscr,FALSE);

  if( LINES < MIN_HEIGHT || COLS < MIN_WIDTH )
  {
    endwin();
   
    (void) fprintf( stderr, "Screen too small: min=%d x %d\n",
		    MIN_HEIGHT, MIN_WIDTH
		  );
    return( 1 );
  }
  WbkgdSet( stdscr, COLOR_PAIR(WINDIR_COLOR)|A_BOLD); 

  dir_window = subwin( stdscr, 
		       DIR_WINDOW_HEIGHT, 
		       DIR_WINDOW_WIDTH, 
		       DIR_WINDOW_Y, 
		       DIR_WINDOW_X
		      );
  
  keypad( dir_window, TRUE );  
  scrollok( dir_window, TRUE );
  clearok( dir_window, TRUE);  
  leaveok(dir_window, TRUE); 
  WbkgdSet( dir_window, COLOR_PAIR(WINDIR_COLOR) );
  
  small_file_window = subwin( stdscr, 
			      FILE_WINDOW_1_HEIGHT, 
			      FILE_WINDOW_1_WIDTH, 
			      FILE_WINDOW_1_Y, 
		              FILE_WINDOW_1_X
		           );
  
  keypad( small_file_window, TRUE );
  clearok(small_file_window, TRUE);  
  leaveok(small_file_window, TRUE);

  WbkgdSet(small_file_window, COLOR_PAIR(WINFILE_COLOR));
  
  big_file_window = subwin( stdscr, 
			    FILE_WINDOW_2_HEIGHT, 
			    FILE_WINDOW_2_WIDTH, 
			    FILE_WINDOW_2_Y, 
		            FILE_WINDOW_2_X
		          );
  
  keypad( big_file_window, TRUE );
  clearok(big_file_window, TRUE);    
  leaveok(big_file_window, TRUE);
  WbkgdSet(big_file_window, COLOR_PAIR(WINFILE_COLOR));

  error_window = newwin( 
		       ERROR_WINDOW_HEIGHT, 
		       ERROR_WINDOW_WIDTH, 
		       ERROR_WINDOW_Y, 
		       ERROR_WINDOW_X
		      );
  WbkgdSet(error_window, COLOR_PAIR(WINERR_COLOR));
  clearok(error_window, TRUE);       
  leaveok(error_window, TRUE);
 
  time_window = subwin( stdscr,
                      TIME_WINDOW_HEIGHT ,
                      TIME_WINDOW_WIDTH ,
                      TIME_WINDOW_Y,
                      TIME_WINDOW_X
                    );
  clearok( time_window, TRUE );  
  scrollok( time_window, FALSE );
  leaveok( time_window, TRUE );
  WbkgdSet( time_window, COLOR_PAIR(WINDIR_COLOR|A_BOLD) );

  history_window = newwin(
                       HISTORY_WINDOW_HEIGHT,
                       HISTORY_WINDOW_WIDTH,
                       HISTORY_WINDOW_Y,
                       HISTORY_WINDOW_X
                      );
  scrollok(history_window, TRUE);
  clearok(history_window, TRUE );  
  leaveok(history_window, TRUE);
  WbkgdSet(history_window, COLOR_PAIR(WINHST_COLOR));

  f2_window = newwin( F2_WINDOW_HEIGHT,
                      F2_WINDOW_WIDTH,
                      F2_WINDOW_Y,
                      F2_WINDOW_X
                    );

  keypad( f2_window, TRUE );  
  scrollok( f2_window, FALSE );
  clearok( f2_window, TRUE);  
  leaveok( f2_window, TRUE );
  WbkgdSet( f2_window, COLOR_PAIR(WINHST_COLOR) );

  clear();
 
  if( baudrate() >= QUICK_BAUD_RATE ) typeahead( -1 );

  file_window = small_file_window;

  if( ReadGroupEntries() )
  {
    ERROR_MSG( "ReadGroupEntries failed*ABORT" );
    exit( 1 );
  }
  
  if( ReadPasswdEntries() )
  {
    ERROR_MSG( "ReadPasswdEntries failed*ABORT" );
    exit( 1 );
  }

  SetFileMode( MODE_3 );
  SetKindOfSort( SORT_BY_NAME );

  if( ( home = getenv("HOME") ) ) {
    sprintf(buffer, "%s%c%s", home, FILE_SEPARATOR_CHAR, PROFILE_FILENAME);
    ReadProfile(buffer);
    sprintf(buffer, "%s%c%s", home, FILE_SEPARATOR_CHAR, HISTORY_FILENAME);
    ReadHistory(buffer);
  }

  InitClock();

  return( 0 );
}


