# $Id: Base.pm,v 1.2.2.1 1999/10/04 13:11:00 kenji Exp $
package SimpleDB::Base;

sub new ($$$)
{
    my ($class, $filename, $readonly) = @_;
    my $self = {filename=>$filename, stored=>0, fetched=>0, readonly=>$readonly};
    bless $self, $class;
}

sub FETCH
{
    my $self = shift;
    unless ($self->{fetched}){
	$self->Read;
    }
    $self->{fetched} = 1;
}
sub STORE
{
    my $self = shift;
    if ($self->{readonly}){
	$self->Error("readonly");
    }
    $self->{stored} = 1;
}
sub DESTROY
{
    my $self = shift;
    if (!$self->{stored} || $self->{readonly}){
	return 1;
    } else {
	return 0;
    }
}
################################################################
sub Read($)
{
    my $self = shift;
}
sub Error($$)
{
    my ($self, $msg) = @_;
    print "Error: $msg";
    exit 1;
}
1;

