/*
//
// ver.c
//
// version and program information
//
// Copyright (c) 1995-96 Jim Nelson.  Permission to distribute
// granted by the author.  No warranties are made on the fitness of this
// source code.
//
*/

#include "htp.h"

/*
// program stage (alpha, beta, etc.)
*/
#if DEBUG
const char *VER_STAGE = "DEBUG RELEASE";
#else
const char *VER_STAGE = "RELEASE";
#endif

/*
// program name
*/
const char *PROGRAM_NAME = "htp";

/*
// program usage & syntax
*/

void DisplayHeader(void)
{
    printf("\n%s %d.%02d (%s) - HTML pre-processor (%s)\n", PROGRAM_NAME, VER_MAJOR,
        VER_MINOR, __DATE__, VER_STAGE);
    printf("Copyright (c) 1995-96 Jim Nelson - PUBLIC DOMAIN SOFTWARE\n");
    printf("[%s]\n\n", PROGRAM_OS);
}   

void usage(void)
{
    printf("email:\tjnelson@crl.com\n");
    printf("WWW:\thttp://www.crl.com/~jnelson/htp/\n\n");
    printf("usage: %s [options] <source HTML file> <reformatted HTML file>\n",
        PROGRAM_NAME);
    printf("       %s [options] @<response file>\n", PROGRAM_NAME);
    printf("       %s [options] @\n", PROGRAM_NAME);
    printf("\nSee accompanying readme.txt and on-line reference for full details.\n");
    printf("\nThis is public domain software.  No person or group is entitled to\n");
    printf("charge for the license or use of htp.\n");
}   

