##############################################################################
#
# Copyright (c) 1996-1998, Digital Creations, Fredericksburg, VA, USA.
# All rights reserved.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
# 
#   o Redistributions of source code must retain the above copyright
#     notice, this list of conditions, and the disclaimer that follows.
# 
#   o Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions, and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
# 
#   o All advertising materials mentioning features or use of this
#     software must display the following acknowledgement:
# 
#       This product includes software developed by Digital Creations
#       and its contributors.
# 
#   o Neither the name of Digital Creations nor the names of its
#     contributors may be used to endorse or promote products derived
#     from this software without specific prior written permission.
# 
# 
# THIS SOFTWARE IS PROVIDED BY DIGITAL CREATIONS AND CONTRIBUTORS *AS IS*
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
# TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
# PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL DIGITAL
# CREATIONS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
# OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
# TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
# USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
# DAMAGE.
#
# 
# If you have questions regarding this software, contact:
#
#   Digital Creations, L.C.
#   910 Princess Ann Street
#   Fredericksburge, Virginia  22401
#
#   info@digicool.com
#
#   (540) 371-6909
#
##############################################################################

import regex
from regex import *

try: 
    import thread, Sync
    allocate_lock=thread.allocate_lock

    class compile:

        _r=None

        def __init__(self, *args):
            self._r=r=apply(regex.compile,args)
            self.search=r.search
            self.match=r.match
            
        def search_group(self, str, group, pos=0):
            """Search a string for a pattern.

            If the pattern was not found, then None is returned,
            otherwise, the location where the pattern was found,
            as well as any specified group are returned.
            """
            r=self._r
            l=r.search(str, pos)
            if l < 0: return None
            return l, apply(r.group, group)

        def match_group(self, str, group, pos=0):
            """Match a pattern against a string

            If the string does not match the pattern, then None is
            returned, otherwise, the length of the match, as well
            as any specified group are returned.
            """
            r=self._r
            l=r.match(str, pos)
            if l < 0: return None
            return l, apply(r.group, group)

        def search_regs(self, str, pos=0):
            """Search a string for a pattern.

            If the pattern was not found, then None is returned,
            otherwise, the 'regs' attribute of the expression is
            returned.
            """
            r=self._r
            r.search(str, pos)
            return r.regs

        def match_regs(self, str, pos=0):
            """Match a pattern against a string

            If the string does not match the pattern, then None is
            returned, otherwise, the 'regs' attribute of the expression is
            returned.
            """
            r=self._r
            r.match(str, pos)
            return r.regs

        def __getattr__(self, name): return getattr(self._r, name)

    class symcomp(compile):

        def __init__(self, *args):
            self._r=r=apply(regex.symcomp,args)
            self.search=r.search
            self.match=r.match

    class SafeFunction:
        _l=allocate_lock()
        _a=_l.acquire
        _r=_l.release

        def __init__(self, f):
            self._f=f

        def __call__(self, *args, **kw):
            self._a()
            try:
                f=self._f
                if type(f) is type(''):
                    import regsub
                    f=self._f=getattr(regsub,f)
                return apply(f, args, kw)
            finally: self._r()

except:

    class allocate_lock:
        def acquire(*args): pass
        def release(*args): pass

    class SafeFunction:

        def __init__(self, f):
            self._f=f

        def __call__(self, *args, **kw):
            f=self._f
            if type(f) is type(''):
                import regsub
                f=self._f=getattr(regsub,f)
            return apply(f, args, kw)

split=SafeFunction('split')
sub=SafeFunction('sub')
gsub=SafeFunction('gsub')
splitx=SafeFunction('splitx')
capwords=SafeFunction('capwords')
