##############################################################################
#
# Copyright (c) 1996-1998, Digital Creations, Fredericksburg, VA, USA.
# All rights reserved.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
# 
#   o Redistributions of source code must retain the above copyright
#     notice, this list of conditions, and the disclaimer that follows.
# 
#   o Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions, and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
# 
#   o Neither the name of Digital Creations nor the names of its
#     contributors may be used to endorse or promote products derived
#     from this software without specific prior written permission.
# 
# 
# THIS SOFTWARE IS PROVIDED BY DIGITAL CREATIONS AND CONTRIBUTORS *AS IS*
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
# TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
# PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL DIGITAL
# CREATIONS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
# OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
# TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
# USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
# DAMAGE.
#
# 
# If you have questions regarding this software, contact:
#
#   Digital Creations, L.C.
#   910 Princess Ann Street
#   Fredericksburge, Virginia  22401
#
#   info@digicool.com
#
#   (540) 371-6909
#
##############################################################################
__doc__='''Indexes for supporting LRTs

$Id: MetaIndex.py,v 1.3 1998/10/23 21:39:25 jim Exp $'''
__version__='$Revision: 1.3 $'[11:-2]

from SimpleDB import Index

class MetaIndex:
    """Provide a mapping from names and object ids to file positions.

    The names are typically transaction names.  This implementation is
    based on the Index class.  It uses a separate Index instance for
    each name encountered.
    """

    def __init__(self):
        self._data={}

    def __getitem__(self,key):
        oid,name=key
        return self._data[name][oid]

    def subindex(self,name,create=0):
        if create:
            data=self._data
            try: index=data[name]
            except KeyError: data[name]=index=Index()
            return index
        else: return self._data[name]

    def hassubindex(self,name): return self._data.has_key(name)
    def subindexes(self): return self._data.values()
    def removeSubindex(self,name): del self._data[name]

    def has_key(self,key):
        try: self[key]
        except: return 0
        return 1

    def __setitem__(self,key,v):
        oid,name=key
        data=self._data
        try: index=data[name]
        except KeyError: data[name]=index=Index()
        index[oid]=v

    def __delitem__(self,key):
        oid,name=key
        del self._data[name][oid]

    def __len__(self):
        data=self._data
        if not data: return 0
        return reduce(lambda x,y: x+y,
                      map(lambda index: len(index), data.values())
                      )

    def values(self):
        data=self._data
        if not data: return []
        return reduce(lambda x,y: x+y,
                      map(lambda index: index.values(), data.values())
                      )

    def items(self):
        r=[]
        for name,index in self._data.items():
            for oid, pos in index.items():
                r.append(((oid,oid),pos))
        return r

    def keys(self):
        r=[]
        for name, index in self._data.items():
            for oid in index.keys():
                r.append((oid,name))
        return r

    def max_key(self):
        r=[]
        for index in self._data.values():
            try: m=index.max_key()
            except:
                m=index.keys()
                m=m and max(m) or 0
            r.append(m)
        return r and max(r) or 0
