##############################################################################
#
# Copyright (c) 1996-1998, Digital Creations, Fredericksburg, VA, USA.
# All rights reserved.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
# 
#   o Redistributions of source code must retain the above copyright
#     notice, this list of conditions, and the disclaimer that follows.
# 
#   o Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions, and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
# 
#   o Neither the name of Digital Creations nor the names of its
#     contributors may be used to endorse or promote products derived
#     from this software without specific prior written permission.
# 
# 
# THIS SOFTWARE IS PROVIDED BY DIGITAL CREATIONS AND CONTRIBUTORS *AS IS*
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
# TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
# PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL DIGITAL
# CREATIONS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
# OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
# TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
# USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
# DAMAGE.
#
# 
# If you have questions regarding this software, contact:
#
#   Digital Creations, L.C.
#   910 Princess Ann Street
#   Fredericksburge, Virginia  22401
#
#   info@digicool.com
#
#   (540) 371-6909
#
##############################################################################
__doc__='''Provide storage framework for nested persistent objects

$Id: PickleJar.py,v 1.51 1998/10/23 21:42:10 jim Exp $'''
__version__='$Revision: 1.51 $'[11:-2]

from cPickle import Pickler, Unpickler
from cStringIO import StringIO
import struct,time,marshal,sys
from string import atoi
from types import TupleType
from sys import getrefcount

# For backward compatibility
from Persistence import Persistent

OIDError='error'
last_reload_error=''

try: from cPickleJar import PickleJar
except: from pPickleJar import PickleJar
try: from cPickleCache import PickleCache
except: from PickleCache import PickleCache

class HelperClass: pass

class PickleJar(PickleJar):
    name=None
    oid=0

    def __init__(self,db,cache_size=100,cache_age=1000):
        oid=db.max_key()
        if oid > self.oid: self.oid=oid
        self.db=db
        cache=self.cache=PickleCache(cache_size,cache_age)
        self.cache_size=cache_size
        self.cache_age=cache_age

    def full_sweep(self): self.cache.full_sweep()

    def persistent_load(self,oid,
                        d={'__builtins__':{}},
                        tt=type(()), st=type(''), ct=type(HelperClass),
                        modules=sys.modules, have_module=sys.modules.has_key,
                        silly_list=["__doc__"],
                        ):

        __traceback_info__=oid

        cache=self.cache

        if type(oid) is tt:
            # Quick instance reference.  We know all we need to know
            # to create the instance wo hitting the db, so go for it!
            oid, klass = oid
            if cache.has_key(oid): return cache[oid]

            if type(klass) is tt:
                m,c=klass
                try:
                    if have_module(m): m=modules[m]
                    else:
                        g=globals()
                        m=__import__(m,g,g,('__doc__',))
                    klass=getattr(m,c)
                except:
                    # By default, this will raise an error, which is OK.
                    return self.Broken(oid, klass)

            if type(klass) is ct:
                object=HelperClass()
                object.__class__=klass
                d=object.__dict__
                d['_p_oid']=oid
                d['_p_jar']=self
                d['_p_changed']=None
            else:
                object=klass.__basicnew__()
                object._p_oid=oid
                object._p_jar=self
                object._p_changed=None
            
            cache[oid]=object
            return object
                
        if type(oid) is st: oid=atoi(oid)

        if cache.has_key(oid): return cache[oid]
        object=cache[oid]=self.load(oid)
        return object
        
    def load(self,oid,
             tt=type(()), ct=type(HelperClass)):

        __traceback_info__=oid
        p=self.raw(oid)
        file=StringIO(p)
        unpickler=Unpickler(file)
        unpickler.persistent_load=self.persistent_load

        object = unpickler.load()
        init=1
        if type(object) is tt:
            klass, args = object
            if (args is None or
                not args and not hasattr(klass,'__getinitargs__')):
                if type(klass) is ct:
                    object=HelperClass()
                    object.__class__=klass
                else: object=klass.__basicnew__()
                init=0
            else: object=apply(klass,args)
        else: klass=object.__class__

        if init:
            try: object._p___init__(oid,self)
            except: pass
        else:
            if type(klass) is ct:
                d=object.__dict__
                d['_p_oid']=oid
                d['_p_jar']=self
                d['_p_changed']=None
            else:
                object._p_oid=oid
                object._p_jar=self
                object._p_changed=None
        
        return object

    def raw(self,oid):
        # Get my pickle.  This method will be overidden by subclasses
        # that have more complex simpledb interfaces.
        return self.db[oid]

    def reload(self,object):
        if not hasattr(object.__class__, '__getinitargs__'):
            object._p_deactivate()
        else:
            copy=self.load(object._p_oid)
            object._p_deactivate(copy)

        object._p_changed=None

    def reload_oids(self,oids):
        cache=self.cache
        cached=cache.has_key
        reload=self.reload
        for oid in oids:
            if cached(oid): 
                o=cache[oid]
                try:
                    reload(o)
                except:
                    global last_reload_error
                    try:
                        last_reload_error=(
                            """
                            oid: %s (%s)
                            Error: %s
                            Type: %s
                            """ % (oid, o.__class__,
                                   sys.exc_type, sys.exc_value)
                            )
                    except: last_reload_error=oid
                                   
    def setstate(self,object):
        oid=object._p_oid
        file=StringIO(self.raw(oid))
        unpickler=Unpickler(file)
        unpickler.persistent_load=self.persistent_load
        unpickler.load()
        if hasattr(object, '_p_newstate'):
            d=object.__dict__
            newstate=d['_p_newstate']
            del d['_p_newstate']
            for key,v in newstate.items(): d[key]=v
        state = unpickler.load()
        object._p_changed=0
        if hasattr(object, '__setstate__'):
            object._p_changed=1
            object.__setstate__(state)
            object._p_changed=0
        else:
            d=object.__dict__
            for k,v in state.items(): d[k]=v

    def has_key(self,oid): return self.db.has_key(oid)

    def __getitem__(self, oid):
        cache=self.cache
        if cache.has_key(oid): return cache[oid]
        object=cache[oid]=self.load(oid)
        return object

    def __len__(self): return len(self.db)

    def abort(self,object,start_time,T=None):
        """Revert an object\'s state to the given time, start_time.
        """
        object._p_changed=0
        self.reload(object)

    oops=abort # Backward compat

    def refresh(self):
        cache=self.cache
        cache.full_sweep()
        for id,object in cache.items(): self.reload(object)

    def commit(self,oids,tindex,newpos):
        self.db.commit_info(tindex,newpos)
        self.reload_oids(oids)

    def mtime(self,object):
        return self.db.mtime(object._p_oid)

    def import_file(self, file):
        if type(file) is type(''): f=open(file,'rb')
        else: f=file
        oid=self.db.importoid(self.new_oid, f)
        if f is not file: f.close()
        return self[oid]

    def export_file(self, object, file=None):
        if file is None:
            # need code that uses new tempfile
            pass
        elif type(file) is type(''): f=open(file,'w+b')
        else: f=file
        self.db.exportoid(object._p_oid, f)
        if f is not file:
            if file is not None:
                f.close()

        return f
