/* 
 *      XSitecopy, for managing remote web sites with a GNOME interface.
 *      Copyright (C) 1999, Lee Mallabone <lee0@callnetuk.com
 *                                                                        
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *     
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *     
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *  
 */
#include "sites.h"
#include "changes.h"
#include "misc.h"
#include <stdio.h>
#include "config.h"
#include <malloc.h>

extern struct site_t *selected_site;
extern bool rcfile_saved;
extern struct site_info *area_contents_s;

void change_host_name (GtkWidget *entry, gpointer data) {
   gchar *hostname;
   
   hostname = gtk_entry_get_text (GTK_ENTRY (entry));

   selected_site->server = (char *) realloc (selected_site->server, 
					     strlen(hostname) + 1);
   strcpy (selected_site->server, hostname);
   rcfile_saved = false;
}

void change_protocol (GtkWidget *menu_item, gpointer proto) {
   gchar *protoc;
   extern struct proto_driver ftp_driver;
#ifdef USE_DAV
   extern struct proto_driver dav_driver;
#endif
   
   protoc = (gchar *) proto;
   if (strcmp (protoc, "ftp") == 0) {
      selected_site->protocol = siteproto_ftp;
      /* Change protocol to ftp */
      selected_site->driver = &ftp_driver;
#ifdef USE_DAV
		gtk_widget_set_sensitive(area_contents_s->http_expect_continue, FALSE);
		gtk_widget_set_sensitive(area_contents_s->limit_connections, FALSE);
		gtk_widget_set_sensitive(area_contents_s->ftp_mode, TRUE);
   } else if (strcmp (protoc, "dav") == 0) {
      selected_site->protocol = siteproto_http;
      /* DAV */
      selected_site->driver = &dav_driver;
		gtk_widget_set_sensitive(area_contents_s->http_expect_continue, TRUE);
		gtk_widget_set_sensitive(area_contents_s->limit_connections, TRUE);
		gtk_widget_set_sensitive(area_contents_s->ftp_mode, FALSE);
#endif
   }
   rcfile_saved = false;
}

void change_username (GtkWidget *entry, gpointer data) {
   gchar *username;
   
   username = gtk_entry_get_text (GTK_ENTRY (entry));
   selected_site->username = (char *) realloc (selected_site->username, 
					       strlen(username) + 1);   
   strcpy (selected_site->username, username);
   rcfile_saved = false;
}

void change_password (GtkWidget *entry, gpointer data) {
   gchar *password;
   
   password = gtk_entry_get_text (GTK_ENTRY (entry));
   selected_site->password = (char *) realloc (selected_site->password, 
					       strlen(password) + 1);   
   strcpy (selected_site->password, password);
   rcfile_saved = false;
}

void change_passive_ftp (GtkWidget *toggle, gpointer data) {
   if (GTK_TOGGLE_BUTTON (toggle)->active) {
      selected_site->ftp_pasv_mode = true;
   } else {
      selected_site->ftp_pasv_mode = false;
   }
   rcfile_saved = false;
}

void change_nooverwrite (GtkWidget *toggle, gpointer data) {
   if (GTK_TOGGLE_BUTTON (toggle)->active) {
      selected_site->nooverwrite = true;
   } else {
      selected_site->nooverwrite = false;
   }
   rcfile_saved = false;
}

void change_delete (GtkWidget *toggle, gpointer data) {
   if (GTK_TOGGLE_BUTTON (toggle)->active) {
      selected_site->nodelete = false;
   } else {
      selected_site->nodelete = true;
   }
   rcfile_saved = false;
}

void change_move_status (GtkWidget *toggle, gpointer data) {
   if (GTK_TOGGLE_BUTTON (toggle)->active) {
      selected_site->checkmoved = true;
   } else {
      selected_site->checkmoved = false;
   }
   rcfile_saved = false;
}

void change_http_expect (GtkWidget *toggle, gpointer data) {
   if (GTK_TOGGLE_BUTTON (toggle)->active) {
      selected_site->http_no_expect = TRUE;
   } else {
      selected_site->http_no_expect = FALSE;
   }
   rcfile_saved = false;
}

void change_http_limit (GtkWidget *toggle, gpointer data) {
   if (GTK_TOGGLE_BUTTON (toggle)->active) {
      selected_site->http_limit = TRUE;
   } else {
      selected_site->http_limit = FALSE;
   }
   rcfile_saved = false;
}

void change_perms (GtkWidget *menu_item, gpointer perm_data) {
   gchar *perm_set;
   
   perm_set = (gchar *) perm_data;
   if (strcmp (perm_set, "ignore") == 0) {
      selected_site->perms = sitep_ignore;
   } else if (strcmp (perm_set, "exec") == 0) {
      selected_site->perms = sitep_exec;
   } else if (strcmp (perm_set, "all") == 0) {
      selected_site->perms = sitep_all;
   }
   rcfile_saved = false;
}

void change_sym_mode (GtkWidget *menu_item, gpointer sym_data) {
   gchar *sym_info;

   sym_info = (gchar *) sym_data;
   if (strcmp (sym_info, "ignore") == 0) {
      selected_site->symlinks = sitesym_ignore;
   } else if (strcmp (sym_info, "follow") == 0) {
      selected_site->symlinks = sitesym_follow;
   } else if (strcmp (sym_info, "maintain") == 0) {
      selected_site->symlinks = sitesym_maintain;
   }
   rcfile_saved = false;
}

void change_local_dir (GtkWidget *entry, gpointer data) {
   gchar *local_dir;
   
   local_dir = gtk_entry_get_text (GTK_ENTRY (entry));
   selected_site->local_root_user = (char *) realloc (selected_site->local_root_user, 
						      strlen(local_dir) + 1);
   strcpy (selected_site->local_root_user, local_dir);
   verifysite_gnome(selected_site);
   /* Do a ton more stuff here to make sure that the tree nodes for files are
    * refreshed once the local dir has been changed. */
   rcfile_saved = false;
}

void change_remote_dir (GtkWidget *entry) {
   gchar *remote_dir;

   remote_dir = gtk_entry_get_text (GTK_ENTRY (entry));
   selected_site->remote_root_user = (char *) realloc (selected_site->remote_root_user, 
						       strlen(remote_dir) + 1);
   strcpy (selected_site->remote_root_user, remote_dir);

   if (*remote_dir == '~') {
     selected_site->remote_isrel = TRUE;
   } else {
     selected_site->remote_isrel = FALSE;
   }

   if (verifysite_gnome (selected_site) != 0) {
     DEBUG (DEBUG_GNOME, "site did not verify correctly.");
	  return;
	}

   if ( (*remote_dir != '~') && (*remote_dir != '/')) {
     fe_status ("Warning! The remote directory must begin with either a '/' or a '~/'.\n Use ~/ to denote a directory relative to your logon directory");
     /*     free (remote_dir);*/
     return;
   }
   /*   free (remote_dir);*/
   /* Do we want to do a site_fetch_list if this changes? */
   rcfile_saved = false;
}

void change_url (GtkWidget *entry, gpointer data) {
   gchar *url;
   
   url = gtk_entry_get_text (GTK_ENTRY (entry));
   selected_site->url = (char *) malloc (strlen(url) + 1);
   strcpy (selected_site->url, url);
   rcfile_saved = false;
}
