/* 
 *      XSitecopy, for managing remote web sites with a GNOME interface.
 *      Copyright (C) 1999, Lee Mallabone <lee0@callnetuk.com>
 *                                                                        
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *     
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *     
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <sys/stat.h>
#include <unistd.h>
#include "config.h"
#include "sites.h"
#include "file_widgets.h"

struct labelled_entry *viewer;


void view_file(GtkWidget *button, gpointer filename) {
   gchar *launcher;
   gchar command_line[BUFSIZ];
   
   launcher = gtk_entry_get_text (GTK_ENTRY (viewer->entry));
   sprintf (command_line, "%s %s", launcher, (gchar *) filename);
   system (command_line);
}

GtkWidget *create_label_and_entry (struct labelled_entry *the_data) {
   GtkWidget *hbox;
   hbox = gtk_hbox_new (FALSE, 2);
   the_data->label = gtk_label_new (the_data->label_text);
   the_data->entry = gtk_entry_new ();
   gtk_widget_show (the_data->entry);
   gtk_widget_show (the_data->label);
   
   if (the_data->entry_default != NULL)
     gtk_entry_set_text (GTK_ENTRY (the_data->entry), the_data->entry_default);
   gtk_editable_set_editable (GTK_EDITABLE (the_data->entry),
			      the_data->editable);
   gtk_box_pack_start (GTK_BOX (hbox), the_data->label, FALSE, FALSE, 2);
   gtk_box_pack_end (GTK_BOX (hbox), the_data->entry, TRUE, TRUE, 2);
   gtk_widget_show (hbox);
   return hbox;
}

GtkWidget *make_file_info_area (struct site_file_t *the_file) {
   struct stat *file_data = NULL;
   const gchar *mime_info;
   gchar tmp[BUFSIZ];
   struct labelled_entry *relative_name;
   struct labelled_entry *mime_type;
   struct labelled_entry *last_modified;
   struct labelled_entry *last_changed;
   struct labelled_entry *last_accessed;
   struct labelled_entry *byte_size;
   struct labelled_entry *user_id;
   struct labelled_entry *group_id;
   struct labelled_entry *protection;
   
   GtkWidget *vbox, *frame, *button, *label;
   
   frame = gtk_frame_new (the_file->full_local);
   gtk_widget_show (frame);
   vbox = gtk_vbox_new (FALSE, 9);
   gtk_container_set_border_width (GTK_CONTAINER (vbox), 35);
   gtk_widget_show (vbox);
   
   file_data = (struct stat *) malloc (sizeof (struct stat));
   if (stat ((const char *) the_file->full_local, file_data) == -1) {
      label = gtk_label_new ("Could not retrieve file information");
      gtk_widget_show (label);
      gtk_container_add (GTK_CONTAINER (vbox), label);
      gtk_container_add (GTK_CONTAINER (frame), vbox);
      return frame;
   }
#define SPACE 2
   relative_name = malloc (sizeof (struct labelled_entry));
   relative_name->label_text = "Local filename:";
   relative_name->entry_default = the_file->rel_local;
   relative_name->editable = FALSE;
   gtk_box_pack_start (GTK_BOX (vbox), create_label_and_entry(relative_name), FALSE, FALSE, SPACE);

   mime_info = gnome_mime_type ( (const gchar *) the_file->full_local);
   
   mime_type = malloc (sizeof (struct labelled_entry));
   mime_type->label_text = "Mime type:";
   mime_type->entry_default = (char *) mime_info;
   mime_type->editable = FALSE;
   gtk_box_pack_start (GTK_BOX (vbox), create_label_and_entry(mime_type), FALSE, FALSE, SPACE);

   last_modified = malloc (sizeof (struct labelled_entry));
   last_modified->label_text = "Last modified:";
   last_modified->entry_default = ctime (&(the_file->localtime));
   last_modified->editable = FALSE;
   gtk_box_pack_start (GTK_BOX (vbox), create_label_and_entry(last_modified), FALSE, FALSE, SPACE);

   last_changed = malloc (sizeof (struct labelled_entry));
   last_changed->label_text = "Last changed:";
   last_changed->entry_default = ctime (&(file_data->st_ctime));
   last_changed->editable = FALSE;
   gtk_box_pack_start (GTK_BOX (vbox), create_label_and_entry(last_changed), FALSE, FALSE, SPACE);

   last_accessed = malloc (sizeof (struct labelled_entry));
   last_accessed->label_text = "Last accessed:";
   last_accessed->entry_default = ctime (&(file_data->st_atime));
   last_accessed->editable = FALSE;
   gtk_box_pack_start (GTK_BOX (vbox), create_label_and_entry(last_accessed), FALSE, FALSE, SPACE);

   byte_size = malloc (sizeof (struct labelled_entry));
   byte_size->label_text = "Size (bytes):";
   sprintf (tmp, "%d", file_data->st_size);
   byte_size->entry_default = tmp;
   byte_size->editable = FALSE;
   gtk_box_pack_start (GTK_BOX (vbox), create_label_and_entry(byte_size), FALSE, FALSE, SPACE);

   user_id = malloc (sizeof (struct labelled_entry));
   user_id->label_text = "User ID:";
   sprintf (tmp, "%d", file_data->st_uid);
   user_id->entry_default = tmp; // (char *) file_data->st_uid;
   user_id->editable = FALSE;
   gtk_box_pack_start (GTK_BOX (vbox), create_label_and_entry(user_id), FALSE, FALSE, SPACE);

   group_id = malloc (sizeof (struct labelled_entry));
   group_id->label_text = "Group ID:";
   sprintf (tmp, "%d", file_data->st_gid);
   group_id->entry_default = tmp;
   group_id->editable = FALSE;
   gtk_box_pack_start (GTK_BOX (vbox), create_label_and_entry(group_id), FALSE, FALSE, SPACE);

   protection = malloc (sizeof (struct labelled_entry));
   protection->label_text = "Protection:";
   sprintf (tmp, "%d", file_data->st_mode);
   protection->entry_default = tmp;
   protection->editable = FALSE;
   gtk_box_pack_start (GTK_BOX (vbox), create_label_and_entry(protection), FALSE, FALSE, SPACE);

   viewer = malloc (sizeof (struct labelled_entry));
   viewer->label_text = "Viewer:";
   viewer->entry_default = (char *) gnome_mime_program (mime_info);
   viewer->editable = TRUE;
   gtk_box_pack_start (GTK_BOX (vbox), create_label_and_entry(viewer), FALSE, FALSE, SPACE);

   button = gtk_button_new_with_label ("View!");
   gtk_widget_set_sensitive (button, FALSE);
   //gtk_signal_connect (GTK_OBJECT (button), "clicked",
//		       GTK_SIGNAL_FUNC (view_file), (gpointer) the_file->full_local);
   gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, SPACE);
   gtk_widget_show (button);
	    
   gtk_container_add (GTK_CONTAINER (frame), vbox);
   return frame;
}

