
#ifndef COMMON_H
#define COMMON_H

#include <config.h>

#include <sys/types.h>

#include <stdio.h>

#define DEBUG_SOCKET 1
#define DEBUG_FILES 2
#define DEBUG_RCFILE 4
#define DEBUG_HTTP 8
#define DEBUG_FTP 16
#define DEBUG_XML 32
#define DEBUG_GNOME 64
#define DEBUG_HTTPAUTH 128
#define DEBUG_HTTPPLAIN 256
#define DEBUG_SITES 512

/* This way doesn't rely on DEBUG(a,b...) which confused old compilers
 * and decent compilers can optimize out the if(0) paths.
 */

#ifdef DEBUGGING
extern int debug_mask;
#define DEBUG debug
#else
#define DEBUG if(0) debug
#endif

void debug( int ch, char *, ... );

/* A signal hander */
typedef void (*sig_handler)( int );

#define min(a,b) ((a)<(b)?(a):(b))

#ifdef __EMX__
/* siebert: strcasecmp is stricmp */
#define strcasecmp stricmp
#define strncasecmp strnicmp
#endif

/* boolean */
typedef int bool;
#define true 1
#define false 0

#if !defined( HAVE_STRDUP ) || !defined( strdup )
char *strdup( const char *s );
#endif

#if !HAVE_STRERROR && !defined(strerror)
char *strerror (int errnum);
#endif

void md5_hexify( unsigned char md5_buf[16], char *buffer );

#endif
