// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1997
//  wer auch immer ...
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        tiorpcwriter.h
// 
// Purpose:     
// 
// Created:     11 Jul 1997   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// $Id: tiorpcwriter.h,v 1.1 1997/02/20 19:32:25 jfasch Exp $
// 
// $Log: tiorpcwriter.h,v $
// Revision 1.1  1997/02/20 19:32:25  jfasch
// Initial revision
//
// 
// </file> 
#ifndef hg_dispatch_tiorpcwriter_h
#define hg_dispatch_tiorpcwriter_h

#include "libdispatch.h"

#include <hyperg/utils/types.h>

class RString ;
class TIOrpcstream;
class TransparentIOPtr ;

class TIORpcWriter {
public:
    ~TIORpcWriter();

    TIOrpcstream& server();
protected:
    TIORpcWriter (const RString& host, int port, boolean fatal, boolean binary);
    TIORpcWriter (const TransparentIOPtr&, boolean fatal, boolean binary);
    TIORpcWriter (TIOrpcstream* server);

    TIOrpcstream* _server;		// sink of RPC requests going to server
    boolean _delete;		// should the destructor delete _server?
private:
   // deny access since unimplemented and member-wise won't work
   TIORpcWriter(const TIORpcWriter&) {};
   TIORpcWriter& operator=(const TIORpcWriter&) { return *this; }
};

// Give this function public access so that programs can test this
// connection's state or attach a RpcReader to it to read as well
// as send RPC requests over the same connection.

inline TIOrpcstream& TIORpcWriter::server() {
    return *_server;
}

#endif
