// -*- C++ -*-

//<copyright>
//
// Copyright (c) 1995
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
//</copyright>

//<file>
//
// Name: helpwindowaction.h
//
// Purpose: 
//
// Created: 7.9.95     Juergen Schipflinger
//
// $Id: helpwindowaction.h,v 1.4 1996/02/13 16:38:40 bmarsch Exp $
//
// Description:
//
//</file>
//
// $Log: helpwindowaction.h,v $
// Revision 1.4  1996/02/13 16:38:40  bmarsch
// Changed virtual inline functions (made problems on IBM)
//
// Revision 1.3  1996/02/06 13:13:50  bmarsch
// Return nil pointer as default in all execute functions
//


#ifndef __helpwindowaction_h__
#define __helpwindowaction_h__

#include <InterViews/enter-scope.h>
#include <InterViews/action.h>
#include <InterViews/resource.h>
class Window;

class HelpWindowActionAction : public Resource {
public:
  virtual Window* execute(int) { return nil; }
};

class HelpWindowAction : public Resource {
public:
  HelpWindowAction(HelpWindowActionAction* action, int);
  virtual ~HelpWindowAction()
  { Resource::unref(action_); }

  virtual Window* execute()
  { return action_ ? action_->execute(parameter_) : nil; };

private:
  int parameter_;
  HelpWindowActionAction* action_;
};

inline HelpWindowAction::HelpWindowAction(HelpWindowActionAction* action, int par)
{
  parameter_ = par;
  action_ = action;
  Resource::ref(action_);
}


#if defined(__STDC__) || defined(__ANSI_CPP__)
#define __HelpWindowActionCallback(T) T##_HelpWindowActionCallback
#define HelpWindowActionCallback(T) __HelpWindowActionCallback(T)
#define __HelpWindowActionMemberFunction(T) T##_HelpWindowActionMemberFunction
#define HelpWindowActionMemberFunction(T) __HelpWindowActionMemberFunction(T)
#else
#define __HelpWindowActionCallback(T) T/**/_HelpWindowActionCallback
#define HelpWindowActionCallback(T) __HelpWindowActionCallback(T)
#define __HelpWindowActionMemberFunction(T) T/**/_HelpWindowActionMemberFunction
#define HelpWindowActionMemberFunction(T) __HelpWindowActionMemberFunction(T)
#endif

#define declareHelpWindowActionCallback(T) \
typedef Window* (T::*HelpWindowActionMemberFunction(T))(int); \
class HelpWindowActionCallback(T):public HelpWindowActionAction{ \
public: \
    HelpWindowActionCallback(T)(T*, HelpWindowActionMemberFunction(T)); \
\
    virtual Window* execute(int); \
private: \
    T* obj_; \
    HelpWindowActionMemberFunction(T) func_; \
};

#define implementHelpWindowActionCallback(T) \
HelpWindowActionCallback(T)::HelpWindowActionCallback(T)(T* obj, HelpWindowActionMemberFunction(T) func) { \
    obj_ = obj; \
    func_ = func; \
} \
\
Window* HelpWindowActionCallback(T)::execute(int parameter) { return (obj_->*func_)(parameter); }

#endif
