//<copyright>
//
// Copyright (c) 1994
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
//</copyright>

//<file>
//
// Name:       adjvalue.C
//
// Purpose:    Implementation of class AdjValue
//
// Created:     6 Apr 93    Michael Pichler
//
// Modified:   18 May 94    Michael Pichler
//
// $Id: adjvalue.C,v 1.2 1996/09/12 11:42:10 bmarsch Exp $
//
//</file>


#include "adjvalue.h"
#include <iostream.h>


AdjValue::AdjValue (float lower, float upper, float initial, float small, float large)
{
  // currently scrollbars only work for lower <= upper (consequence of constrain ())
  lower_ = lower;
  upper_ = upper;
  curvalue_ = initial;

  smallScroll (small);
  largeScroll (large);
}

AdjValue::~AdjValue()
{}

#define access_function( name, value ) \
Coord AdjValue::name (DimensionName) const \
{ return value; \
}

access_function (lower, lower_)
access_function (upper, upper_)
access_function (length, upper_ - lower_)
access_function (cur_lower, curvalue_)
access_function (cur_upper, curvalue_)
access_function (cur_length, 0.0)

void AdjValue::setLower(float l)
{
  lower_ = l;
  // constrain
  if (curvalue_ < l)
    curvalue_ = l;

  notify_all();
}

void AdjValue::setUpper(float u)
{
  upper_ = u;
  // constrain
  if (curvalue_ > u)
    curvalue_ = u;

  notify_all();
}

void AdjValue::scroll_to (DimensionName, Coord value)
{
  // when using constrain (d, val), Coord value must be copied to a local variable first
  // passing a float function argument as a float reference does not always work!
  if (value < lower_)
    value = lower_;
  else if (value > upper_)
    value = upper_;

  if (value != curvalue_)
  {
    curvalue_ = value;
    notify_all ();
  }
}
