
#ifndef _MISC_
#define _MISC_

#include <ctype.h>
#include <sys/types.h>
#include "aftersteplib.h"
#include "menus.h"
#ifdef NEWLOOK
#include "mystyle.h"
#endif

#ifndef max
#define max(x,y)  ((x>=y)?x:y)
#endif

#ifndef min
#define min(x,y)  ((x<=y)?x:y)
#endif

#define SORTBYALPHA 1
#define SORTBYDATE  2

/* values for name_list flags */
#define STICKY_FLAG           1
#define STAYSONTOP_FLAG       2
#define NOBORDER_FLAG         4
#define NOTITLE_FLAG          8
#define ICON_FLAG            32
#define CIRCULATESKIP_FLAG   64
#define LISTSKIP_FLAG       128
#define STAYSONDESK_FLAG    256
#define SUPPRESSICON_FLAG   512
#define BW_FLAG            1024
#define NOBW_FLAG          2048
#define START_ICONIC_FLAG  4096
#define FORE_COLOR_FLAG    8192
#define BACK_COLOR_FLAG   16384
#define NOICON_TITLE_FLAG 32768
#define NOFOCUS_FLAG      65536
#define STAYSONBACK_FLAG 131072
#define VIEWPORTX_FLAG   262144
#define VIEWPORTY_FLAG   524288

/************************************************************************
 * ReapChildren - wait() for all dead child processes
 ************************************************************************/

#include <sys/wait.h>

#ifdef HAVE_SYS_WAIT_H
#define ReapChildren()  while ((waitpid(-1, NULL, WNOHANG)) > 0);
#elif defined (HAVE_WAIT3)
#define ReapChildren()  while ((wait3(NULL, WNOHANG, NULL)) > 0);
#endif

typedef struct name_list_struct
  {
    struct name_list_struct *next;	/* pointer to the next name */
    struct name_list_struct *prev;	/* fsf add */
    char *name;			/* the name of the window */
    char *value;		/* icon name */
    int Desk;			/* Desktop number */
    int ViewportX, ViewportY ;
    unsigned long on_flags;
    unsigned long off_flags;
    int border_width;
    int resize_width;
    char *ForeColor;
    char *BackColor;

    unsigned long on_buttons;
    unsigned long off_buttons;

  }
name_list;

/* used for parsing configuration */
struct config
  {
    char *keyword;
#ifdef __STDC__
    void (*action) (char *, FILE *, char **, int *);
#else
    void (*action) ();
#endif
    char **arg;
    int *arg2;
  };

/* some fancy font handling stuff */
#define NewFontAndColor(newfont,color,backcolor) {\
   Globalgcv.font = newfont;\
   Globalgcv.foreground = color;\
   Globalgcv.background = backcolor;\
   Globalgcm = GCFont | GCForeground | GCBackground; \
   XChangeGC(dpy,Scr.FontGC,Globalgcm,&Globalgcv); \
}

#ifdef I18N
#ifdef __STDC__
#define XTextWidth(x,y,z)      XmbTextEscapement(x ## set,y,z)
#else
#define XTextWidth(x,y,z)      XmbTextEscapement(x/**/set,y,z)
#endif
#define XDrawString(t,u,v,w,x,y,z) XmbDrawString(t,u,FONTSET,v,w,x,y,z)
#define XDrawImageString(t,u,v,w,x,y,z) XmbDrawImageString(t,u,FONTSET,v,w,x,y,z)
#endif

#ifdef NO_ICONS
#define ICON_HEIGHT 1
#else

#ifdef NO_ICON_BACKGROUND
#define ICON_HEIGHT (IconFont->height+6)
#else
#define ICON_HEIGHT 64
#endif

#endif

extern XGCValues Globalgcv;
extern unsigned long Globalgcm;
extern MyFont *IconFont;
extern Time lastTimestamp;
extern XEvent Event;
extern char NoName[];

/* some usefull string parsing functions 
 *( returns next position in string after parsed value ) */
extern char* ReadIntValue( char* restofline, int* value ); 
extern char* ReadColorValue(char* restofline, char** color, int* len  );
extern char* ReadFileName( char* restofline, char** fname, int* len );

extern unsigned long LookInList (name_list *, char *, XClassHint *, char **,
		    int *, int *, int *, char **, char **, unsigned long *,
		    int *, int *);
extern void MoveOutline (Window, int, int, int, int);
extern void DoResize (int, int, ASWindow *, Bool);
extern void DisplaySize (ASWindow *, int, int, Bool);
extern void DisplayPosition (ASWindow *, int, int, Bool);
extern void SetupFrame (ASWindow *, int, int, int, int, Bool);
extern void CreateGCs (void);
extern void InstallWindowColormaps (ASWindow *);
extern void InstallRootColormap (void);
extern void UninstallRootColormap (void);
extern void FetchWmProtocols (ASWindow *);
extern void FetchWmColormapWindows (ASWindow *);
extern void PaintEntry (MenuRoot *, MenuItem *);
extern void PaintMenu (MenuRoot *, XEvent *);
extern void InitBase(Bool);
extern void InitLook(Bool);
extern void InitFeel(Bool);
extern void InitDatabase(Bool);
extern void MakeMenus (const char *, int, Bool, Bool, Bool);
extern void InitEvents (void);
extern void HandleEvents (void);
extern void HandleFocusIn (void);
extern void HandleFocusOut (void);
extern void HandleDestroyNotify (void);
extern void HandleMapRequest (void);
extern void HandleMapNotify (void);
extern void HandleUnmapNotify (void);
extern void HandleButtonPress (void);
extern void HandleEnterNotify (void);
extern void HandleLeaveNotify (void);
extern void HandleConfigureRequest (void);
extern void HandleClientMessage (void);
extern void HandlePropertyNotify (void);
extern void HandleKeyPress (void);
extern void HandleVisibilityNotify (void);
extern void HandleColormapNotify (void);
extern void SetTitleBar (ASWindow *, Bool, Bool);
extern void RestoreWithdrawnLocation (ASWindow *, Bool);
extern void Destroy (ASWindow *, Bool);
extern void GetGravityOffsets (ASWindow *, int *, int *);
extern void MoveViewport (int, int, Bool);
extern void init_titlebar_windows(ASWindow *, Bool);
extern Bool create_titlebar_windows(ASWindow *);
extern void init_titlebutton_windows(ASWindow *, Bool);
extern Bool create_titlebutton_windows(ASWindow *);
extern ASWindow *AddWindow (Window);
extern int MappedNotOverride (Window);
extern void GrabButtons (ASWindow *);
extern void GrabKeys (ASWindow *);
extern void GetWindowSizeHints (ASWindow *);
extern void ReallyRedrawPager (void);
extern void SwitchPages (Bool, Bool);
extern void NextPage (void);
extern void PrevPage (void);
extern void moveLoop (ASWindow *, int, int, int, int, int *, int *, Bool, Bool);

extern void Keyboard_shortcuts (XEvent *, int, int);
extern void RedoIconName (ASWindow *);
extern void DrawIconWindow (ASWindow *);
extern void CreateIconWindow (ASWindow *, int, int);
extern void GetIcon (ASWindow *);
extern void SearchIcon (ASWindow *, char **);

extern AFTER_INLINE void RelieveWindow (ASWindow *, Window, int, int, int, int,
					GC, GC, int);

void RelieveParts (ASWindow *, int, GC, GC);
#define NO_HILITE     0x0000
#define TOP_HILITE    0x0001
#define RIGHT_HILITE  0x0002
#define BOTTOM_HILITE 0x0004
#define LEFT_HILITE   0x0008
#define FULL_HILITE   0x000F

extern void sleep_a_little (int);
extern void PagerMoveWindow (void);
extern void Stick (ASWindow *);
extern void Maximize (ASWindow *, int, int, int, int);
extern void Shade (ASWindow *);
extern void ResetShade (ASWindow *);
extern void RaiseWindow (ASWindow *);
extern void LowerWindow (ASWindow *);
extern Bool GrabEm (int);
extern void UngrabEm (void);
extern MenuRoot *NewMenuRoot (char *);
extern void DeleteMenuRoot (MenuRoot * menu);
extern void AddToMenu (MenuRoot *, char *, char *, char *, int,
		       long, long, char, char);
extern void MakeMenu (MenuRoot *);
extern void CaptureAllWindows (void);
extern void SetTimer (int);
extern int flush_expose (Window);
extern void ExecuteFunction (int, char *, Window, ASWindow *, XEvent *,
			     unsigned long, long, long, int, int,
			     MenuRoot *, int);
extern void do_windowList (int, int);
extern MenuRoot *update_windowList(void);
extern void RaiseThisWindow (int);
extern int GetContext (ASWindow *, XEvent *, Window *);
extern void HandlePaging (int, int, int *, int *, int *, int *, Bool);
extern void SetShape (ASWindow *, int);
extern void AutoPlaceStickyIcons(void);
extern void AutoPlace (ASWindow *);
extern void afterstep_err (const char *, const char *, const char *, const char *);
extern void executeModule (char *, FILE *, char **, int *);
extern Bool SetFocus (Window, ASWindow *, Bool);
extern void CheckAndSetFocus (void);
extern void initModules (void);
extern int HandleModuleInput (Window, int);
extern void nofont (char *name);
extern char *stripcpy (char *);
extern char *stripcpy2 (char *, int, Bool);
extern char *stripcpy3 (char *, Bool);
extern void match_string (struct config *, char *, char *, FILE *);
extern struct config *match_string2 (struct config *, char *);
extern void no_popup (char *);
extern void KillModule (int, int);
extern void KillModuleByName (char *);
extern void ClosePipes (void);
extern char *findIconFile (char *, char *, int);

/* this is afterstep specific stuff - we don't want this in modules */ 
#ifndef IN_MODULE  

extern void GetBitmapFile (ASWindow *);
extern void ConstrainSize (ASWindow *, int *, int *);
extern void DispatchEvent (void);
extern void HandleExpose (void);

#endif

/*extern void GetXPMFile (ASWindow *);*/
extern void init_old_look_variables (Bool);
extern int ParseColor (const char *, int [3], int [3]);
#ifdef NEWLOOK
extern void merge_old_look_colors (MyStyle *, int, int, char *, char *, char *, char *);
extern void merge_old_look_variables (void);
extern void draw_styled_text (Window, MyStyle *, char *, int , int);
#endif
extern void GetIconWindow (ASWindow *);
extern void GetIconBitmap (ASWindow *);
extern void SmartPlacement (ASWindow *, int, int, int *, int *);
extern void usage (void);
extern Bool unmap_menu (MenuRoot * menu);

void Broadcast (unsigned long, unsigned long,
		unsigned long, unsigned long,
		unsigned long, unsigned long,
		unsigned long, unsigned long,
		unsigned long);
void BroadcastConfig (unsigned long, ASWindow *);
void SendPacket (int, unsigned long, unsigned long,
		 unsigned long, unsigned long, unsigned long, unsigned long,
		 unsigned long, unsigned long, unsigned long);
void SendConfig (int, unsigned long, ASWindow *);
void BroadcastName (unsigned long, unsigned long, unsigned long, unsigned long,
		    char *);
void SendName (int, unsigned long, unsigned long, unsigned long, unsigned long,
	       char *);
void DeadPipe (int);
void GetMwmHints (ASWindow *);
void SelectDecor (ASWindow *, unsigned long, int, int);
extern Bool PopUpMenu (MenuRoot *, int, int);
void ComplexFunction (Window, ASWindow *, XEvent *, unsigned long, MenuRoot *);
extern int DeferExecution (XEvent *, Window *, ASWindow **, unsigned long *, int, int);
void send_clientmessage (Window, Atom, Time);
void SetBorder (ASWindow *, Bool, Bool, Bool, Window);
void move_window (XEvent *, Window, ASWindow *, int, int, int, int, int);
void resize_window (Window, ASWindow *, int, int, int, int);
void CreateIconWindow (ASWindow *, int, int);
void send_clientmessage (Window, Atom, Time);
void SetMapStateProp (ASWindow *, int);
void SetStickyProp (ASWindow *, int, int, int);
void SetClientProp (ASWindow *);
void Iconify (ASWindow *, int, int);
void DeIconify (ASWindow *);
void PopDownMenu (MenuRoot *);
void KeepOnTop (void);
void show_panner (void);
void WaitForButtonsUp (void);
void FocusOn (ASWindow *, int, Bool, int);
Bool PlaceWindow (ASWindow *, unsigned long, int);
void free_window_names (ASWindow *, Bool, Bool);

void do_menu (MenuRoot *, MenuRoot *);
int check_allowed_function (MenuItem *);
int check_allowed_function2 (int, ASWindow *);
void ReInstallActiveColormap (void);
void ParsePopupEntry (char *, FILE *, char **, int *);
void ParseMouseEntry (char *, FILE *, char **, int *);
void ParseKeyEntry (char *, FILE *, char **, int *);
void SetOneStyle (char *text, FILE *, char **, int *);
void AddToList (char *, char *, unsigned long, unsigned long, int, int, int,
		char *, char *, unsigned long, unsigned long, int, int);
void RemoveFromList (name_list *);

void ParseStyle (char *text, FILE *, char **, int *);
void assign_string (char *text, FILE * fd, char **arg, int *);
void assign_pixmap (char *text, FILE * fd, char **arg, int *);
void ButtonStyle ();
void IconStyle ();
void SetTitleButton (char *, FILE *, char **, int *);
void SetTitleText (char *, FILE *, char **, int *);
void SetFlag (char *, FILE *, char **, int *);
void SetTextureFlag (char *, FILE *, char **, int *);
void SetIconFlag (char *, FILE *, char **, int *);
void SetCursor (char *, FILE *, char **, int *);
void SetChangeCursor (char *, FILE *, char **, int *);
void SetInts (char *, FILE *, char **, int *);
void SetButtonList (char *, FILE *, char **, int *);
void SetBox (char *, FILE *, char **, int *);
void ReadPipeConfig (char *, FILE *, char **, int *);
void set_func (char *, FILE *, char **, int *);
void set_func_arg (char *, FILE *, char **, int *);
void set_style (char *, FILE *, char **, int *);
void copy_config (FILE **);
Pixel GetShadow (Pixel);
Pixel GetHilite (Pixel);
Bool GetIconXPM (char *, MyIcon *, int);
Bool GetIconJPG (char *, MyIcon *, int);
Bool GetIconFromFile (char *, MyIcon *, int);
Pixmap GetXPMTile (char *, int);

#define UP 1
#define DOWN 0
void ChangeWarpIndex(const long, const int);
ASWindow *GetNextWindow(const ASWindow *, const int);
extern ASWindow *Circulate (ASWindow *, char *, Bool);
void PasteSelection (void);
void changeDesks (int, int);
void changeWindowsDesk (ASWindow *, int);
void MapIt (ASWindow *);
void UnmapIt (ASWindow *);
void do_save (void);
void checkPanFrames (void);
void raisePanFrames (void);
void initPanFrames (void);
Bool StashEventTime (XEvent *);
int matchWildcards (char *, char *);
int My_XNextEvent (Display *, XEvent *);
void SetCirculateSequence ();
void MyXGrabButton (Display *, unsigned, unsigned, Window, Bool, unsigned,
		    int, int, Window, Cursor);
void MyXUngrabButton (Display *, unsigned, unsigned, Window);
void MyXGrabKey (Display *, int, unsigned, Window, Bool, int, int);
void GrabRaiseClick (ASWindow *);
void UngrabRaiseClick (ASWindow *);
void UpdateVisibility (void);
void CorrectStackOrder (void);
void FlushQueue (int module);
void QuickRestart (char *);
void AddFuncKey (char *, int, int, int, char *, int, int, MenuRoot *,
		 char, char);

void InteractiveMove (Window *, ASWindow *, int *, int *, XEvent *);

#ifdef BROKEN_SUN_HEADERS
#include "sun_headers.h"
#endif

#if defined(__alpha)
#include "alpha_header.h"
#endif /* NEEDS_ALPHA_HEADER */

#endif /* _MISC_ */
