/***********************************************************************
 *
 * afterstep style include file
 *
 ***********************************************************************/

#ifndef _MYSTYLE_
#define _MYSTYLE_

/*
 * see comment to style_config in mystyle.c before changing this structure
 *
 * text_type 0: normal text
 * text_type 1: 3d effect #1
 * text_type 2: 3d effect #2
 */

typedef struct MyStyle
  {
    struct MyStyle *next;
    int set_flags;		/* == (user_flags | inherit_flags) */
    int user_flags;		/* options the user set */
    int inherit_flags;		/* inherited options */

    char *name;
    int text_style;
    MyFont font;
    ColorPair colors;
    ColorPair relief;
    int texture_type;
#ifndef NO_TEXTURE
    int max_colors;
    Pixmap pixmap;
    gradient_t gradient;
#endif
  }
MyStyle;

/* 
 * values < 16 are sequential control codes
 * values >= 16 are bit flags
 */
#define F_ERROR			0	/* error condition */
#define F_DONE			1	/* done parsing body */
#define F_INHERIT		2	/* inherit from another style */
#define F_FONT			(1 <<  4)
#define F_FORECOLOR		(1 <<  5)
#define F_BACKCOLOR		(1 <<  6)
#define F_MAXCOLORS		(1 <<  7)
#define F_BACKGRADIENT		(1 <<  8)
#define F_BACKPIXMAP		(1 <<  9)
#define F_TEXTSTYLE		(1 << 10)

/* these functions change the global style */
void change_style (MyStyle * style);
void change_styled_gc (MyStyle * style, GC foreGC, GC backGC, GC reliefGC, GC shadowGC);
void draw_styled_text (Window w, MyStyle * style, char *text, int x, int y);

void make_styles (void);
void fix_styles (void);
Pixmap make_styled_pixmap (MyStyle * style, int width, int height, Pixmap cache);
void change_styled_background (Window w, MyStyle * style);
MyStyle *new_style (void);
MyStyle *new_style_with_name (char *name);
void delete_style (MyStyle * style);
void merge_styles (MyStyle * parent, MyStyle * child, Bool override, Bool copy);
MyStyle *find_style (char *name);

void ParseMyStyle (char *tline, FILE * fd, char **junk, int *junk2);
void set_style (char *text, FILE * fd, char **style, int *junk2);
void set_func_arg (char *text, FILE * fd, char **value, int *junk);

extern struct config style_config[];

#endif /* _MYSTYLE_ */
