.\" t
.\" @(#)Cascade.1  12/10/98
.TH Cascade 1.6 "Dec 10 1998" Cascade
.UC
.SH NAME
\fBCascade\fP \- the AfterStep window cascading module

.SH SYNOPSIS
\fBCascade\fP is spawned by afterstep, so no command line invocation will work.
.sp
From within an AfterStep menu file by 'Cascade':
.nf
.sp
% cat "~/GNUstep/Library/AfterStep/start/Modules/Cascade"
	Module "Animate" Cascade -resize 10 2 80 70
	MiniPixmap "mini-as.xpm"
.fi

To stop the \fBCascade\fP module, a menu item can be used:
.nf
.sp
% cat "~/GNUstep/Library/AfterStep/start/Modules/Cascade_Stop"
	KillModuleByName "Stop Cascade" Cascade
	MiniPixmap "mini-as.xpm"
.fi

.SH DESCRIPTION
The \fBCascade\fP module attempts to cascade windows on the current screen
subject to certain constraints.  Layering is performed so consecutive
windows will have their window titles visible underneath the previous.

.SH INVOCATION
\fBCascade\fP can be invoked from binding the action "Module Cascade
\fIoptions\fP" to a key-stroke in the \fIfeel\fP, or from a menu item as
shown in the Synopsis section above.

The \fBCascade\fP module can also be called multiple times with
different options. This way multiple Cascading programs can be used, and
is unlike other modules which require a symlink to run multiple times.

.SH CONFIGURATION OPTIONS
Command-line arguments passed to Cascade are described below.

.TP
.B \-a
Causes \fIall\fP window styles to be affected, even ones with the
WindowListSkip style.
.TP
.B \-desk
Causes all windows on the desk to be cascaded instead of the current
screen only.
.TP
.B \-flatx
Inhibits border width increment.
.TP
.B \-flaty
Inhibits border height increment.
.TP
.B "\-incx \fIarg\fP"
Specifies a horizontal increment which is successively added to
cascaded windows.  \fIarg\fP is a percentage of screen width, or pixel
value if a \fIp\fP is suffixed.  Default is zero.
.TP
.B "\-incy \fIarg\fP"
Specifies a vertical increment which is successively added to cascaded
windows.  \fIarg\fP is a percentage of screen height, or pixel value
if a \fIp\fP is suffixed.  Default is zero.
.TP
.B \-m
Causes maximized windows to also be affected (implied by \-all).
.TP
.B \-noraise
Inhibits window raising, leaving the depth ordering intact.
.TP
.B \-nostretch
Inhibits window expansion when using the \-resize option.  Windows
will only shrink to fit the maximal width and height (if given).
.TP
.B \-r
Reverses the window sequence.
.TP
.B \-s
Causes sticky windows to also be affected (implied by \-all).
.TP
.B \-resize
Forces all windows to resize to the constrained width and height (if
given).
.TP
.B \-t
Causes transient windows to also be affected (implied by \-all).
.TP
.B \-u
Causes untitled windows to also be affected (implied by \-all).

Up to four numbers can be placed on the command line that are not
switches.  The first pair specify an x and y offset to start the first
window (default is 0, 0).  The second pair specify a maximal width and
height for the layered windows.  If an affected window exceeds either
this width or height, it is resized to the maximal width or height.
If each number is suffixed with the letter p, then it is taken to be a
pixel value, otherwise it is interpreted as a screen percentage.
Specifying zero for any parameter is equivalent to not specifying it.

.SH EXAMPLE
As an example case,
one could call Cascade with the following arguments:

\fBCascade \-resize 10 2 80 70\fP

This invocation will cascade windows starting 10 by 2 percent into and
down the screen.  Windows will be constrained to 80 by 70 percent of
the screen dimensions.  Since the \fIresize\fP is also specified,
windows will be resized to the given constrained width and height.

.SH BUGS
It is probably not a good idea to delete windows while windows are
being cascaded.

.SH AUTHOR
Andrew Veliath
.nf
David Mihm <davemann@ionet.net> [Man page]

.SH SEE ALSO
.BR afterstep (1)
