
#define IN_MODULE

#include "../../include/afterstep.h"
#include "../../include/screen.h"
#include "../../include/stepgfx.h"

#ifdef MAX_BUTTONS
#undef MAX_BUTTONS
#endif

#define MAX_BUTTONS 100

#define MAX_OVERLAY 3

#define BUTTON_ARRAY_LN 102
#define FOLDER_ARRAY_LN 10

#define ICON_WIN_WIDTH	48
#define ICON_WIN_HEIGHT 48

#define ISMAPPED 0
#define NOTMAPPED 1

typedef struct icon_info {
    char *file;
    short w, h;
    Pixmap icon, mask;
    char depth;    
} icon_info;

struct folder_info;
typedef struct button_info
{
  struct button_info* next;
  char *action;
  char *title;
  int num_icons;
  icon_info icons[MAX_OVERLAY];
  int x, y;
  int width;
  int height;
  icon_info completeIcon;		/* icon with background */
  Window IconWin;
  Window swallowed_win;
  XSizeHints hints;
  char *hangon;
  char up;
  char swallow;
  char maxsize;
  Bool user_set_size;
  char module;
  struct folder_info* parent; /* folder containing this button */
  struct folder_info* folder; /* folder this button contains */
#ifdef ENABLE_DND
  char *drop_action;
#endif    
  Bool is_shaped;		/* is the button shaped? */
} button_info;

typedef struct folder_info
{
  struct folder_info* next;
  Window win;         		/* Window of the Folder */
  struct button_info* parent;	/* button which owns this folder */
  struct button_info* first;	/* pointer to first button */
  int count;			/* count folded buttons */
  int mapped;         		/* is the window visible or not ?? */
  int width;          		/* width of win in pixels */
  int height;         		/* height of win in pixels */
  int direction;      		/* direction of the folder */
#ifdef SHAPE
  Pixmap mask;			/* mask for shaping the folder window */
  Bool is_shaped;		/* is the folder shaped? */
#endif
} folder_info;

/*************************************************************************
 *
 * Subroutine Prototypes
 * 
 *************************************************************************/
/* from Wharf.c */
extern void   CreateWindow(void);
extern Pixel  GetColor(char *name);
extern void   nocolor(char *a, char *b);
extern void   match_stringWharf(char *tline);
#ifdef ENABLE_SOUND
extern void   bind_sound(char *tline);
extern void   PlaySound(int event);
#endif
extern void   Loop(void);
extern void   ParseOptions(char *);
extern void   ParseBaseOptions(char *);
extern void   change_window_name(char *str);
extern int    My_XNextEvent(Display *dpy, XEvent *event);
extern void   DeadPipe(int nonsense);

/* from icons.c */
extern void   LoadIconFile(icon_info* icon);
extern void   CreateButtonIconWindow(button_info* button, Window *win);
void ConfigureIconWindow(button_info* button);
extern void   GetBitmapFile(icon_info* icon);
extern int    GetImageFile(icon_info* icon);
extern int    GetXPMData(icon_info* icon, char **data);
extern int    GetXPMGradient(icon_info* icon, int from[3], int to[3], int maxcols,
		   int type);
extern int    GetSolidXPM(icon_info* icon, Pixel pixel);
extern Bool Pushed;
extern Bool ForceSize;
extern void DrawOutline(Drawable d, int w, int h);

/* from Wharf.c */
void process_message(unsigned long type,unsigned long *body);
void send_clientmessage (Window w, Atom a, Time timestamp);
void swallow(unsigned long *body);
void ConstrainSize (XSizeHints *hints, int *widthp, int *height);
void MapFolder(folder_info* folder, int base_x, int base_y);
void CloseFolder(folder_info* folder);
void OpenFolder(folder_info* folder,int x, int y, int w, int h);
void RedrawPushed(button_info* button);
void RedrawUnpushed(button_info* button);
void RedrawUnpushedOutline(button_info* button);
void RedrawPushedOutline(button_info* button);
void RedrawWindow(folder_info* folder, button_info* newbutton);
void CreateShadowGC(void);

extern Display *dpy;			/* which display are we talking to */
/*
extern Window Root;
extern int screen;
extern long d_depth;
extern GC NormalGC, HiReliefGC,
*/
extern Pixel back_pix, fore_pix;
extern GC HiInnerGC;
extern GC MaskGC;
extern XFontStruct *font;
#ifdef SHAPE
extern GC ShapeGC;
#endif /* SHAPE */

extern icon_info back_pixmap;

extern char *iconPath;
extern char *pixmapPath;

#ifdef BROKEN_SUN_HEADERS
#include "../../afterstep/sun_headers.h"
#endif

#ifdef NEEDS_ALPHA_HEADER
#include "../../afterstep/alpha_header.h"
#endif /* NEEDS_ALPHA_HEADER */

