#include <WINGsP.h>

#include "files.h"
#include "FSFileButton.h"
#include "filebrowser.h"
#include "FSViewer.h"
#include "FSFileView.h"
#include "FSMenu.h"
#include "FSPanel.h"
#include "FSUtils.h"
#include "FSFinder.h"


static void fsSetViewerMode(FSViewer *fsViewer, FSFileViewType mode);

FileInfo *
fsGetFSViewerCurrentFileInfo(FSViewer *fsViewer)
{
    FSFileView *fView;
    
    fView = FSGetFSViewerCurrentView(fsViewer);

    return FSGetFileViewFileInfo(fView);
}

void
FSQuitCB(WMWidget *w, void *data)
{
    exit(0);
}

void 
FSHideCB(FSViewer *fsViewer, int item, Time time)
{
    WMHideApplication(FSGetFSViewerWMContext(fsViewer));
}

void 
FSHideOthersCB(FSViewer *fsViewer, int item, Time time)
{
        WMHideOthers(FSGetFSViewerWMContext(fsViewer));
}

void 
FSInfoPanelCB(FSViewer *fsViewer, int item, Time time)
{
    FSRunInfoPanel(fsViewer, "FSViewer", "Info");
}

void 
FSLegalCB(FSViewer *fsViewer, int item, Time time)
{
    FSRunLegalPanel(fsViewer, "Legal", "License");
}

void 
FSPrefCB(FSViewer *fsViewer, int item, Time time)
{
    FSRunPreferencesPanel(fsViewer, "Preferences");
}

void 
FSWMPrefCB(FSViewer *fsViewer, int item, Time time)
{
    FSRunPreferencesPanel(fsViewer, "Preferences");
}

void 
FSRunCB(FSViewer *fsViewer, int item, Time time)
{
    FSLaunchApp(fsViewer, AppExec);
}

void 
FSViewCB(FSViewer *fsViewer, int item, Time time)
{
    FSLaunchApp(fsViewer, AppView);
}

void 
FSEditCB(FSViewer *fsViewer, int item, Time time)
{
    FSLaunchApp(fsViewer, AppEdit);    
}

void 
FSInspectorCB(FSViewer *fsViewer, int item, Time time)
{
    FileInfo *fileInfo;

    fileInfo = fsGetFSViewerCurrentFileInfo(fsViewer);
    FSShowInspectorWindow(FSGetFSViewerScreen(fsViewer), fileInfo);
}

void 
FSBrowseCB(FSViewer *fsViewer, int item, Time time)
{
    fsSetViewerMode(fsViewer, Browser);
}

void 
FSIconCB(FSViewer *fsViewer, int item, Time time)
{
    fsSetViewerMode(fsViewer, Icon);
}

void 
FSListCB(FSViewer *fsViewer, int item, Time time)
{
    fsSetViewerMode(fsViewer, List);
}

static void 
fsSetViewerMode(FSViewer *fsViewer, FSFileViewType mode)
{
    FSFileView *fView;
    
    fView = FSGetFSViewerCurrentView(fsViewer);

    FSSetFileViewMode(fView, mode);
}

void 
FSSortOrderCB(FSViewer *fsViewer, int item, Time time)
{
    FSToggleSort();
    FSUpdateFileViewPath(FSGetFSViewerCurrentView(fsViewer), 
			 FileSync, NULL, NULL);
}

void 
FSNewViewCB(FSViewer *fsViewer, int item, Time time)
{
    FSFileView *fView = FSGetFSViewerCurrentView(fsViewer);
    
    if (!(FSCreateFileView(fsViewer, FSGetFileViewPath(fView), False)))
    {
	WMRunAlertPanel(FSGetFSViewerScreen(fsViewer), NULL,
                        "New View",
                        "Error creating New FileViewer",
                        "OK", NULL, NULL);
    }
}

void 
FSDotFilesCB(FSViewer *fsViewer, int item, Time time)
{
    FSToggleDisplayHiddenFiles();
    FSUpdateFileViewPath(FSGetFSViewerCurrentView(fsViewer), 
			 FileSync, NULL, NULL);
}

void 
FSCopyCB(FSViewer *fsViewer, int item, Time time)
{
    FileInfo *fileInfo;

    fileInfo = fsGetFSViewerCurrentFileInfo(fsViewer);
    FSSetFSViewerClip(fsViewer, fileInfo);
    FSSetFSViewerClipAction(fsViewer, ClipCopy);
}

void 
FSCutCB(FSViewer *fsViewer, int item, Time time)
{
    FileInfo *fileInfo;

    fileInfo = fsGetFSViewerCurrentFileInfo(fsViewer);
    FSSetFSViewerClip(fsViewer, fileInfo);
    FSSetFSViewerClipAction(fsViewer, ClipCut);
}

void 
FSPasteCB(FSViewer *fsViewer, int item, Time time)
{
    ClipAction clipAction;
    FileInfo *dest = NULL;
    FileInfo *src  = NULL;

    dest = fsGetFSViewerCurrentFileInfo(fsViewer);
    src  = FSGetFSViewerClip(fsViewer);

    if(src == NULL)
	return;

    clipAction = FSGetFSViewerClipAction(fsViewer);

    if(clipAction == ClipCopy)
	FSCopy(src, dest);
    else if(clipAction == ClipCut)
	FSMove(src, dest);

    FSSetFSViewerClip(fsViewer, NULL);
}

void 
FSLinkCB(FSViewer *fsViewer, int item, Time time)
{
    char     *new  = NULL;
    char     *old  = NULL;
    FileInfo *src;
    FileInfo *dest = FSCreateFileInfo();

    src = fsGetFSViewerCurrentFileInfo(fsViewer);
    old = GetPathnameFromPathName(src->path, src->name);
    new = WMRunInputPanel(FSGetFSViewerScreen(fsViewer), NULL,
			  "Link Name", "Link: Enter the link name",
			  old, "OK", "Cancel");

    if(new != NULL)
    {
	dest->path = GetPathFromPathname(new);
	dest->name= GetNameFromPathname(new);
	FSLink(src, dest);
    }

    if(new != NULL)
	free(new);
    if(old != NULL)
	free(old);
}

void 
FSRenameCB(FSViewer *fsViewer, int item, Time time)
{
    char     *new  = NULL;
    char     *old  = NULL;
    FileInfo *src;
    FileInfo *dest = FSCreateFileInfo();

    src = fsGetFSViewerCurrentFileInfo(fsViewer);
    old = GetPathnameFromPathName(src->path, src->name);
    new = WMRunInputPanel(FSGetFSViewerScreen(fsViewer), NULL,
			  "Rename File", "Rename: Enter the new file name",
			  old, "OK", "Cancel");

    if(new != NULL)
    {
	dest->path = GetPathFromPathname(new);
	dest->name = GetNameFromPathname(new);
	FSRename(src, dest);
    }

    if(new != NULL)
	free(new);
    if(old != NULL)
	free(old);

}

void 
FSDeleteCB(FSViewer *fsViewer, int item, Time time)
{
    FileInfo *fileInfo;

    fileInfo = fsGetFSViewerCurrentFileInfo(fsViewer);

    FSDelete(fileInfo);
}

void 
FSNewFileCB(FSViewer *fsViewer, int item, Time time)
{
    char *new = NULL;
    char *initPath = NULL;
    FileInfo *fileInfo;
    mode_t umask = FSGetUMask();

    fileInfo = fsGetFSViewerCurrentFileInfo(fsViewer);

    if(isDirectory(fileInfo->fileType))
    {
	initPath = GetPathnameFromPathName(fileInfo->path, fileInfo->name);
    }
    else
    {
	initPath = wstrdup(fileInfo->path);
    }

    new = WMRunInputPanel(FSGetFSViewerScreen(fsViewer), NULL,
			  "Create a new file", 
			  "New File: Enter the new file name",
			  GetPathnameFromPathName(initPath, ""),
			  "OK", "Cancel");

    if(new)
    {
	if(FSCreateNewFile(new, umask & 0777)) 
	{
	    char s[0xff];
	    
	    sprintf(s, "Error creating file %s", new);
	    FSErrorDialog("File Operation Error", s);
	}
	else
	{
	    FileInfo *src = FSCreateFileInfo();
	    FileInfo *dest = FSGetFileInfo(new);

	    FSUpdateFileView(FileCopy, src, dest);
	    if(src)
		FSFreeFileInfo(src);
	    if(dest)
		FSFreeFileInfo(dest);
	}
    }

    if(new)
	free(new);
    if(initPath)
	free(initPath);
}


void 
FSNewDirCB(FSViewer *fsViewer, int item, Time time)
{
    char *new = NULL;
    char *initPath = NULL;
    FileInfo *fileInfo;
    mode_t umask = FSGetUMask();

    fileInfo = fsGetFSViewerCurrentFileInfo(fsViewer);

    if(isDirectory(fileInfo->fileType))
    {
	initPath = GetPathnameFromPathName(fileInfo->path, fileInfo->name);
    }
    else
    {
	initPath = wstrdup(fileInfo->path);
    }

    new = WMRunInputPanel(FSGetFSViewerScreen(fsViewer), NULL,
			  "Create a new directory", 
			  "New Dir: Enter the new directory name",
			  GetPathnameFromPathName(initPath, ""),
			  "OK", "Cancel");

    if(new)
    {
	if (FSCreateNewDirectory(new, umask & 0777)) 
	{
	    char s[0xff];
	    
	    sprintf(s, "Error creating folder %s", new);
	    FSErrorDialog("File Operation Error", s);
	}
	else
	{
	    FileInfo *src = FSCreateFileInfo();
	    FileInfo *dest = FSGetFileInfo(new);
	
	    src->name = dest->name;
	    dest->name = wstrdup("");
	    FSUpdateFileView(FileCopy, src, dest);
	    if(src)
		FSFreeFileInfo(src);
	    if(dest)
		FSFreeFileInfo(dest);
	}
    }

    if(new)
	free(new);
    if(initPath)
	free(initPath);
}

void 
FSConsoleCB(FSViewer *fsViewer, int item, Time time)
{
    FileInfo *fileInfo;
    FileInfo *pathInfo;

    fileInfo = FSCreateFileInfo();

    fileInfo->name = (char *) wmalloc(8);
    strcpy(fileInfo->name, "CONSOLE");

    pathInfo = fsGetFSViewerCurrentFileInfo(fsViewer);

    if(isDirectory(pathInfo->fileType))
    {
	fileInfo->path = GetPathnameFromPathName(pathInfo->path, 
						 pathInfo->name);
    }
    else
    {
	fileInfo->path = pathInfo->path;
    }

    LaunchApp(fsViewer, fileInfo, AppExec);

    if(pathInfo)
	FSFreeFileInfo(pathInfo);
    if(fileInfo)
	FSFreeFileInfo(fileInfo);

}

void 
FSFilterViewCB(FSViewer *fsViewer, int item, Time time)
{
    char *filter      = NULL;
    char *init        = NULL;
    char *title       = "Filter Current FileView";
    char *prompt      = "Enter Filter Value:";
    FSFileView *fView = NULL;
    
    fView  = FSGetFSViewerCurrentView(fsViewer);
    init   = FSGetFileViewFilter(fView);
    if((filter = WMRunInputPanel(FSGetFSViewerScreen(fsViewer), 
			     FSGetFileViewWindow(fView), 
			     title, prompt, init, "OK", "Cancel")) != NULL)
    {
	if(strcmp("", filter) == 0)
	    filter = NULL;
	
	FSSetFileViewFilter(fView, filter);
	
	if(filter)
	    free(filter);
    }
}

void 
FSSelectAllCB(FSViewer *fsViewer, int item, Time time)
{
    WMRunAlertPanel(FSGetFSViewerScreen(fsViewer), NULL, "Menu Error", 
		    "This menu option has not yet been implemented",
		    "OK", NULL, NULL);
}

void 
FSDeselectAllCB(FSViewer *fsViewer, int item, Time time)
{
    WMRunAlertPanel(FSGetFSViewerScreen(fsViewer), NULL, "Menu Error", 
		    "This menu option has not yet been implemented",
		    "OK", NULL, NULL);
}

void 
FSMountCB(Disk *disk, int item, Time time)
{
    int noerror = 1;
    char *execStr = NULL;
/*     char *cmd = FSGetStringForNameKey("DISKS", "mount"); */

/*     if(cmd) */
    if(disk->mntCmd)
    {
/* 	execStr = FSParseExecString(disk->point, cmd); */
	execStr = FSParseExecString(disk->point, disk->mntCmd);
	
	if(execStr)
	{
	    noerror = execCommand(execStr);
	    free(execStr);
	}
	else
	    noerror = 0;
/* 	free(cmd); */
    }
    else
	noerror = 0;

    if(!noerror)
    {
	char s[0xff];
	
	sprintf(s, "Unable to mount \"%s\"", disk->name);
	WMRunAlertPanel(FSGetFSViewerScreen(disk->app), NULL, "Exec Error", 
			s, "OK", NULL, NULL);
    }
}

void 
FSUnmountCB(Disk *disk, int item, Time time)
{
    int noerror = 1;
    char *execStr = NULL;
/*     char *cmd = FSGetStringForNameKey("DISKS", "umount"); */

/*     if(cmd) */
    if(disk->umntCmd)
    {
/* 	execStr = FSParseExecString(disk->point, cmd); */
	execStr = FSParseExecString(disk->point, disk->umntCmd);
	
	if(execStr)
	{
	    noerror = execCommand(execStr);
	    free(execStr);
	}
	else
	    noerror = 0;
/* 	free(cmd); */
    }
    else
	noerror = 0;

    if(!noerror)
    {
	char s[0xff];
	
	sprintf(s, "Unable to unmount \"%s\"", disk->name);
	WMRunAlertPanel(FSGetFSViewerScreen(disk->app), NULL, "Exec Error", 
			s, "OK", NULL, NULL); 
    }
}

void 
FSEjectCB(Disk *disk, int item, Time time)
{
    int noerror = 1;
    char *execStr = NULL;
/*     char *cmd = FSGetStringForNameKey("DISKS", "eject"); */

/*     if(cmd) */
    if(disk->ejectCmd)
    {
/* 	execStr = FSParseExecString(disk->device, cmd); */
	execStr = FSParseExecString(disk->device, disk->ejectCmd);
	
	if(execStr)
	{
	    noerror = execCommand(execStr);
	    free(execStr);
	}
	else
	    noerror = 0;
/* 	free(cmd); */
    }
    else
	noerror = 0;

    if(!noerror)
    {
	char s[0xff];
	
	sprintf(s, "Unable to eject \"%s\"", disk->name);
	WMRunAlertPanel(FSGetFSViewerScreen(disk->app), NULL, "Exec Error", 
			s, "OK", NULL, NULL);
    }
}

void 
FSCloseDiskCB(Disk *disk, int item, Time time)
{
    int noerror = 1;
    char *execStr = NULL;
/*     char *cmd = FSGetStringForNameKey("DISKS", "eject"); */

/*     if(cmd) */
    if(disk->closeCmd)
    {
/* 	execStr = FSParseExecString(disk->device, cmd); */
	execStr = FSParseExecString(disk->point, disk->closeCmd);
	
	if(execStr)
	{
	    noerror = execCommand(execStr);
	    free(execStr);
	}
	else
	    noerror = 0;
/* 	free(cmd); */
    }
    else
	noerror = 0;

    if(!noerror)
    {
	char s[0xff];
	
	sprintf(s, "Unable to close \"%s\"", disk->name);
	WMRunAlertPanel(FSGetFSViewerScreen(disk->app), NULL, "Exec Error", 
			s, "OK", NULL, NULL);
    }
}

void 
FSFinderCB(FSViewer *fsViewer, int item, Time time)
{
    if(!FSGetFSViewerFinder(fsViewer))
    {
	if(!FSCreateFinder(fsViewer))
	    wwarning("%s %d: Unable to create FSFinder", 
		     __FILE__, __LINE__);
    }
    else
    {
	/*
	 * Should check if the window is minimized or covered
	 * and bring it into view.
	 */
    }
	
}

void 
FSMiniaturizeCB(FSViewer *fsViewer, int item, Time time)
{
    WMRunAlertPanel(FSGetFSViewerScreen(fsViewer), NULL, "Menu Info", 
		    "This option is only available via the window manager.",
		    "OK", NULL, NULL);
}

void 
FSOpenAsFolderCB(FSViewer *fsViewer, int item, Time time)
{
    WMRunAlertPanel(FSGetFSViewerScreen(fsViewer), NULL, "Menu Error", 
		    "This menu option has not yet been implemented",
		    "OK", NULL, NULL);
}

void 
FSProcessCB(FSViewer *fsViewer, int item, Time time)
{
    FileInfo *fileInfo;
    FileInfo *pathInfo;

    fileInfo = FSCreateFileInfo();

    fileInfo->name = (char *) wmalloc(8);
    strcpy(fileInfo->name, "PROCESS");

    pathInfo = fsGetFSViewerCurrentFileInfo(fsViewer);

    if(isDirectory(pathInfo->fileType))
    {
	fileInfo->path = GetPathnameFromPathName(pathInfo->path, 
						 pathInfo->name);
    }
    else
    {
	fileInfo->path = pathInfo->path;
    }

    LaunchApp(fsViewer, fileInfo, AppExec);

    if(pathInfo)
	FSFreeFileInfo(pathInfo);
    if(fileInfo)
	FSFreeFileInfo(fileInfo);

}

void 
FSHelpCB(FSViewer *fsViewer, int item, Time time)
{
    WMRunAlertPanel(FSGetFSViewerScreen(fsViewer), NULL, "Menu Error", 
		    "This menu options has not yet been implemented",
		    "OK", NULL, NULL);
}

void 
FSCloseWindowCB(FSViewer *fsViewer, int item, Time time)
{
    FSFileView *fView = NULL;
    
    fView  = FSGetFSViewerCurrentView(fsViewer);
    if(!FSIsFileViewPrimary(fView))
	WMCloseWindow(FSGetFileViewWindow(fView));
}

void
FSUpdateViewCB(FSViewer *fsViewer, int item, Time time)
{
    FSFileView *fView = NULL;
    
    fView  = FSGetFSViewerCurrentView(fsViewer);
    FSUpdateFileViewPath(fView, FileSync, NULL, NULL);
}

void
FSDuplicateCB(FSViewer *fsViewer, int item, Time time)
{
    ClipAction clipAction;
    FileInfo *dest = FSCreateFileInfo();
    FileInfo *src  = NULL;

    src = fsGetFSViewerCurrentFileInfo(fsViewer);
    FSCopyFileInfo(src, dest);
    
    dest->name = (char *) wrealloc(dest->name, strlen(src->name)+7);
    strcpy(dest->name, "copyof");
    strcat(dest->name, src->name);
    
    if(isDirectory(src->fileType))
    {
	char *new = NULL;
	mode_t umask = FSGetUMask();

	new = GetPathnameFromPathName(dest->path, dest->name);
	if (new && FSCreateNewDirectory(new, umask & 0777)) 
	{
	    char s[0xff];
	    
	    sprintf(s, "Error creating folder %s", new);
	    FSErrorDialog("File Operation Error", s);
	}
	if(new)
	    free(new);
    }

    FSCopy(src, dest);
}

void 
FSCompressCB(FSViewer *fsViewer, int item, Time time)
{
    int error = 0;
    char *cmd   = FSGetStringForNameKey("COMPRESS", "exec");
    char *extn  = FSGetStringForNameKey("COMPRESS", "extn");
    
    if(!extn)
	extn = wstrdup(".tar.gz");

    if(cmd)
    {
	char *targz    = NULL;
	char *execStr  = NULL;
	char *pathname = NULL;
	FileInfo *src  = NULL;

	src = fsGetFSViewerCurrentFileInfo(fsViewer);
	pathname = GetPathnameFromPathName(src->path, src->name);
	targz = (char *) wmalloc(strlen(src->name)+strlen(extn)+1);

	strcpy(targz, src->name);
	strcat(targz, extn);

	execStr = (char *) wmalloc(strlen(cmd) + strlen(src->name) +
				   strlen(targz) + 1);

	sprintf(execStr, cmd, targz, src->name);

	if(execStr)
	{
	    error = FSExecCommand(src->path, execStr);
	    free(execStr);
	}
	else
	    error = 1;
	free(cmd);
    }
    else
	error = 1;

    if(error)
    {
	char s[0xff];
	
	sprintf(s, "Unable to compress selection.");
	WMRunAlertPanel(FSGetFSViewerScreen(fsViewer), NULL, "Exec Error", 
			s, "OK", NULL, NULL);
    }

    if(extn)
	free(extn);
}

void 
FSEmptyRecyclerCB(FSViewer *fsViewer, int item, Time time)
{
    WMRunAlertPanel(FSGetFSViewerScreen(fsViewer), NULL, "Menu Error", 
		    "This menu options has not yet been implemented",
		    "OK", NULL, NULL);
}

static void
FSAddDisksMenu(FSViewer *fsViewer, WMMenu *menu)
{
    WMMenu *submenu = NULL;
    char *cmd = NULL;
    proplist_t devArray = NULL;
    proplist_t array    = NULL;

/*     devArray = FSGetArrayForNameKey("DISKS", "devices"); */
    devArray = WMGetUDObjectForKey(defaultsDB, "DISCS");

    if(devArray)
    {
	int i, numElem;
	proplist_t tmp;

	numElem = PLGetNumberOfElements(devArray);
	for(i = 0; i < numElem; i++)
	{
	    array = PLGetArrayElement(devArray, i);
	    if(array && PLIsArray(array))
	    {
		Disk *disk = NULL;

		disk = (Disk *) wmalloc(sizeof(Disk));
		memset(disk, 0, sizeof(Disk));

		disk->app = fsViewer;
		tmp = PLGetArrayElement(array, 0);
		if(PLIsString(tmp))
		    disk->name = wstrdup(PLGetString(tmp));
		
		tmp = PLGetArrayElement(array, 1);
		if(PLIsString(tmp))
		    disk->point = wstrdup(PLGetString(tmp));
		
		tmp = PLGetArrayElement(array, 2);
		if(PLIsString(tmp))
		    disk->device = wstrdup(PLGetString(tmp));
		
		tmp = PLGetArrayElement(array, 3);
		if(PLIsString(tmp))
		    disk->mntCmd = wstrdup(PLGetString(tmp));
		
		tmp = PLGetArrayElement(array, 4);
		if(PLIsString(tmp))
		    disk->umntCmd = wstrdup(PLGetString(tmp));
		
		tmp = PLGetArrayElement(array, 5);
		if(PLIsString(tmp))
		    disk->ejectCmd = wstrdup(PLGetString(tmp));
		
		tmp = PLGetArrayElement(array, 6);
		if(PLIsString(tmp))
		    disk->closeCmd = wstrdup(PLGetString(tmp));
		
		if(disk->name)
		{
		    submenu = WMMenuCreate(fsViewer->wmContext, disk->name); 
		    WMMenuAddSubmenu(menu, disk->name, submenu);
		    WMMenuAddItem(submenu, "Mount",  
				  (WMMenuAction)FSMountCB, disk, NULL, NULL); 
		    WMMenuAddItem(submenu, "Unmount", 
				  (WMMenuAction)FSUnmountCB, disk, NULL, NULL); 
		    WMMenuAddItem(submenu, "Eject",  
				  (WMMenuAction)FSEjectCB, disk, NULL, NULL); 
		    WMMenuAddItem(submenu, "Close",  
				  (WMMenuAction)FSCloseDiskCB, disk, NULL, NULL); 
		}
	    }
	}
    }
}

void 
FSCreateMenu(FSViewer *fsViewer)
{
    int i;
    WMMenu       *submenu;

    fsViewer->menu = WMMenuCreate(fsViewer->wmContext, "FSViewer"); 

    /* Info Menu */
    submenu = WMMenuCreate(fsViewer->wmContext, "Info"); 
    WMMenuAddSubmenu(fsViewer->menu, "Info", submenu); 
    WMMenuAddItem(submenu, "Info Panel...",  
		  (WMMenuAction)FSInfoPanelCB, fsViewer, NULL, NULL); 
    WMMenuAddItem(submenu, "Legal...",  
		  (WMMenuAction)FSLegalCB, fsViewer, NULL, NULL); 
    WMMenuAddItem(submenu, "Preferences...",  
		  (WMMenuAction)FSPrefCB, fsViewer, NULL, NULL); 
/*     WMMenuAddItem(submenu, "WM Preferences...",   */
/* 		  (WMMenuAction)FSWMPrefCB, fsViewer, NULL, NULL);  */
    i = WMMenuAddItem(submenu, "Help...",
		      (WMMenuAction)FSHelpCB, fsViewer, NULL, "?");
/*     WMMenuSetEnabled(submenu, i, 0); */

    /* File Menu */
    submenu = WMMenuCreate(fsViewer->wmContext, "File"); 
    WMMenuAddSubmenu(fsViewer->menu, "File", submenu);
    i = WMMenuAddItem(submenu, "Open",
		      (WMMenuAction)FSViewCB, fsViewer, NULL, "o"); 
/*     WMMenuSetEnabled(submenu, i, 0); */
    i = WMMenuAddItem(submenu, "Open as Folder",
		      (WMMenuAction)FSOpenAsFolderCB, fsViewer, NULL, "O");
/*     WMMenuSetEnabled(submenu, i, 0); */
    WMMenuAddItem(submenu, "New Folder",  
		  (WMMenuAction)FSNewDirCB, fsViewer, NULL, "n"); 
    i = WMMenuAddItem(submenu, "Duplicate",
		      (WMMenuAction)FSDuplicateCB, fsViewer, NULL, "d");
/*     WMMenuSetEnabled(submenu, i, 0); */
    i = WMMenuAddItem(submenu, "Compress",
		      (WMMenuAction)FSCompressCB, fsViewer, NULL, NULL);
/*     WMMenuSetEnabled(submenu, i, 0); */
    i = WMMenuAddItem(submenu, "UnCompress",
		      (WMMenuAction)FSViewCB, fsViewer, NULL, NULL);
/*     WMMenuSetEnabled(submenu, i, 0); */
    i = WMMenuAddItem(submenu, "Destroy",
		      (WMMenuAction)FSDeleteCB, fsViewer, NULL, "r");
/*     WMMenuSetEnabled(submenu, i, 0); */
    i = WMMenuAddItem(submenu, "Empty Recycler",
		      (WMMenuAction)FSEmptyRecyclerCB, fsViewer, NULL, NULL);
/*     WMMenuSetEnabled(submenu, i, 0); */

    /* Edit Menu */
    submenu = WMMenuCreate(fsViewer->wmContext, "Edit"); 
    WMMenuAddSubmenu(fsViewer->menu, "Edit", submenu);
    WMMenuAddItem(submenu, "Cut",  
		  (WMMenuAction)FSCutCB, fsViewer, NULL, "x"); 
    WMMenuAddItem(submenu, "Copy",  
		  (WMMenuAction)FSCopyCB, fsViewer, NULL, "c"); 
    WMMenuAddItem(submenu, "Paste",  
		  (WMMenuAction)FSPasteCB, fsViewer, NULL, "v"); 
    WMMenuAddItem(submenu, "Delete",  
		  (WMMenuAction)FSDeleteCB, fsViewer, NULL, NULL); 
    i = WMMenuAddItem(submenu, "Select All",
		      (WMMenuAction)FSSelectAllCB, fsViewer, NULL, "a");
/*     WMMenuSetEnabled(submenu, i, 0); */
    i = WMMenuAddItem(submenu, "DeSelect All",
		      (WMMenuAction)FSDeselectAllCB, fsViewer, NULL, NULL);
/*     WMMenuSetEnabled(submenu, i, 0); */

    /* Disk Menu */
    submenu = WMMenuCreate(fsViewer->wmContext, "Disk");
    WMMenuAddSubmenu(fsViewer->menu, "Disk", submenu);
    FSAddDisksMenu(fsViewer, submenu);
/*     i = WMMenuAddItem(submenu, "Eject", */
/* 		  NULL, fsViewer, NULL, "e"); */
/*     WMMenuSetEnabled(submenu, i, 0); */
/*     i = WMMenuAddItem(submenu, "Initialize...", */
/* 		  NULL, fsViewer, NULL, NULL); */
/*     WMMenuSetEnabled(submenu, i, 0); */
/*     i = WMMenuAddItem(submenu, "Check for Disks", */
/* 		  NULL, fsViewer, NULL, NULL); */
/*     WMMenuSetEnabled(submenu, i, 0); */

    /* View Menu */
    submenu = WMMenuCreate(fsViewer->wmContext, "View"); 
    WMMenuAddSubmenu(fsViewer->menu, "View", submenu);
    WMMenuAddItem(submenu, "Browse",  
		  (WMMenuAction)FSBrowseCB, fsViewer, NULL, "B"); 
    WMMenuAddItem(submenu, "Icon",  
		  (WMMenuAction)FSIconCB, fsViewer, NULL, "I"); 
    WMMenuAddItem(submenu, "List",  
		  (WMMenuAction)FSListCB, fsViewer, NULL, "L"); 
    WMMenuAddItem(submenu, "Sort",  
		  (WMMenuAction)FSSortOrderCB, fsViewer, NULL, "s");
/*     i = WMMenuAddItem(submenu, "Clean Up Icons", */
/* 		      NULL, fsViewer, NULL, NULL); */
/*     WMMenuSetEnabled(submenu, i, 0); */
    WMMenuAddItem(submenu, "Show .files",  
		  (WMMenuAction)FSDotFilesCB, fsViewer, NULL, "D");
    WMMenuAddItem(submenu, "Filter...",  
		  (WMMenuAction)FSFilterViewCB, fsViewer, NULL, "f");
    WMMenuAddItem(submenu, "New Viewer...",  
		  (WMMenuAction)FSNewViewCB, fsViewer, NULL, "N");
    WMMenuAddItem(submenu, "Update View",  
		  (WMMenuAction)FSUpdateViewCB, fsViewer, NULL, "u");
    
    /* Tools Menu */
    submenu = WMMenuCreate(fsViewer->wmContext, "Tools"); 
    WMMenuAddSubmenu(fsViewer->menu, "Tools", submenu);
    WMMenuAddItem(submenu, "Inspector...",  
		  (WMMenuAction)FSInspectorCB, fsViewer, NULL, "i");
    i = WMMenuAddItem(submenu, "Finder",
		      (WMMenuAction)FSFinderCB, fsViewer, NULL, "F");
    /*     WMMenuSetEnabled(submenu, i, 0); */
    i = WMMenuAddItem(submenu, "Processes...",
		      (WMMenuAction)FSProcessCB, fsViewer, NULL, "P");
/*     WMMenuSetEnabled(submenu, i, 0); */
    WMMenuAddItem(submenu, "Console...",  
		  (WMMenuAction)FSConsoleCB, fsViewer, NULL, "C");

    /* Windows Menu */
    submenu = WMMenuCreate(fsViewer->wmContext, "Windows");
    WMMenuAddSubmenu(fsViewer->menu, "Windows", submenu);
/*     i = WMMenuAddItem(submenu, "Arrange in Front", */
/* 		      NULL, fsViewer, NULL, NULL); */
/*     WMMenuSetEnabled(submenu, i, 0); */
    /*
     * This should contain a list of the windows
     * Problem would be how to foucs them if they are
     * added to the submenu. Would setting the focus to
     * a widget work?
     */
    /* 
     * This is the standard key binding for miniaturizing windows
     * under window maker. At this moment I can find a wmlib function
     * to do this though I should put one together from the X functions
     */
    i = WMMenuAddItem(submenu, "Miniaturize Window",
		      (WMMenuAction)FSMiniaturizeCB, fsViewer, NULL, "m");
/*     WMMenuSetEnabled(submenu, i, 0); */
    i = WMMenuAddItem(submenu, "Close Window",
		      (WMMenuAction)FSCloseWindowCB, fsViewer, NULL, "w");
/*     WMMenuSetEnabled(submenu, i, 0); */

    /* Services Menu <- Custom stuff belongs here :) */
    submenu = WMMenuCreate(fsViewer->wmContext, "Services");
    WMMenuAddSubmenu(fsViewer->menu, "Services", submenu);
    WMMenuAddItem(submenu, "File Edit...",
          (WMMenuAction)FSEditCB, fsViewer, NULL, "E");
    WMMenuAddItem(submenu, "File Link...",
		  (WMMenuAction)FSLinkCB, fsViewer, NULL, "l");
    WMMenuAddItem(submenu, "File New...",
		  (WMMenuAction)FSNewFileCB, fsViewer, NULL, NULL);
    WMMenuAddItem(submenu, "File Rename...",
		  (WMMenuAction)FSRenameCB, fsViewer, NULL, NULL);
    WMMenuAddItem(submenu, "File Run...",
		  (WMMenuAction)FSRunCB, fsViewer, NULL, "R");
    WMMenuAddItem(submenu, "Show Image",
		  (WMMenuAction)FSViewCB, fsViewer, NULL, "S");
/*     i = WMMenuAddItem(submenu, "Show PDF", */
/* 		  (WMMenuAction)FSViewCB, fsViewer, NULL, NULL); */
/*     WMMenuSetEnabled(submenu, i, 0); */

    /* Hide and Quit */
    WMMenuAddItem(fsViewer->menu, "Hide",  
		  (WMMenuAction)FSHideCB, fsViewer, NULL, "h");  
    WMMenuAddItem(fsViewer->menu, "Hide Others",
		  (WMMenuAction)FSHideOthersCB, fsViewer, NULL, NULL);
    WMMenuAddItem(fsViewer->menu, "Quit",  
		  (WMMenuAction)FSQuitCB, fsViewer, NULL, "q"); 

    WMAppSetMainMenu(fsViewer->wmContext, fsViewer->menu);  
    WMRealizeMenus(fsViewer->wmContext);  

}

