/*
** 1999-08-25 -	Some code to deal with the menu which can be accessed by right-clicking a pane. This code actually makes
**		the menu context-sensitive, sort of. The "File Action" submenu will show the intersection of all actions
**		defined for the selected rows. Pretty cool.
**		
*/

#include "gentoo.h"

#include "dirpane.h"
#include "dpmenu.h"

/* ----------------------------------------------------------------------------------------- */

/* 1999-08-26 -	Just check if <action> is on the list <actions> or not. We can't use g_slist_find(),
**		since we need to do the comparison by textual content, not pointers.
*/
static gboolean action_on_list(GSList *actions, const gchar *action)
{
	GSList	*iter;

	for(iter = actions; iter != NULL; iter = g_slist_next(iter))
	{
		if(strcmp(iter->data, action) == 0)
			return TRUE;
	}
	return FALSE;
}

/* 1999-08-26 -	Check if <action> mentioned in each of the styles on <styles> (except <current>). Returns
**		TRUE if so, FALSE if not. This routine really makes my performance-centered mind feel ill.
**		I guess I'll have to fix it someday. :)
*/
static gboolean action_in_intersection(GSList *styles, GSList *current, const gchar *action)
{
	GSList		*siter;
	GList		*palist, *piter;
	gboolean	found;

	for(siter = styles; siter != NULL; siter = g_slist_next(siter))
	{
		if(siter == current)
			continue;
		palist = stl_style_property_get_actions(siter->data);
		for(piter = palist, found = FALSE; piter != NULL && !found; piter = g_list_next(piter))
		{
			if(strcmp(piter->data, action) == 0)
				found = TRUE;
		}
		g_list_free(palist);
		if(!found)
			return FALSE;
	}
	return TRUE;
}

/* 1999-08-25 -	Update the file action submenu depending on what is currently selected. */
void dpm_update(DirPane *dp)
{
	GSList	*slist;

	if(dp->menu_action != NULL)
	{
		gtk_menu_item_remove_submenu(GTK_MENU_ITEM(dp->mitem_action));	/* This frees the menu too. I checked. :) */
		dp->menu_action = NULL;
		gtk_widget_hide(dp->mitem_action);
	}

	if((slist = dp_get_selection(dp)) != NULL)
	{
		GSList	*iter, *styles = NULL, *actions = NULL;
		GList	*palist, *piter;
		Style	*stl;

		for(iter = slist; iter != NULL; iter = g_slist_next(iter))
		{
			stl = DP_SEL_TYPE(iter)->style;
			if(g_slist_find(styles, stl) == NULL)
				styles = g_slist_prepend(styles, stl);
		}

		for(iter = styles; iter != NULL; iter = g_slist_next(iter))
		{
			palist = stl_style_property_get_actions(iter->data);
			for(piter = palist; piter != NULL; piter = g_list_next(piter))
			{
				if(action_on_list(actions, piter->data))
					continue;
				if(action_in_intersection(styles, iter, piter->data))
					actions = g_slist_insert_sorted(actions, piter->data, (GCompareFunc) strcmp);
			}
			g_list_free(palist);
		}
		g_slist_free(styles);

		if(actions != NULL)
		{
			GtkWidget	*item;

			dp->menu_action = gtk_menu_new();

			for(iter = actions; iter != NULL; iter = g_slist_next(iter))
			{
				item = gtk_menu_item_new_with_label(iter->data);
				gtk_object_set_user_data(GTK_OBJECT(item), dp->main);
				gtk_object_set_data(GTK_OBJECT(item), "action", iter->data);		/* Magic marker. */
				gtk_signal_connect(GTK_OBJECT(item), "activate", GTK_SIGNAL_FUNC(evt_dirpane_menu), NULL);
				gtk_menu_append(GTK_MENU(dp->menu_action), item);
				gtk_widget_show(item);
			}

			gtk_menu_item_set_submenu(GTK_MENU_ITEM(dp->mitem_action), dp->menu_action);
			gtk_widget_show(dp->menu_action);
			gtk_widget_show(dp->mitem_action);
			g_slist_free(actions);
		}
		dp_free_selection(slist);
	}
}

/* ----------------------------------------------------------------------------------------- */

#define	MNU_SEP	"---"
#define	MNU_SUB	'/'

/* 1998-06-04 -	Go through the menu definitions in min->cfg.dpmenuroot, and construct the corresponding GTK+ menu
**		structure, which is returned on success. Has rudimentary support for one-level submenus. Lesson learned
**		while doing that: don't ever connect "activate" signal of a submenu-having item. GTK+ won't like that much.
** 1998-07-12 -	Tried adding support for separators, in the most obvious way I could figure out. Doesn't look good at all.
**		Then wisened up, looked in the source for GtkMenuFactory, and simplified. Works fine.
*/
static GtkWidget * build_menu(const MenuItem *definition, MainInfo *min, const gchar *search_item, GtkWidget **found_item)
{
	gchar		*sub;
	MenuItem	*mni = (MenuItem *) definition;
	GtkWidget	*menu, *item, *last = NULL, *submenu = NULL;
	gint		lasth = 0;

	if((menu = gtk_menu_new()) != NULL)
	{
		while(mni->text)
		{
			if(!strncmp(mni->text, MNU_SEP, strlen(MNU_SEP)))
			{
				if((item = gtk_menu_item_new()) != NULL)
				{
					gtk_menu_append(GTK_MENU(menu), item);
					gtk_widget_show(item);
				}
			}
			else
			{
				if((sub = strrchr(mni->text, MNU_SUB)) != NULL && last != NULL)
				{
					if(submenu == NULL)
						submenu = gtk_menu_new();
					if(submenu != NULL)
					{
						if((item = gtk_menu_item_new_with_label(sub + 1)) != NULL)
						{
							gtk_menu_append(GTK_MENU(submenu), item);
							gtk_widget_show(item);
							gtk_signal_connect(GTK_OBJECT(item), "activate", GTK_SIGNAL_FUNC(evt_dirpane_menu), mni->command);
							gtk_object_set_user_data(GTK_OBJECT(item), (gpointer) min);
						}
					}
				}
				else
				{
					if(submenu != NULL)
					{
						gtk_menu_item_set_submenu(GTK_MENU_ITEM(last), submenu);
						gtk_signal_disconnect(GTK_OBJECT(last), lasth);
						submenu = NULL;
					}
					if((item = gtk_menu_item_new_with_label(mni->text)) != NULL)
					{
						gtk_menu_append(GTK_MENU(menu), item);
						gtk_widget_show(item);
						gtk_object_set_user_data(GTK_OBJECT(item), (gpointer) min);
						lasth = gtk_signal_connect(GTK_OBJECT(item), "activate", GTK_SIGNAL_FUNC(evt_dirpane_menu), (gpointer) mni->command);
						last = item;
						if(strcmp(mni->text, search_item) == 0 && found_item != NULL)
							*found_item = item;
					}
				}

			}
			mni++;
		}
		if(last != NULL && submenu != NULL)
		{
			gtk_menu_item_set_submenu(GTK_MENU_ITEM(last), submenu);
			gtk_signal_disconnect(GTK_OBJECT(last), lasth);
		}
	}
	return menu;
}

/* 1999-08-25 -	Initialize the static parts of a pane's menu. */
void dpm_initialize(DirPane *dp)
{
	static MenuItem	mnu[] = { {"Parent", "DirParent"}, {"Other", "DirFromOther"}, {"Rescan", "DirRescan"},
				{"Select", NULL}, {"/All", "SelectAll"}, {"/None", "SelectNone"},
				{"/Toggle", "SelectToggle"}, {"/RegExp...", "SelectRE"}, {"/Extend", "SelectExt"},
				{"File Action", NULL},	/* This string ("File Action") is **magic**! It triggers the context-sensitive submenu! Beware! */
				{"Run...", "Run"},
				{"---", NULL}, {"Configure...", "Configure"}, {NULL, NULL} };

	dp->menu_top = build_menu(mnu, dp->main, "File Action", &dp->mitem_action);
	gtk_widget_hide(dp->mitem_action);
	dp->menu_action = NULL;
	dpm_update(dp);
}
