/*
    saft.c - SAFT interface
    Copyright (c) 1999  Martin Schulze <joey@infodrom.north.de>

    This file is part of the Gerstensaft package.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111, USA.
*/

#include <malloc.h>
#include <stdlib.h>
#include <unistd.h>
#include "config.h"
#include "msgbox.h"
#include "io.h"
#include "nls.h"
#include "saft.h"


#include <stdio.h>
#include <string.h>

char *saft_taint_fname (const char *fname)
{
  char *res = NULL;
  char *p, *q;

  if (!fname)
    return NULL;

  if ((res = (char *)malloc((strlen(fname)*2)+1)) != NULL) {
    for (p=fname,q=res;*p;p++,q++) {
      if (strchr(" |\'\"`", *p))
	*(q++)='\\';
      *q=*p;
    }
    *q='\0';
  }

  return res;
}

void saft_send (const char *addr, char **files)
{
  int n;
  char **cp;
  char *cmd;
  char *lastdir;
  char errmsg[1024];
  char *taint_fname, *taint_archive;

  if (!addr || !strlen(addr))
    return;

#ifdef SENDFILE_PRE_A
  /*
   *  We have to make two runs, first all directories, then all files
   *  in one session.
   */
  for (n=0,cp=files; *cp; (char **)cp++)
    if (is_dir (*cp, NULL))
      if (strlen (*cp) > n)
	n = strlen (*cp);

  n = 50 + (2*n+5) + strlen(addr);

  if ((cmd = (char *)malloc (n)) == NULL)
    return;

  /* Now build the command lines */
  for (cp=files; *cp; (char **)cp++)
    if (is_dir (*cp, NULL)) {
      if ((lastdir = strrchr (*cp, '/')) == NULL)
	lastdir = *cp;
      else {
	*lastdir = '\0';
	if (chdir (*cp) == 0) {
	  /*
	  *(lastdir++) = '/';
	  */
	  *(lastdir++) = '/';
	  taint_fname = saft_taint_fname(lastdir);
	  sprintf (cmd, "sendfile -Q -a=%s %s %s", taint_fname, taint_fname, addr);
	  free (taint_fname);
	} else {
	  *(lastdir++) = '/';
	  taint_archive = saft_taint_fname(lastdir);
	  taint_fname = saft_taint_fname(*cp);
	  sprintf (cmd, "sendfile -Q -a=%s %s %s", taint_archive, taint_fname, addr);
	  free (taint_archive);
	  free (taint_fname);
	}
      }

      if (system (cmd) != 0) {
	snprintf (errmsg, sizeof(errmsg), _("Failed to send\n%s"), *cp);
	msgbox (_("Gerstensaft Error"), errmsg); 
      }
    }
  free (cmd);

  /* Now we come to the regular files */
  for (n=0,cp=files; *cp; (char **)cp++)
    if (!is_dir (*cp, NULL))
      n += strlen (*cp)+1;

  if (n) {
    n+=50+strlen(addr);
    if ((cmd = (char *)malloc (n)) == NULL)
      return;

    sprintf (cmd, "sendfile -Q");
    for (cp=files; *cp; (char **)cp++)
      if (!is_dir (*cp, NULL)) {
	strncat (cmd, " ", n);
	strncat (cmd, saft_taint_fname(*cp), n);
      }
    strncat (cmd, " ", n);
    strncat (cmd, addr, n);
    if (system (cmd) != 0) {
      for (lastdir=cmd; *lastdir; lastdir++)
	if (*lastdir == ' ')
	  *lastdir = '\n';
      lastdir = strrchr (cmd, '\n');
      *lastdir = '\0';
      lastdir = cmd + 12;
      snprintf (errmsg, sizeof(errmsg), _("Failed to send\n%s"), lastdir);
      msgbox (_("Gerstensaft Error"), errmsg); 
    }
    free (cmd);
  }

#else
  /*
   *  From sendfile 2.1-1999... on the parameter -A allows to send
   *  several archives (both directories and files) and regular files
   *  in one session without adding them to one single archive as they
   *  would with -a.  Framstag has implemented this upon my request.
   */
  for (n=17+strlen(addr),cp=files; *cp; (char **)cp++)
    n += 2*strlen(*cp)+2; /* foo=foo, twice the name plus space plus equiv */

  if ((cmd = (char *)malloc (n)) == NULL)
    return;

  /* Now build the command line */
  sprintf (cmd, "sendfile -Q -A");
  for (cp=files; *cp; (char **)cp++)
    if (is_dir (*cp, NULL)) {
      if ((lastdir = strrchr (*cp, '/')) == NULL)
	lastdir = *cp;
      else
	lastdir++;
      strncat (cmd, " ", n);
      strncat (cmd, lastdir, n);
      strncat (cmd, "=", n);
      strncat (cmd, *cp, n);
    } else {
      strncat (cmd, " ", n);
      strncat (cmd, *cp, n);
    }
  strncat (cmd, " ", n);
  strncat (cmd, addr, n);

  if (system (cmd) != 0) {
    for (lastdir=cmd; *lastdir; lastdir++)
      if (*lastdir == ' ')
	*lastdir = '\n';
    lastdir = strrchr (cmd, '\n');
    *lastdir = '\0';
    lastdir = cmd + 16;
    snprintf (errmsg, sizeof(errmsg), _("Failed to send\n%s"), lastdir);
    msgbox (_("Gerstensaft Error"), errmsg); 
  }
  free (cmd);
#endif

  return;
}
