/* callbacks.c - controls GTK callback functions (excluding network) */

#include <unistd.h>
#include <netinet/in.h>

#include <gnome.h>

#include "napster.h"
#include "gnapster.h"
#include "callbacks.h"
#include "ui.h"

extern CONN_INFO conn_info;
extern USER_INFO user_info;
extern GNAPSTER_MAIN gnapster_main;
extern SEARCH_TAB search_tab;
extern DOWNLOAD_TAB download_tab;
extern CONSOLE_TAB console_tab;
extern CHAT_TAB chat_tab;
extern MOTD_TAB motd_tab;
extern PROP_DLG prop_dlg;

void gnapster_exit_cb() {
   if (conn_info.connected) {
      close(conn_info.sock); 
      gdk_input_remove(conn_info.sock_input);
   }
   gtk_main_quit();
}

void switch_page_cb(GtkWidget *widget, GtkNotebookPage *page, int page_num,
		    gpointer data) {
   GtkWidget *nth_page, *label;
   GtkStyle *old_style;
   
   nth_page = gtk_notebook_get_nth_page(GTK_NOTEBOOK(widget), page_num);
   label = gtk_notebook_get_tab_label(GTK_NOTEBOOK(widget), nth_page);
   old_style = gtk_widget_get_style(label);
   if (old_style == gnapster_main.highlight)
     gtk_widget_set_style(label, gnapster_main.normal);
}

void menu_popup_cb(GtkWidget *widget, GdkEventButton *event, gpointer data) {
   GtkWidget *temp_menu;
   int row = -1, col;
   
   /* Quick and dirty hack to let users double click to download, rename
    * function later */
   if (event->type == GDK_2BUTTON_PRESS && event->button == 1) {
      download_cb();
      return;
   }
   
   if (event->button == 3) {
      gtk_clist_get_selection_info(GTK_CLIST(widget), event->x, event->y,
				   &row, &col);
      temp_menu = gnome_popup_menu_new(data);
      gnome_popup_menu_do_popup_modal(temp_menu, NULL, NULL, event, NULL);
      gtk_widget_destroy(temp_menu);
   }
}

void console_activate_cb() {
   char *console_text, *command, *user = NULL, *message = NULL;
   char *temp_str = NULL;
   
   console_text = gtk_entry_get_text(GTK_ENTRY(console_tab.entry));
   if (!console_text || !conn_info.connected) return;
   
   command = strdup(console_text);
   user = strchr(command, ' ');
   if (user) {
      user[0] = '\0';
      user++;
      message = strchr(user, ' ');
      if (message) {
	 message[0] = '\0';
	 message++;
      }
   }
   
   gtk_entry_set_text(GTK_ENTRY(console_tab.entry), "");
   if (!strcmp(command, "/help")) {
      temp_str = 
	strdup("Supported Commands:\n * /whois [user] - Prints user information from the server\n * /msg <user> <message> - Sends a message to the specified user\n");
      gnapster_text_insert(console_tab.text, console_tab.vbox, temp_str);
   } else if (!strcmp(command, "/whois")) {
      /* not supported */
      if (!user) user = user_info.user;
      temp_str = g_strdup_printf("Sending whois request for %s...\n",
				 user);
      gnapster_text_insert(console_tab.text, console_tab.vbox, temp_str);
      napster_send(conn_info.sock, NAPSTER_WHOIS_REQUEST, user);
   } else if (!strcmp(command, "/msg")) {
      if (!user || !message) {
	 temp_str = 
	   strdup("Supported Commands:\n * /whois [user] - Prints user information from the server\n * /msg <user> <message> - Sends a message to the specified user\n");
      } else {
	 char *temp_str2;
	 temp_str = g_strdup_printf("-> [%s] %s\n", user, message);
	 temp_str2 = g_strdup_printf("%s %s", user, message);
	 napster_send(conn_info.sock, NAPSTER_USER_MESSAGE, temp_str2);
	 free(temp_str2);
      }
      gnapster_text_insert(console_tab.text, console_tab.vbox, temp_str);
   } else {
      temp_str = strdup("* Error: unknown command (try /help)\n");
      gnapster_text_insert(console_tab.text, console_tab.vbox, temp_str);
   }
   if (command) free(command);
   if (temp_str) free(temp_str);
}

void chat_activate_cb() {
   char *chat_text, *command, *message;
   char *temp_str = NULL;
   
   chat_text = gtk_entry_get_text(GTK_ENTRY(chat_tab.entry));
   if (!chat_text || !conn_info.connected) return;
   
   command = strdup(chat_text);
   message = strchr(command, ' ');
   if (message) {
      message[0] = '\0';
      message++;
   }
   
   gtk_entry_set_text(GTK_ENTRY(chat_tab.entry), "");
   
   if (!strcmp(command, "/join")) {
      if (user_info.chan) return;
      if (!message)
	temp_str = g_strdup_printf("* Error: No channel given\n");
      else {
	 temp_str = g_strdup_printf("Joining %s...\n", message);
	 napster_send(conn_info.sock, NAPSTER_JOIN_CHAN, message);
      }
      gnapster_text_insert(chat_tab.text, chat_tab.vbox, temp_str);
      free(temp_str);
   } else if (!strcmp(command, "/part")) {
      if (user_info.chan) {
	 napster_send(conn_info.sock, NAPSTER_PART_CHAN, user_info.chan);
	 temp_str = g_strdup_printf("Leaving %s...\n", user_info.chan);
	 gnapster_text_insert(chat_tab.text, chat_tab.vbox, temp_str);
	 free(temp_str);
	 free(user_info.chan);
	 user_info.chan = NULL;
	 gtk_clist_clear(GTK_CLIST(chat_tab.clist));
      }
   } else {
      printf("%s\n", chat_text);
      temp_str = g_strdup_printf("%s %s", user_info.chan, chat_text);
      napster_send(conn_info.sock, NAPSTER_CHAN_MESSAGE, temp_str);
      free(temp_str);
   }
   
   if (command) free(command);
}

void search_activate_cb() {
   char *string;
   char *temp_str;
   
   if (GTK_CLIST(search_tab.clist)->freeze_count || !conn_info.connected) return;
   
   string = gtk_entry_get_text(GTK_ENTRY(search_tab.entry));

   gnapster_update_status("Searching...", 1);
   temp_str = g_strdup_printf("FILENAME CONTAINS \"%s\" MAX_RESULTS 50", string);
   napster_send(conn_info.sock, NAPSTER_SEARCH, temp_str);
   free(temp_str);
   
   gtk_clist_clear(GTK_CLIST(search_tab.clist));
   gtk_clist_freeze(GTK_CLIST(search_tab.clist));
   gtk_entry_set_editable(GTK_ENTRY(search_tab.entry), FALSE);
}

void browse_user_menu(GtkWidget *clist) {
   void *temp;
   GList *selection;
   char user[1024];
   
   if (!conn_info.connected) return;
   
   selection = GTK_CLIST(clist)->selection;
   if (!selection) return;
   
   temp = gtk_clist_get_row_data(GTK_CLIST(clist), (int)selection->data);
   if (!temp) return;
   
   if (clist == search_tab.clist) {
      NAP_SEARCH *search = (NAP_SEARCH *)temp;
      g_snprintf(user, sizeof(user) - 1, search->user);
   } else if (clist == download_tab.clist) {
      NAP_DOWNLOAD *download = (NAP_DOWNLOAD *)temp;
      g_snprintf(user, sizeof(user) - 1, download->user);
   }

   gnapster_update_status("Retrieving mp3 list...", 1);
   napster_send(conn_info.sock, NAPSTER_BROWSE, user);
   
   gtk_clist_clear(GTK_CLIST(search_tab.clist));
   gtk_clist_freeze(GTK_CLIST(search_tab.clist));
   gtk_entry_set_editable(GTK_ENTRY(search_tab.entry), FALSE);
}

void browse_user_menu_cb1() {
   browse_user_menu(search_tab.clist);
}

void browse_user_menu_cb2() {
   browse_user_menu(download_tab.clist);
}

void browse_user_cb() {
   char *string;
   
   if (GTK_CLIST(search_tab.clist)->freeze_count || !conn_info.connected) return;
   
   string = gtk_entry_get_text(GTK_ENTRY(search_tab.entry));
   if (!string) return;
   
   gnapster_update_status("Retrieving mp3 list...", 1);
   napster_send(conn_info.sock, NAPSTER_BROWSE, string);
   
   gtk_clist_clear(GTK_CLIST(search_tab.clist));
   gtk_clist_freeze(GTK_CLIST(search_tab.clist));
   gtk_entry_set_editable(GTK_ENTRY(search_tab.entry), FALSE);
}

void connect_cb() {
   if (conn_info.connected) return;
   if (!user_info.user) {
      gnapster_update_status("Please edit your preferences before attempting to connect!", 0);
      return;
   }
   
   close(conn_info.sock);
   if (conn_info.sock_input) gdk_input_remove(conn_info.sock_input);
   conn_info.connected = 0;
   conn_info.connecting = 1;
   
   gnapster_update_status("Finding best host...", 1);
   napster_get_best_host();
}

void disconnect_cb() {
   if (!conn_info.connected) return;
   
   close(conn_info.sock);
   if (conn_info.sock_input) gdk_input_remove(conn_info.sock_input);
   conn_info.connected = 0;
   conn_info.connecting = 0;
   
   gnapster_update_status("Disconnected", 0);
   gtk_text_set_point(GTK_TEXT(motd_tab.text), 0);
   gtk_text_forward_delete(GTK_TEXT(motd_tab.text), 
			   gtk_text_get_length(GTK_TEXT(motd_tab.text)));
}

void download_cb() {
   NAP_SEARCH *temp;
   GtkWidget *clist = (GtkWidget *)search_tab.clist;
   GList *selection;
   char temp_str[1024];
   
   selection = GTK_CLIST(clist)->selection;
   if (!selection) return;
   
   temp = gtk_clist_get_row_data(GTK_CLIST(clist), (int)selection->data);
   if (!temp) return;

   sprintf(temp_str, "Sending download request to %s...\n", 
	   temp->user);
   gnapster_text_insert(console_tab.text, console_tab.vbox, temp_str);
   
   sprintf(temp_str, "%s \"%s\"", temp->user, temp->file);
   napster_send(conn_info.sock, NAPSTER_GET, temp_str);
}

void cancel_download_cb() {
   NAP_DOWNLOAD *temp;
   GtkWidget *clist = (GtkWidget *)download_tab.clist;
   GList *selection;
   
   selection = GTK_CLIST(clist)->selection;
   if (!selection) return;
   
   temp = gtk_clist_get_row_data(GTK_CLIST(clist), (int)selection->data);
   if (!temp) return;

   gtk_clist_remove(GTK_CLIST(clist),
		    gtk_clist_find_row_from_data(GTK_CLIST(clist), temp));
   gdk_input_remove(temp->sock_input);
   fclose(temp->fdesc);
   close(temp->sock);
   free(temp);
}

void cancel_remove_cb() {
   NAP_DOWNLOAD *temp;
   GtkWidget *clist = (GtkWidget *)download_tab.clist;
   GList *selection;
   
   selection = GTK_CLIST(clist)->selection;
   if (!selection) return;
   
   temp = gtk_clist_get_row_data(GTK_CLIST(clist), (int)selection->data);
   if (!temp) return;

   gtk_clist_remove(GTK_CLIST(clist),
		    gtk_clist_find_row_from_data(GTK_CLIST(clist), temp));
   gdk_input_remove(temp->sock_input);
   fclose(temp->fdesc);
   unlink(temp->fpath);
   close(temp->sock);
   free(temp);   
}

void preferences_changed_cb() {
   if (!prop_dlg.window) return;
   gnome_property_box_changed(GNOME_PROPERTY_BOX(prop_dlg.window));
}

void preferences_button_cb(GtkWidget *widget, gint arg1, gpointer data) {
   char *user, *pass, *download_dir;
   
   user = gtk_entry_get_text(GTK_ENTRY(prop_dlg.user_entry));
   pass = gtk_entry_get_text(GTK_ENTRY(prop_dlg.pass_entry));
   download_dir = gtk_entry_get_text(GTK_ENTRY(gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(prop_dlg.download_dir))));
   
   if (!strlen(user) || !strlen(pass) || !strlen(download_dir)) {
      gnapster_update_status("Form not complete!  Make sure you fill in everything!", 0);
      return;
   }
   
   gnome_config_set_string("/gnapster/User/user", user);
   gnome_config_set_string("/gnapster/User/pass", pass);
   gnome_config_set_string("/gnapster/User/dl_dir", download_dir);
   gnome_config_set_int("/gnapster/User/connection", 0);
   gnome_config_set_int("/gnapster/User/name_fix", user_info.name_fix);
   gnome_config_sync();
   
   user_info.user = gnome_config_get_string("/gnapster/User/user");
   user_info.pass = gnome_config_get_string("/gnapster/User/pass");
   user_info.download_dir = gnome_config_get_string("/gnapster/User/dl_dir");
   user_info.connection = gnome_config_get_int("/gnapster/User/connection");
   user_info.name_fix = gnome_config_get_int("/gnapster/User/name_fix");
   
   if (!conn_info.connected)
     gnapster_update_status("Not connected (use the file menu to connect)", -1);
}

void preferences_destroy_cb(GtkWidget *widget, gint arg1, gpointer data) {
   prop_dlg.window = NULL;
}

void preferences_clicked_cb(GtkWidget *widget, int *data) {
   *data = !*data;
   preferences_changed_cb();
}

void preferences_cb() {
   if (prop_dlg.window) return;
   
   create_prop_dlg(preferences_changed_cb,
		   preferences_button_cb,
		   preferences_destroy_cb,
		   preferences_clicked_cb,
		   &(user_info.new_user));
   gtk_widget_show_all(prop_dlg.window);
}

void about_cb() {
   GtkWidget *about_box;
   const char *authors[] = { "jasta <jasta@gotlinux.org>", NULL };
   
   about_box = gnome_about_new(_("Gnapster"), VERSION,
			       _("Copyright (C) 1999 Josh Guilfoyle"),
			       authors,
			       _("Napster (online mp3 community) client written for GNOME"),
			       NULL);
   gtk_widget_show(about_box);
}
