/*
 * Copyright (c) 1996 University College London
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Computer Science
 *      Department at University College London
 * 4. Neither the name of the University nor of the Department may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <stdio.h>
#include "prototypes.h"
#ifndef INADDR_NONE
#define INADDR_NONE     0xffffffff
#endif



unsigned long inaddr;
unsigned int large_bufsize = 50000;
int his_addr;			/*net byte order remote addr to receive from */


int tx_sock_init(dhost, videoserverport, t_flag)
char *dhost;			/* Default Multicast Address. */
int videoserverport;
int t_flag;
{
    struct sockaddr_in sinme, sinhim;
    char *dhosta = NULL;
    struct hostent *addr;
#ifdef WIN32
    int ttl;
#else
    unsigned char ttl;
#endif

    int tmp_int_fd;

    ttl = t_flag;
    if (*dhost == 0) {
	gethostname(dhosta, MAXHOSTNAMELEN);
	strcpy(dhost, dhosta);
    }
    if ((tmp_int_fd = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
	perror("socket");
	exit(-1);
    }
    memset((char *) &sinme, 0, sizeof(sinme));
    memset((char *) &sinhim, 0, sizeof(sinhim));

    if ((inaddr = inet_addr(dhost)) != INADDR_NONE) {
	/* it's dotted-decimal */
	memcpy((char *) &sinhim.sin_addr.s_addr, (char *) &inaddr, sizeof(inaddr));
	memcpy((char *) &sinme.sin_addr.s_addr, (char *) &inaddr, sizeof(inaddr));
	sinhim.sin_family = AF_INET;
    } else {
	if ((addr = gethostbyname(dhost)) == NULL) {
	    perror("bad hostname");
	    exit(-1);
	}
	sinhim.sin_family = addr->h_addrtype;
	sinhim.sin_family = AF_INET;
#ifdef h_addr
	memcpy((char *) &sinhim.sin_addr, addr->h_addr_list[0], addr->h_length);
	memcpy((char *) &sinme.sin_addr, addr->h_addr_list[0], addr->h_length);
#else				/* h_addr */
	memcpy((char *) &sinhim.sin_addr, addr->h_addr, addr->h_length);
	memcpy((char *) &sinme.sin_addr, addr->h_addr, addr->h_length);
#endif				/* h_addr */
    }

    sinme.sin_family = AF_INET;
    sinme.sin_port = 0;
    sinme.sin_addr.s_addr = htonl(INADDR_ANY);
    sinhim.sin_port = htons(videoserverport);

    if (bind(tmp_int_fd, (struct sockaddr *) &sinme, sizeof(sinme)) < 0) {
	perror("bind");
	exit(-1);
    }
    /* associate dest addr with socket */
    if (connect(tmp_int_fd, (struct sockaddr *) &sinhim, sizeof(struct sockaddr_in)) < 0) {
	perror("connect");
	fprintf(stderr, "Dest Address problem\n");
	exit(-1);
    }
    if (setsockopt(tmp_int_fd, IPPROTO_IP, IP_MULTICAST_TTL, &ttl, sizeof(ttl)) < 0) {
	perror("setsockopt IP_MULTICAST_TTL\n");
	exit(-1);
    }
    return (tmp_int_fd);
}

int rx_sock_init(dhost, videoserverport, t_flag)
char *dhost;			/*host or multicast address to receive from */
int videoserverport;
int t_flag;
{
    struct sockaddr_in sinme, sinhim;
    char *dhosta = NULL;
    struct hostent *addr;
    int one = 1;
    static int tmp_int_fd;
#ifdef WIN32
    int ttl = t_flag;
#else
    UNUSED(t_flag);
#endif

    debug("setting up nreceive socket: >%s<, %d, %d\n", dhost, videoserverport, t_flag);
    memset((char *) &sinme, 0, sizeof(sinme));
    memset((char *) &sinhim, 0, sizeof(sinhim));

    if (*dhost == 0) {
	gethostname(dhosta, MAXHOSTNAMELEN);
	strcpy(dhost, dhosta);
    }
    if (tmp_int_fd != 0)
	close(tmp_int_fd);
    if ((tmp_int_fd = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
	perror("socket");
	exit(-1);
    }
    /*   setbuf(fd, (char *) NULL) ; *//* Turn off buffering */
    /* Instead we want to have a buffer holding lots of frames, */
    /* so that we have no delay in reading the next frame. */
    if (setsockopt(tmp_int_fd, SOL_SOCKET, SO_RCVBUF,
		   (char *) &large_bufsize, sizeof(large_bufsize)) < 0) {
	perror("setting receive buffer");
	exit(-1);
    }
    if ((inaddr = inet_addr(dhost)) != INADDR_NONE) {
	/* it's dotted-decimal */
	memcpy((char *) &sinhim.sin_addr.s_addr, (char *) &inaddr, sizeof(inaddr));
	memcpy((char *) &sinme.sin_addr.s_addr, (char *) &inaddr, sizeof(inaddr));
	sinhim.sin_family = AF_INET;
    } else {
	if ((addr = gethostbyname(dhost)) == NULL) {
	    perror("bad hostname");
	    exit(-1);
	}
	sinhim.sin_family = addr->h_addrtype;
	sinhim.sin_family = AF_INET;
#ifdef h_addr
	memcpy((char *) &sinhim.sin_addr, addr->h_addr_list[0], addr->h_length);
	memcpy((char *) &sinme.sin_addr, addr->h_addr_list[0], addr->h_length);
#else				/* h_addr */
	memcpy((char *) &sinhim.sin_addr, addr->h_addr, addr->h_length);
	memcpy((char *) &sinme.sin_addr, addr->h_addr, addr->h_length);
#endif				/* h_addr */
    }

    /* Set the socket up to be reusable */
    if (setsockopt(tmp_int_fd, SOL_SOCKET, SO_REUSEADDR,
		   (char *) &one, sizeof(one)) < 0)
	perror("rx_sock_init: setsockopt SO_REUSEADDR");

    sinme.sin_family = AF_INET;
    sinme.sin_addr.s_addr = htonl(INADDR_ANY);
    sinme.sin_port = htons(videoserverport);
    debug("attempting bind to %x, %d, %d\n", htonl(sinme.sin_addr.s_addr), htons(sinme.sin_port), sinme.sin_family);

    if (bind(tmp_int_fd, (struct sockaddr *) &sinme, sizeof(sinme)) < 0) {
	perror("bind");
	exit(-1);
    }
    sinme.sin_family = AF_INET;
    sinme.sin_port = htons(videoserverport);
    if (atoi(dhost) >= 224) {	/* it's multicast group */
	debug("join ip group: %s\n", dhost);
	joinipgroup(tmp_int_fd, dhost, NULL);	/* group */

    }
#ifdef NOTDEF
    if (mcast == 0) {
	/* associate src addr with socket */
	printf("attempting connect to %x, %d, %d\n", sinhim.sin_addr.s_addr,
	       sinhim.sin_port, sinhim.sin_family);
	printf("Unicast, so doing connect\n");
	if (connect(tmp_int_fd, (struct sockaddr *) &sinhim,
		    sizeof(struct sockaddr_in)) < 0) {
	    perror("connect");
	    fprintf(stderr, "Src Address problem\n");
/*    exit(-1); */
	}
    } else {
	printf("Multicast - not doing connect\n");
    }
#endif
    his_addr = sinhim.sin_addr.s_addr;
    return (tmp_int_fd);
}

unsigned short getlocalport(int tx_fd)
{
    struct sockaddr_in local;
    int len;

    memset((char *) &local, 0, sizeof(local));
    local.sin_family = AF_INET;
    len = sizeof(local);
    if (getsockname(tx_fd, (struct sockaddr *) &local, &len) < 0) {
	perror("getsockname");
    }
    return local.sin_port;
}
