/*  oneliner
 *  Copyright (C) 1999 Jamey Sharp
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "gladesrc.h"
#include "gladesig.h"

#define MAXPATHLEN 128

void update_location(void);
GtkWidget *mainwin;

int
main (int argc, char *argv[])
{
  gtk_set_locale ();
  gtk_init (&argc, &argv);

  mainwin = create_mainwin ();

  update_location();

  gtk_container_remove (gtk_object_get_data (GTK_OBJECT(mainwin),
    "directories_menu"), gtk_object_get_data (GTK_OBJECT(mainwin), "dummy"));

  gtk_widget_show (mainwin);
  gtk_widget_set_uposition (mainwin, 0,
    gdk_screen_height() - mainwin->allocation.height);
  gtk_widget_set_usize (mainwin, gdk_screen_width(),
    mainwin->allocation.height);
  gtk_window_set_policy (GTK_WINDOW (mainwin), FALSE, FALSE, FALSE);

  gtk_main ();
  return 0;
}


void
on_main_destroy                        (GtkObject       *object,
                                        gpointer         user_data)
{
  gtk_exit(0);
}


void
on_exec                                (GtkWidget       *widget,
                                        const gpointer   cmd)
{
  if(fork() == 0)
  {
    execl("/bin/sh", "sh", "-c", cmd);
    exit(0);
  }
}


void
on_chdir                               (GtkWidget       *widget,
                                        const gpointer   cmd)
{
  chdir(cmd);
  update_location();
}


void
update_location                        ()
{
  char cwd[MAXPATHLEN];
  getcwd (cwd, MAXPATHLEN);
  gtk_label_set_text (gtk_object_get_data (GTK_OBJECT(mainwin), "location"),
    cwd);
}


void
on_command_activate                    (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget *menu;
  GtkWidget *item;
  char *cmd = gtk_editable_get_chars(editable, 0, -1);
  char *p = cmd;
  char *i;

  if(cmd == NULL) return;
  for(; *p == ' '; p++);
  for(i = p + strlen(p) - 1; *i == ' '; i--) *i = '\0';

  if(strlen(p) != 0)
  {
    gboolean chdir = FALSE;
    if(!strncmp(p, "cd ", 3))
    {
      chdir = TRUE;
      p += 2; // cut the cd part and leave just the path
      for(; *p == ' '; p++); // strip spaces again
      on_chdir(NULL, p);
      menu = gtk_object_get_data(GTK_OBJECT(mainwin), "directories_menu");
    } else {
      on_exec(NULL, p);
      menu = gtk_object_get_data(GTK_OBJECT(mainwin), "commands_menu");
    }

    if(gtk_object_get_data(GTK_OBJECT(menu), p) == NULL)
    {
      item = gtk_menu_item_new_with_label(p);
      gtk_menu_append(GTK_MENU(menu), item);
  
      if(chdir)
        gtk_signal_connect(GTK_OBJECT(item), "activate",
          GTK_SIGNAL_FUNC(on_chdir), (gpointer)strdup(p));
      else
        gtk_signal_connect(GTK_OBJECT(item), "activate",
          GTK_SIGNAL_FUNC(on_exec), (gpointer)strdup(p));
    
      gtk_widget_show(item);
      gtk_object_set_data(GTK_OBJECT(menu), p, item);
    }

    gtk_entry_set_text(GTK_ENTRY(editable), "");
  }

  g_free(cmd);
}

