/***************************************************************************
                          fixedspinbox.h  -  a spinbox for fixed numbers
                             -------------------                                         
    begin                : Tue Sep 28 1999                                           
    copyright            : (C) 1999 by David Johnson                         
    email                : arandir@meer.net                                     

    This software licensed under the Berkeley Software Distribution License
 ***************************************************************************/

#ifndef FIXEDSPINBOX_H
#define FIXEDSPINBOX_H

#include <qspinbox.h>
#include <qstring.h>
#include <qvalidator.h>

/**
  * Similar to QSpinBox, but operates with fixed decimal values.
  * WARNING: This class does not operate with floating point numbers!
  * All numbers are represented with integers. For example, the text
  * "100.00" is set, stored and returned as 10000.
  * @author David Johnson
  */
class FixedSpinBox : public QSpinBox  {
public:
	/** The constructor method.
	  * @param minValue Minimum value for the FixedSpinBox.
	  * @param maxValue Maximum value for the FixedSpinBox.
	  * @param step Step value for FixedSpinBox.
	  * @param fix Number of decimal places. For example,
	  *   if fix is 2, then 100 will be shown as 100.00 and
	  *   set, stored and returned as 10000.
	  */
	FixedSpinBox( int minValue, int maxValue, int step = 1, unsigned fix = 2, QWidget * parent = 0, const char * name = 0 );
	/** destructor */
	~FixedSpinBox();
	/** override from QSpinBox */
	virtual QString mapValueToText ( int value );
	/** override from QSpinBox */
	virtual int mapTextToValue ( bool * ok );
	
private:
	unsigned fixed;
	int divisor;
	QDoubleValidator *validator;
	QString workstring, rightstring;
	int leftint, rightint, pos;
};

#endif // FIXEDSPINBOX_H

