/***************************************************************************
                          hops.h  -  hops entry
                             -------------------                                         
    begin                : Wed Oct 20 1999                                           
    copyright            : (C) 1999 by David Johnson                         
    email                : arandir@meer.net                                     

    This software licensed under the Berkeley Software Distribution License
 ***************************************************************************/

#ifndef HOPS_H
#define HOPS_H

#include <qmap.h>
#include <qlistview.h>
#include <qstring.h>

/**
  *@author David Johnson
  */
class Hops {
public:
	/** constructor */
	Hops();
	/** full constructor */
	Hops(const QString &hname, const unsigned &hquant, const QString &hform, const unsigned &halpha, const unsigned &htime);
	/** copy constructor */
	Hops(const Hops &h);
	/** assignment operator */
	Hops operator=(const Hops &h);
	/** comparison operator */
	bool operator==(const Hops &h);
	/** destructor */
	~Hops();

	/** return name */
	QString getName();
	/** return quantity (in ounces) */
	unsigned getQuantity();
	/** return hops form */
	QString getForm();
	/** return hops alpha content */
	unsigned getAlpha();
	/** return boiling time */
	unsigned getTime();
	
	/** return precalculated values for bitterness */
	double getHBU();
		
	/** return quantity as string */
	QString getQuantityString();
	/** return alpha as string */
	QString getAlphaString();
	/** return time as string */
	QString getTimeString();
	
	/** return object as string, for serialization */
	QString serializeOut();
	/** set object to string, for serialization */
	void serializeIn(const QString &hname, const QString &hvalue);

private:
	/** format an UInt to fixed decimal */
	QString formatValue(const unsigned &value, const unsigned &fix);
	
private:
	QString name;
	unsigned quantity; // measured in pounds
	QString form;
	unsigned alpha;
	unsigned time;
	double hbu;
	
	unsigned divisor, leftuint;
	QString leftstring, rightstring;
};

typedef QValueList<Hops> HopsList;
typedef QValueList<Hops>::Iterator HopIterator;

class HopsListItem : public QListViewItem {
public:
	/** constructor */
	HopsListItem(QListView * parent, QString, QString = QString::null, QString = QString::null,
			QString = QString::null, QString = QString::null, QString = QString::null,
			QString = QString::null, QString = QString::null );
	/** destructor */
	~HopsListItem();
	/** get iterator to Hop item */
	HopIterator getHopIterator();
	/** set iterator to Hop item */
	void setHopIterator(HopIterator &it);
	/** set hop to match iterator */
	void setToIterator();
private:
	HopIterator hit;
};

#endif // HOPS_H






