/***************************************************************************
                          hopspage.cpp  -  tabbed dialog page for hops
                             -------------------                                         
    begin                : Wed Oct 20 1999                                           
    copyright            : (C) 1999 by David Johnson                         
    email                : arandir@meer.net                                     

    This software licensed under the Berkeley Software Distribution License
 ***************************************************************************/

#include "qbrewview.h"

#include "hopspage.h"

HopsPage::HopsPage(QWidget *parent, const char *name, QObject *doc, QObject *calc)
	: IngredientPage(parent, name, doc, calc)
{
	currentItem = 0;
	// setup listview
	itemsListView->addColumn(tr("Form"));
	itemsListView->addColumn(tr("Alpha"));
	itemsListView->addColumn(tr("Time"));
	itemsListView->setColumnAlignment(2, AlignRight);
	itemsListView->setColumnAlignment(3, AlignRight);
	itemsListView->setColumnAlignment(4, AlignRight);
	itemsListView->setSorting(0);
	itemsListView->setSorting(1);
	itemsListView->setSorting(2);
	itemsListView->setSorting(3);
	itemsListView->setSorting(4);
	
	// setup widgets
	quantitySpin->setSuffix(tr(" oz"));
	formLabel = new QLabel(tr("Form"), this, "formLabel");
	formComboBox = new QComboBox(true, this, "formComboBox");
	formComboBox->insertStringList(((QBrewCalc *)calcdata)->getFormsList());
	alphaLabel = new QLabel(tr("Alpha"), this, "alphaLabel");
	alphaSpin = new FixedSpinBox(0, 500, 10, 1, this, "alphaSpin");
	alphaSpin->setSuffix("%");
	timeLabel = new QLabel(tr("Time"), this, "timeLabel");
	timeSpin = new QSpinBox(0, 120, 5, this, "time");
	timeSpin->setSuffix(tr(" min"));
	
	// setup layout
	rowTwoLayout->addWidget(quantityLabel, 0);
	rowTwoLayout->addWidget(quantitySpin, 0, AlignRight);
	rowTwoLayout->addWidget(formLabel, 0);
	rowTwoLayout->addWidget(formComboBox, 0);
	rowTwoLayout->addWidget(alphaLabel, 0);
	rowTwoLayout->addWidget(alphaSpin, 0);
	rowTwoLayout->addWidget(timeLabel, 0);
	rowTwoLayout->addWidget(timeSpin, 0);
	
	rowTwoLayout->addWidget(spacer, 1);
	rowTwoLayout->addWidget(addButton, 0);
	rowTwoLayout->addWidget(applyButton, 0);
	rowTwoLayout->addWidget(removeButton, 0);
	
	// set the leftmost labels to the same minimum size
	quantityLabel->adjustSize();
	quantityLabel->setMinimumWidth(quantityLabel->width());
	itemLabel->setMinimumWidth(quantityLabel->width());
	
	// fixup tab orders
	QWidget::setTabOrder(itemCombo, quantitySpin);
	QWidget::setTabOrder(quantitySpin, formComboBox);
	QWidget::setTabOrder(formComboBox, alphaSpin);
	QWidget::setTabOrder(alphaSpin, timeSpin);

	// setup connections
	connect(itemCombo,SIGNAL(activated(const QString &)),this,SLOT(slotUpdateEntryItems(const QString &)));	
	connect(addButton, SIGNAL(clicked()), SLOT(slotAddHops()));
	connect(applyButton, SIGNAL(clicked()), SLOT(slotApplyHops()));
	connect(removeButton, SIGNAL(clicked()), SLOT(slotRemoveHops()));
	connect(itemsListView, SIGNAL(selectionChanged(QListViewItem *)), SLOT(slotItemSelected(QListViewItem *)));
	// initialize widgets with values
	slotDocumentChanged();
}

HopsPage::~HopsPage() {}

///////////////////////////////////////////////////////////////////////////////
// utility routines

void HopsPage::slotUpdateEntryItems(const QString &name)
{
	// highlight the appropriate entry in the listview, if available
	QListViewItem *item = itemsListView->firstChild();
	while (item != 0) {
		if (item->text(0) == name) {
			itemsListView->setSelected(item, true);
			// this sends the signal selectionChanged()
			return;
		}
		item = item->nextSibling();
	}
	// wasn't in the listview, update from database		
	Hops *thisHops = ((QBrewCalc *)calcdata)->getHop(name);
	quantitySpin->setValue(thisHops->getQuantity());
	formComboBox->setEditText(thisHops->getForm());
	alphaSpin->setValue(thisHops->getAlpha());
	timeSpin->setValue(thisHops->getTime());
}

void HopsPage::updateListView()
{
	HopsList *list = ((QBrewDoc *)document)->getHopsList();
    HopIterator it;
    HopsListItem *item;
	itemsListView->clear();
    for (it=list->begin(); it != list->end(); ++it) {
    	item = new HopsListItem( itemsListView, (*it).getName(),
    		(*it).getQuantityString(),
    		(*it).getForm(),
    		(*it).getAlphaString(),
    		(*it).getTimeString() );    	
		item->setHopIterator(it);
    }
}

///////////////////////////////////////////////////////////////////////////////
// slots

void HopsPage::slotDocumentChanged()
{
	// received if document has changed
	itemCombo->clear();
	itemCombo->insertStringList(((QBrewCalc *)calcdata)->getHopsList());
	slotUpdateEntryItems(itemCombo->currentText());
	updateListView();
}

void HopsPage::slotAddHops()	
{
    HopIterator it;
    HopsListItem *item;
	it = ((QBrewDoc *)document)->addHop(itemCombo->currentText(), quantitySpin->value(),
		formComboBox->currentText(), alphaSpin->value(), timeSpin->value());
    item = new HopsListItem( itemsListView, (*it).getName(),
    	(*it).getQuantityString(),
    	(*it).getForm(),
    	(*it).getAlphaString(),
    	(*it).getTimeString() );
	item->setHopIterator(it);
}

void HopsPage::slotApplyHops()	
{
 	if (currentItem != 0) {
		((QBrewDoc *)document)->applyHop(currentItem->getHopIterator(), itemCombo->currentText(), quantitySpin->value(),
			formComboBox->currentText(), alphaSpin->value(), timeSpin->value());
		currentItem->setToIterator();
	}
}

void HopsPage::slotRemoveHops()	
{
	if (currentItem != 0) {
		((QBrewDoc *)document)->removeHop(currentItem->getHopIterator());
		delete currentItem;
		currentItem = 0;
	}
}

void HopsPage::slotItemSelected(QListViewItem *item)
{
	currentItem = (HopsListItem *)item;
	if (item != 0) {
		itemCombo->setEditText(item->text(0));
		quantitySpin->setValue(item->text(1).remove(item->text(1).find('.'), 1).toUInt());
		formComboBox->setEditText(item->text(2));
		alphaSpin->setValue(item->text(3).remove(item->text(3).find('.'), 1).toUInt());
		timeSpin->setValue(item->text(4).toUInt());
	}
}






