/***************************************************************************
                          qbrewdoc.h  -  client document class for QBrew
                             -------------------
    begin                : September 20th, 1999
    copyright            : (C) 1999 by David Johnson
    email                : arandir@meer.net

    This software licensed under the Berkeley Software Distribution License
 ***************************************************************************/

#ifndef QBREWDOC_H
#define QBREWDOC_H

// include files for QT
#include <qobject.h>
#include <qstring.h>

// include application specific files
#include "store.h"
#include "grain.h"
#include "hops.h"
#include "miscingredient.h"

/**
  * the Document Class
  */

class QBrewDoc : public QObject  {
	Q_OBJECT
public:
	/** constructor */
	QBrewDoc(QWidget *parent=0);
	/** destructor */
	~QBrewDoc();
	
	/** create a new document */
	void newDoc();
	/** save the document into named file */
	bool save(const QString &fname);
	/** load a document */
	bool load(const QString &fname);
	/** has the document been modified */
	bool isModified();
	/** is the document new? */
	bool isNew();
	
	/** add a new grain to the grain list */
	GrainIterator addGrain(const QString &gname, const unsigned &gquant, const unsigned &gextr,
				const unsigned &gcolor, const QString &guse);
	/** apply a new grain to the grain list */
	void applyGrain(GrainIterator it, const QString &gname, const unsigned &gquant, const unsigned &gextr,
				const unsigned &gcolor, const QString &guse);
	/** remove a grain from the grain list */
	void removeGrain(GrainIterator it);
	/** return a copy of the grain list */
	GrainList *getGrainList();	
	
	/** add a new hop to the hops list */
	HopIterator addHop(const QString &hname, const unsigned &hquant, const QString &hform,
				const unsigned &halpha, const unsigned &htime);
	/** apply a new hop to the hops list */
	void applyHop(HopIterator it, const QString &hname, const unsigned &hquant, const QString &hform,
				const unsigned &halpha, const unsigned &htime);
	/** remove a hop from the hops list */
	void removeHop(HopIterator it);
	/** return a copy of the hops list */
	HopsList *getHopsList();	

	/** add a new misc ingredient to the misc list */
	MiscIngredientIterator addMiscIngredient(const QString &mname, const unsigned &mquant, const QString &mnotes);
	/** apply a new misc ingredient to the misc list */
	void applyMiscIngredient(MiscIngredientIterator it, const QString &mname, const unsigned &mquant, const QString &mnotes);
	/** remove a misc ingredient from the misc list */
	void removeMiscIngredient(MiscIngredientIterator it);
	/** return a copy of the misc list */
	MiscIngredientList *getMiscIngredientList();	

signals:
	/** sends if document has changed (created, loaded) */
	void documentChanged();
	/** sends if document has been modified */
	void documentModified();
	/** sends if document needs to be recalculated */
	void recalc();
	/** sends if the style has changed */
	void styleChanged();

public slots:	// document/view linkages	
	/** set recipe title */
	void setTitle(const QString &stitle);
	/** set brewer */
	void setBrewer(const QString &sbrewer);
	/** set recipe style */
	void setStyle(const QString &sstyle);
	/** set recipe style */
	void setSize(int ssize);
	/** set mash flag */
	void setMash(bool smash);
	
public:			// document member access
	/** get recipe title */
	const QString getTitle();
	/** get brewer's name */
	const QString getBrewer();
	/** get recipe style */
	const QString getStyle();
	/** get recipe style */
	const int getSize();
	/** get whether batch is mashed */
	const bool getMash();

private:
	/** initialize serialization */
	void initSerialization();
	/** load recipe data */
	void processRecipe(const QString &fname, const QString &fvalue);
	/** load grain data */
	void processGrain(const QString &fname, const QString &fvalue);
	/** load hops data */
	void processHops(const QString &fname, const QString &fvalue);
	/** load misc ingredient data */
	void processMiscIngredient(const QString &fname, const QString &fvalue);
	
private:
	// the serialization group map
	QMap<QString, int> gmap;
	// the serialization field map
	QMap<QString, int> fmap;
	// the recipe file
	Store *rfile;
	// the parent application
	QWidget *application;
	
	bool b_modified;
	bool b_new;
	
	QString title;		// title of recipe
	QString brewer;		// name of brewer
	QString style;		// style of recipe
	int size;			// batch size
	bool mash;			// is the batch mashed?
	GrainList grainlist;	// list of grains
	HopsList hopslist;		// list of hops
	MiscIngredientList misclist;	// list of misc ingredients
};

#endif // QBREWDOC_H











































