// 
// $Id: qaregexprange.cpp,v 1.2 1999/07/19 02:36:55 amos Exp $
//
// Implementation of QaRegExpRange class
//
// Jan Borsodi <amos@ez.no>
// Created on: <15-Jul-1999 13:42:57 amos>
//


#include "qaregexprange.hpp"
#include <qstring.h>

/*!
  \class QaRegExpRange qaregexprange.hpp
  \brief Holds a start and end offset for a given regexp match.

  A simple tool class for keeping a start and end offset and for extracting the correct substring from a given string.
  It also makes sure the start offset is smaller than the end offset, they are swapped if needed.

*/

/*!
  Creates a range with start and end equal to -1
*/

QaRegExpRange::QaRegExpRange()
{
    Start = -1;
    End = -1;
}

/*!
  Creates a range with given start end end offset.
*/

QaRegExpRange::QaRegExpRange( int soffs, int eoffs )
{
    if ( eoffs < soffs )
    {
        Start = eoffs;
        End = soffs;
    }
    else
    {
        Start = soffs;
        End = eoffs;
    }
}

/*!
  Destroys the object
*/

QaRegExpRange::~QaRegExpRange()
{
}

/*!
  \return The start offset.
*/

int QaRegExpRange::start() const
{
    return Start;
}

/*!
  \return The end offset.
*/

int QaRegExpRange::end() const
{
    return End;
}

/*!
  \return The length of the offset, 0 means start and end are equal.
*/

int QaRegExpRange::length() const
{
    return End-Start;
}

/*!
  Sets the start offset, if it is larger than the end offset it used as end
  and the previous end is used as start.
*/

void QaRegExpRange::setStart( int s )
{
    if ( s == Start )
        return;
    if ( s > End )
    {
        Start = End;
        End = s;
    }
    else
        Start = s;
}

/*!
  Sets the end offset, if it is smaller than the start offset it used as start
  and the previous start is used as end.
*/

void QaRegExpRange::setEnd( int e )
{
    if ( e == End )
        return;
    if ( e < Start )
    {
        End = Start;
        Start = e;
    }
    else
        End = e;
}

/*!
  \return The substring of the given string.
*/

QString QaRegExpRange::stringRange( const QString &s ) const
{
    return s.mid( start(), length() );
}

/*!
  Moves both start and end offset by i places.
*/

QaRegExpRange &QaRegExpRange::operator +=( int i )
{
    Start += i;
    End += i;
    return *this;
}

/*!
  Moves both start and end offset by i places.
*/

QaRegExpRange &QaRegExpRange::operator -=( int i )
{
    Start -= i;
    End -= i;
    return *this;
}
