# Note that this is NOT a relocatable package
%define ver 0.99.6.1
%define rel 1
%define prefix /usr

Name: scwm
Summary: The Scheme Constraints Window Manager.
Version: %ver
Release: %rel
Source: ftp://scwm.mit.edu/pub/scwm/scwm-%ver.tar.gz
Group: X11/Window Managers
BuildRoot: /tmp/scwm-%ver-build
Copyright: Copyright (C) 1997,1998,1999,2000 Greg J. Badros, Maciej Stachowiak, et al.
Packager: Greg J. Badros <gjb@cs.washington.edu> and Maciej Stachowiak <mstachow@alum.mit.edu>
URL: http://scwm.mit.edu
Distribution: scwm
Requires: guile >= 1.3.4
Requires: guile-gtk >= 0.16
Requires: imlib >= 1.9
Requires: esound >= 0.2.7
Requires: cassowary-constraint-solver

Docdir: %{prefix}/doc

%description

Scwm is the Scheme Constraints Window Manager, a highly dynamic and
extensible window manager for the X Window System.  Scwm embeds Guile
Scheme as the configuration and extension language, and includes a
sophisticated constraint solver for permitting the user to interactively
specify constraints among top-level window sizes and positions.  Nearly
all decorations can be changed at run-time on a per-window basis.
Dynamic loading of C modules is supported.  Scwm is self-documenting and
provides A powerful protocol for interacting with the window manager
from other processes

%changelog
* Sat Sep 25 1999  Greg J. Badros <gjb@cs.washington.edu>
- Updated for Scwm-0.99.3, removed gjb.scwmrc from filelist.

* Sun Aug 22 1999  Greg J. Badros <gjb@cs.washington.edu>
- Updates to the description, general cleanup of package to get
  rpm building to be less painful and more complete

* Tue Feb  2 1999  Harvey Stein  <hjstein@bfr.co.il>

- Added installation of files from sample.scwmrc directory (into to
  /usr/doc/scwm-<version> directory).
- Bumped release #.
- Autobuild this file from scwm.spec.in (to have version automatically
  inserted).

* Wed Jan 27 1999  Maciej Stachowiak  <mstachow@mit.edu>

- Devolved for scwm 0.9 release.
	
* Thu Jul 31 1998 Harvey J. Stein <hjstein@bfr.co.il>

- Updated Kjetil's release.

* Wed May 06 1998 Kjetil Wiekhorst Jrgensen <jorgens@pvv.org>

- Initial release of this package.


%prep

%setup

%build
./configure --prefix=%{prefix} --enable-fsstd --with-cassowary=%{prefix}
make 

%install
make prefix=$RPM_BUILD_ROOT/%{prefix} install

%clean
rm -rf $RPM_BUILD_ROOT

%post
/sbin/ldconfig
#cd /etc/X11/xdm; patch < %{prefix}/share/scwm/Xsession.patch
install -c -m 755 %{prefix}/share/scwm/Xsession /etc/X11/xdm/Xsession
install -c -m 755 %{prefix}/share/scwm/gnome-session-Scwm /etc/X11/gdm/Sessions/Scwm

%postun
/sbin/ldconfig
#cd /etc/X11/xdm; patch -R < %{prefix}/share/scwm/Xsession.patch
#rm -f %{prefix}/utilities/misc/gnome-session-Scwm /etc/X11/gdm/Session/Scwm

%files
%defattr(-, root, root)

%{prefix}/bin/
%{prefix}/lib/libscwm*
%{prefix}/lib/scwm/
%{prefix}/info/scwm.info
%{prefix}/man/
%{prefix}/share/emacs/site-lisp/scwm.el
## GJB:FIXME:: should byte compile scwm.el in %postun
#%{prefix}/share/emacs/site-lisp/scwm.elc
%{prefix}/share/scwm/scwmrc/juhp.scwmrc
%{prefix}/share/scwm/scwmrc/mstachow.scwmrc
%{prefix}/share/scwm/scwmrc/sds.scwmrc
%{prefix}/share/scwm/scwmrc/simple.scwmrc
%config %{prefix}/share/scwm/scwmrc/system.scwmrc
%{prefix}/share/scwm/themes/
%{prefix}/share/scwm/modules/
%{prefix}/share/scwm/pixmaps/
%{prefix}/share/scwm/Xsession.patch
%{prefix}/share/scwm/gnome-session-Scwm
%{prefix}/include/
%{prefix}/share/doc/scwm/examples/Xmodmap-win95keyboard
%{prefix}/share/doc/scwm/examples/Xresources-cpp
%{prefix}/share/doc/scwm/examples/Xsession

%doc ANNOUNCE AUTHORS BUG-REPORTING BUGS COPYING.FVWM COPYING.GPL ChangeLog
%doc INSTALL NEWS README RH6-notes README-Gnome README-constraints THANKS TODO 
%doc src/ChangeLog
%doc modules/ChangeLog
%doc sample.scwmrc/ChangeLog
%doc utilities/ChangeLog
%doc doc
