/* sfm -- Simple File Manager
   Copyright (C) 1998 Pixel (Pascal Rigaux)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */
#ifndef COMMUN_H
#define COMMUN_H

#include "mymalloc.h"

#undef	MAX
#define MAX(a, b)  (((a) > (b)) ? (a) : (b))

#undef	MIN
#define MIN(a, b)  (((a) < (b)) ? (a) : (b))

#define FREE_NULL(p) if ((p) != NULL) free(p), (p) = NULL;
typedef enum { false=0, true } boolean;

extern char *socket_name;
extern char *defaultCreateDirectoryName;
extern char *defaultCreateFileName;
extern char *optionPaste;
extern char *optionCdm;
#define tmpSize 1000
#define nb_ls_colors 18
#define viewTitle "sfm #%d"


#define char_malloc(size) (char *) malloc((size) * sizeof(char))
#define int_malloc(size) (int *) malloc((size) * sizeof(int))
#define pchar_malloc(size) (char **) malloc((size) * sizeof(char *))

#define char_realloc(p, size) *(p) = (char *) realloc((void *) *(p), (size) * sizeof(char))
#define int_realloc(p, size) *(p) = (int *) realloc((void *) *(p), (size) * sizeof(int))
#define pchar_realloc(p, size) *(p) = (char **) realloc((void *) *(p), (size) * sizeof(char *))

extern void pchar_free(char **p, int size);
extern void char_replace(char **p, char *a);


extern boolean makeboolean(int b);
extern int myCeil(int i, int a);
extern void warn(char *msg);
extern void die(char *msg);

extern void char_swap(char **a, char **b);

extern boolean streq(char *a, char *b);
extern boolean strput(char *p, char *a, char *b, int size);
extern boolean strput3(char *p, char *a, char *b, char *c, int size);
extern boolean strbeginswith(char *a, char *prefix);
extern boolean strendswith(char *a, char *prefix);
extern boolean strendswith_nocase(char *a, char *suffix);
extern char *pchar2char(char **tab, int nb, char *sep);

extern void chop(char *p);
extern char *strend(char *a);
extern int lastchar(char *a);
extern int common_chars(char *a, char *b);
extern char *expandEnvVars(char *a);
extern char *skip_spaces(char *p);
extern char *remove_bording_spaces(char *p);

extern void init_line_by_line_read();
extern void end_line_by_line_read();
extern char *line_by_line_read(int fd);

extern void send_msg(int fd, char *msg);
extern void send_int(int fd, int val);
extern boolean connect_server(int *fd);
extern void X_exit(int status);
extern void supprDoubleSlashes(char *p);

extern void mask_sigchild();
extern void unmask_sigchild();
extern void install_signal_handler(int signal, void (*handler)(int));

/* ls_color.c */
extern void parse_ls_color();
extern int color_of_extension(char *chaine, int mode);

/* sfm_view.c */
extern void view_warn(char *msg);



#endif
